/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.protocol.binary.TapAckOperationImpl;

public abstract class TCPMemcachedNodeImpl
extends SpyObject
implements MemcachedNode {
    protected final BlockingQueue<Operation> writeQ;
    private final SocketAddress socketAddress;
    private final ByteBuffer rbuf;
    private final ByteBuffer wbuf;
    private final BlockingQueue<Operation> readQ;
    private final BlockingQueue<Operation> inputQueue;
    private final long opQueueMaxBlockTime;
    private final long authWaitTime;
    private final ConnectionFactory connectionFactory;
    private final AtomicInteger continuousTimeout = new AtomicInteger(0);
    protected Operation optimizedOp = null;
    private AtomicInteger reconnectAttempt = new AtomicInteger(1);
    private SocketChannel channel;
    private int toWrite = 0;
    private SelectionKey sk = null;
    private boolean shouldAuth = false;
    private CountDownLatch authLatch;
    private ArrayList<Operation> reconnectBlocked;
    private long defaultOpTimeout;
    private volatile long lastReadTimestamp = System.nanoTime();
    private MemcachedConnection connection;

    public TCPMemcachedNodeImpl(SocketAddress sa, SocketChannel c, int bufSize, BlockingQueue<Operation> rq, BlockingQueue<Operation> wq, BlockingQueue<Operation> iq, long opQueueMaxBlockTime, boolean waitForAuth, long dt, long authWaitTime, ConnectionFactory fact) {
        if (sa == null) {
            throw new IllegalArgumentException("No SocketAddress");
        }
        if (c == null) {
            throw new IllegalArgumentException("No SocketChannel");
        }
        if (bufSize <= 0) {
            String msg = String.format("Invalid buffer size: %d", bufSize);
            throw new IllegalArgumentException(msg);
        }
        if (rq == null) {
            throw new IllegalArgumentException("No operation read queue");
        }
        if (wq == null) {
            throw new IllegalArgumentException("No operation write queue");
        }
        if (iq == null) {
            throw new IllegalArgumentException("No input queue");
        }
        this.socketAddress = sa;
        this.connectionFactory = fact;
        this.authWaitTime = authWaitTime;
        this.setChannel(c);
        this.rbuf = ByteBuffer.allocateDirect(bufSize);
        this.wbuf = ByteBuffer.allocateDirect(bufSize);
        this.getWbuf().clear();
        this.readQ = rq;
        this.writeQ = wq;
        this.inputQueue = iq;
        this.opQueueMaxBlockTime = opQueueMaxBlockTime;
        this.shouldAuth = waitForAuth;
        this.defaultOpTimeout = dt;
        this.setupForAuth();
    }

    public final void copyInputQueue() {
        ArrayList tmp = new ArrayList();
        this.inputQueue.drainTo(tmp, this.writeQ.remainingCapacity());
        this.writeQ.addAll(tmp);
    }

    public Collection<Operation> destroyInputQueue() {
        ArrayList<Operation> rv = new ArrayList<Operation>();
        this.inputQueue.drainTo(rv);
        return rv;
    }

    public final void setupResend() {
        Operation op = this.getCurrentWriteOp();
        if (this.shouldAuth && op != null) {
            op.cancel();
        } else if (op != null) {
            ByteBuffer buf = op.getBuffer();
            if (buf != null) {
                buf.reset();
            } else {
                this.getLogger().info((Object)"No buffer for current write op, removing");
                this.removeCurrentWriteOp();
            }
        }
        while (this.hasReadOp()) {
            op = this.removeCurrentReadOp();
            if (op == this.getCurrentWriteOp()) continue;
            this.getLogger().warn("Discarding partially completed op: %s", new Object[]{op});
            op.cancel();
        }
        while (this.shouldAuth && this.hasWriteOp()) {
            op = this.removeCurrentWriteOp();
            this.getLogger().warn("Discarding partially completed op: %s", new Object[]{op});
            op.cancel();
        }
        this.getWbuf().clear();
        this.getRbuf().clear();
        this.toWrite = 0;
    }

    private boolean preparePending() {
        this.copyInputQueue();
        Operation nextOp = this.getCurrentWriteOp();
        while (nextOp != null && nextOp.isCancelled()) {
            this.getLogger().info("Removing cancelled operation: %s", new Object[]{nextOp});
            this.removeCurrentWriteOp();
            nextOp = this.getCurrentWriteOp();
        }
        return nextOp != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fillWriteBuffer(boolean shouldOptimize) {
        if (this.toWrite == 0 && this.readQ.remainingCapacity() > 0) {
            this.getWbuf().clear();
            Operation o = this.getNextWritableOp();
            while (o != null && this.toWrite < this.getWbuf().capacity()) {
                Operation operation = o;
                synchronized (operation) {
                    assert (o.getState() == OperationState.WRITING);
                    ByteBuffer obuf = o.getBuffer();
                    assert (obuf != null) : "Didn't get a write buffer from " + o;
                    int bytesToCopy = Math.min(this.getWbuf().remaining(), obuf.remaining());
                    byte[] b = new byte[bytesToCopy];
                    obuf.get(b);
                    this.getWbuf().put(b);
                    this.getLogger().debug("After copying stuff from %s: %s", new Object[]{o, this.getWbuf()});
                    if (!o.getBuffer().hasRemaining()) {
                        o.writeComplete();
                        this.transitionWriteItem();
                        this.preparePending();
                        if (shouldOptimize) {
                            this.optimize();
                        }
                        o = this.getNextWritableOp();
                    }
                    this.toWrite += bytesToCopy;
                }
            }
            this.getWbuf().flip();
            assert (this.toWrite <= this.getWbuf().capacity()) : "toWrite exceeded capacity: " + (Object)((Object)this);
            assert (this.toWrite == this.getWbuf().remaining()) : "Expected " + this.toWrite + " remaining, got " + this.getWbuf().remaining();
        } else {
            this.getLogger().debug((Object)"Buffer is full, skipping");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Operation getNextWritableOp() {
        Operation o = this.getCurrentWriteOp();
        while (o != null && o.getState() == OperationState.WRITE_QUEUED) {
            Operation operation = o;
            synchronized (operation) {
                if (o.isCancelled()) {
                    this.getLogger().debug((Object)"Not writing cancelled op.");
                    Operation cancelledOp = this.removeCurrentWriteOp();
                    assert (o == cancelledOp);
                } else if (o.isTimedOut(this.defaultOpTimeout)) {
                    this.getLogger().debug((Object)"Not writing timed out op.");
                    Operation timedOutOp = this.removeCurrentWriteOp();
                    assert (o == timedOutOp);
                } else {
                    o.writing();
                    if (!(o instanceof TapAckOperationImpl)) {
                        this.readQ.add(o);
                    }
                    return o;
                }
                o = this.getCurrentWriteOp();
            }
        }
        return o;
    }

    public final void transitionWriteItem() {
        Operation op = this.removeCurrentWriteOp();
        assert (op != null) : "There is no write item to transition";
        this.getLogger().debug("Finished writing %s", new Object[]{op});
    }

    protected abstract void optimize();

    public final Operation getCurrentReadOp() {
        return (Operation)this.readQ.peek();
    }

    public final Operation removeCurrentReadOp() {
        return (Operation)this.readQ.remove();
    }

    public final Operation getCurrentWriteOp() {
        return this.optimizedOp == null ? (Operation)this.writeQ.peek() : this.optimizedOp;
    }

    public final Operation removeCurrentWriteOp() {
        Operation rv = this.optimizedOp;
        if (rv == null) {
            rv = (Operation)this.writeQ.remove();
        } else {
            this.optimizedOp = null;
        }
        return rv;
    }

    public final boolean hasReadOp() {
        return !this.readQ.isEmpty();
    }

    public final boolean hasWriteOp() {
        return this.optimizedOp != null || !this.writeQ.isEmpty();
    }

    public final void addOp(Operation op) {
        try {
            if (!this.authLatch.await(this.authWaitTime, TimeUnit.MILLISECONDS)) {
                FailureMode mode = this.connectionFactory.getFailureMode();
                if (mode == FailureMode.Redistribute || mode == FailureMode.Retry) {
                    this.getLogger().debug((Object)("Redistributing Operation " + op + " because auth latch taken longer than " + this.authWaitTime + " milliseconds to complete on node " + this.getSocketAddress()));
                    this.connection.retryOperation(op);
                } else {
                    op.cancel();
                    this.getLogger().warn((Object)("Operation canceled because authentication or reconnection and authentication has taken more than " + this.authWaitTime + " milliseconds to complete on node " + (Object)((Object)this)));
                    this.getLogger().debug("Canceled operation %s", new Object[]{op.toString()});
                }
                return;
            }
            if (!this.inputQueue.offer(op, this.opQueueMaxBlockTime, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Timed out waiting to add " + op + "(max wait=" + this.opQueueMaxBlockTime + "ms)");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting to add " + op);
        }
    }

    public final void insertOp(Operation op) {
        ArrayList<Operation> tmp = new ArrayList<Operation>(this.inputQueue.size() + 1);
        tmp.add(op);
        this.inputQueue.drainTo(tmp);
        this.inputQueue.addAll(tmp);
    }

    public final int getSelectionOps() {
        int rv = 0;
        if (this.getChannel().isConnected()) {
            if (this.hasReadOp()) {
                rv |= 1;
            }
            if (this.toWrite > 0 || this.hasWriteOp()) {
                rv |= 4;
            }
        } else {
            rv = 8;
        }
        return rv;
    }

    public final ByteBuffer getRbuf() {
        return this.rbuf;
    }

    public final ByteBuffer getWbuf() {
        return this.wbuf;
    }

    public final SocketAddress getSocketAddress() {
        if (!(this.socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.socketAddress;
        return new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
    }

    public final boolean isActive() {
        return this.reconnectAttempt.get() == 0 && this.getChannel() != null && this.getChannel().isConnected();
    }

    public boolean isAuthenticated() {
        return 0L == this.authLatch.getCount();
    }

    public final void reconnecting() {
        this.reconnectAttempt.incrementAndGet();
        this.continuousTimeout.set(0);
    }

    public final void connected() {
        this.reconnectAttempt.set(0);
        this.continuousTimeout.set(0);
    }

    public final int getReconnectCount() {
        return this.reconnectAttempt.get();
    }

    public final String toString() {
        int sops = 0;
        if (this.getSk() != null && this.getSk().isValid()) {
            sops = this.getSk().interestOps();
        }
        int rsize = this.readQ.size() + (this.optimizedOp == null ? 0 : 1);
        int wsize = this.writeQ.size();
        int isize = this.inputQueue.size();
        return "{QA sa=" + this.getSocketAddress() + ", #Rops=" + rsize + ", #Wops=" + wsize + ", #iq=" + isize + ", topRop=" + this.getCurrentReadOp() + ", topWop=" + this.getCurrentWriteOp() + ", toWrite=" + this.toWrite + ", interested=" + sops + "}";
    }

    public final void registerChannel(SocketChannel ch, SelectionKey skey) {
        this.setChannel(ch);
        this.setSk(skey);
    }

    public final SocketChannel getChannel() {
        return this.channel;
    }

    public final void setChannel(SocketChannel to) {
        assert (this.channel == null || !this.channel.isOpen()) : "Attempting to overwrite channel";
        this.channel = to;
    }

    public final SelectionKey getSk() {
        return this.sk;
    }

    public final void setSk(SelectionKey to) {
        this.sk = to;
    }

    public final int getBytesRemainingToWrite() {
        return this.toWrite;
    }

    public final int writeSome() throws IOException {
        int wrote = this.channel.write(this.wbuf);
        assert (wrote >= 0) : "Wrote negative bytes?";
        this.toWrite -= wrote;
        assert (this.toWrite >= 0) : "toWrite went negative after writing " + wrote + " bytes for " + (Object)((Object)this);
        this.getLogger().debug("Wrote %d bytes", new Object[]{wrote});
        return wrote;
    }

    public int getContinuousTimeout() {
        return this.continuousTimeout.get();
    }

    public void setContinuousTimeout(boolean timedOut) {
        if (timedOut && this.isActive()) {
            this.continuousTimeout.incrementAndGet();
        } else {
            this.continuousTimeout.set(0);
        }
    }

    public final void fixupOps() {
        SelectionKey s = this.sk;
        if (s != null && s.isValid()) {
            int iops = this.getSelectionOps();
            this.getLogger().debug("Setting interested opts to %d", new Object[]{iops});
            s.interestOps(iops);
        } else {
            this.getLogger().debug((Object)"Selection key is not valid.");
        }
    }

    public final void authComplete() {
        if (this.reconnectBlocked != null && this.reconnectBlocked.isEmpty()) {
            this.inputQueue.addAll(this.reconnectBlocked);
        }
        this.authLatch.countDown();
    }

    public final void setupForAuth() {
        if (this.shouldAuth) {
            this.authLatch = new CountDownLatch(1);
            if (this.inputQueue.isEmpty()) {
                this.reconnectBlocked = new ArrayList(this.inputQueue.size() + 1);
                this.inputQueue.drainTo(this.reconnectBlocked);
            }
            assert (this.inputQueue.isEmpty());
            this.setupResend();
        } else {
            this.authLatch = new CountDownLatch(0);
        }
    }

    public long lastReadDelta() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.lastReadTimestamp);
    }

    public void completedRead() {
        this.lastReadTimestamp = System.nanoTime();
    }

    public MemcachedConnection getConnection() {
        return this.connection;
    }

    public void setConnection(MemcachedConnection connection) {
        this.connection = connection;
    }
}

