/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.helper;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.util.QueryHisStoreUtil;
import org.apache.kylin.metadata.recommendation.candidate.JdbcRawRecStore;
import org.apache.kylin.metadata.streaming.util.StreamingJobRecordStoreUtil;
import org.apache.kylin.metadata.streaming.util.StreamingJobStatsStoreUtil;
import org.apache.kylin.tool.garbage.GarbageCleaner;
import org.apache.kylin.tool.garbage.SourceUsageCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutineToolHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoutineToolHelper.class);

    private RoutineToolHelper() {
    }

    public static void cleanQueryHistories() {
        QueryHisStoreUtil.cleanQueryHistory();
    }

    public static void cleanStreamingStats() {
        StreamingJobStatsStoreUtil.cleanStreamingJobStats();
        StreamingJobRecordStoreUtil.cleanStreamingJobRecord();
    }

    public static void deleteRawRecItems() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        List projectInstances = NProjectManager.getInstance((KylinConfig)config).listAllProjects().stream().filter(projectInstance -> !projectInstance.isExpertMode()).collect(Collectors.toList());
        if (projectInstances.isEmpty()) {
            return;
        }
        try (SetThreadName ignored = new SetThreadName("DeleteRawRecItemsInDB", new Object[0]);){
            JdbcRawRecStore jdbcRawRecStore = new JdbcRawRecStore(KylinConfig.getInstanceFromEnv());
            jdbcRawRecStore.deleteOutdated();
        }
        catch (Exception e) {
            log.error("delete outdated advice fail: ", (Throwable)e);
        }
    }

    public static void cleanGlobalSourceUsage() {
        log.info("Start to clean up global meta");
        try {
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                new SourceUsageCleaner().cleanup();
                return null;
            }, (String)"_global");
        }
        catch (Exception e) {
            log.error("Failed to clean global meta", (Throwable)e);
        }
        log.info("Clean up global meta finished");
    }

    public static void cleanMetaByProject(String projectName) {
        log.info("Start to clean up {} meta", (Object)projectName);
        try {
            GarbageCleaner.cleanMetadata(projectName);
        }
        catch (Exception e) {
            log.error("Project[{}] cleanup Metadata failed", (Object)projectName, (Object)e);
        }
        log.info("Clean up {} meta finished", (Object)projectName);
    }

    public static void cleanMeta(List<String> projectsToCleanup) {
        try {
            RoutineToolHelper.cleanGlobalSourceUsage();
            for (String projName : projectsToCleanup) {
                RoutineToolHelper.cleanMetaByProject(projName);
            }
            RoutineToolHelper.cleanQueryHistories();
            RoutineToolHelper.cleanStreamingStats();
            RoutineToolHelper.deleteRawRecItems();
            System.out.println("Metadata cleanup finished");
        }
        catch (Exception e) {
            log.error("Metadata cleanup failed", (Throwable)e);
            System.out.println("\u001b[31mMetadata cleanup failed. Detailed Message is at ${KYLIN_HOME}/logs/shell.stderr\u001b[0m");
        }
    }
}

