/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.aspect;

import java.util.Objects;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.aspect.TransactionProjectUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TransactionAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionAspect.class);

    @Pointcut(value="@annotation(transaction)")
    public void callAt(Transaction transaction) {
    }

    @Around(value="callAt(transaction)")
    public Object around(ProceedingJoinPoint pjp, Transaction transaction) throws TransactionException {
        ProjectInstance projectInstance;
        String unitName = "_global";
        if (transaction.project() != -1) {
            Object unitObject = pjp.getArgs()[transaction.project()];
            if (unitObject instanceof String) {
                unitName = unitObject.toString();
            } else if (unitObject instanceof TransactionProjectUnit) {
                unitName = ((TransactionProjectUnit)unitObject).transactionProjectUnit();
            }
        }
        if (!Objects.equals("_global", unitName) && (projectInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(unitName)) == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{unitName});
        }
        return EnhancedUnitOfWork.doInTransactionWithCheckAndRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName(unitName).readonly(transaction.readonly()).maxRetry(transaction.retry()).processor(() -> {
            try {
                return pjp.proceed();
            }
            catch (Throwable throwable) {
                throw new TransactionException(throwable);
            }
        }).build());
    }
}

