/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cache;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.rest.cache.KylinCache;
import org.apache.kylin.rest.service.CommonQueryCacheSupporter;
import org.apache.kylin.rest.util.SerializeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisMovedDataException;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.util.JedisClusterCRC16;

public class RedisCache
implements KylinCache {
    private static final Logger logger = LoggerFactory.getLogger(RedisCache.class);
    private static final String NX = "NX";
    private static final String XX = "XX";
    private static final String PREFIX = "Kylin5-";
    private static final String CHARSET_NAME = "UTF-8";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String SCAN_POINTER_START_STR = new String(ScanParams.SCAN_POINTER_START_BINARY, CHARSET);
    private static JedisPool jedisPool;
    private static JedisCluster jedisCluster;
    private static Set<String> masters;
    private String redisExpireTimeUnit;
    private long redisExpireTime;
    private long redisExpireTimeForException;
    private boolean redisClusterEnabled;
    private static final AtomicBoolean isRecovering;

    public static KylinCache getInstance() {
        try {
            return (KylinCache)Singletons.getInstance(RedisCache.class);
        }
        catch (RuntimeException e) {
            logger.error("Jedis init failed: ", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkRedisClient() {
        boolean bl;
        Jedis jedis = null;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        try {
            String result = "";
            if (!kylinConfig.isRedisClusterEnabled()) {
                jedis = jedisPool.getResource();
                result = jedis.ping();
            } else {
                RedisCache.getRedisClusterInfo();
                for (String host : masters) {
                    jedis = ((JedisPool)jedisCluster.getClusterNodes().get(host)).getResource();
                    String pong = jedis.ping();
                    if (!"PONG".equals(pong)) continue;
                    boolean bl2 = true;
                    RedisCache.close(jedis);
                    return bl2;
                }
            }
            bl = "PONG".equals(result);
        }
        catch (Exception e) {
            boolean bl3;
            try {
                logger.error("redis connect failed!", (Throwable)e);
                bl3 = false;
            }
            catch (Throwable throwable) {
                RedisCache.close(jedis);
                throw throwable;
            }
            RedisCache.close(jedis);
            return bl3;
        }
        RedisCache.close(jedis);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getRedisClusterInfo() {
        if (jedisCluster == null) {
            return;
        }
        Map clusterNodes = jedisCluster.getClusterNodes();
        StringBuilder masterNodes = new StringBuilder();
        StringBuilder slaveNodes = new StringBuilder();
        masters = Sets.newHashSet();
        Jedis resource = null;
        for (String host : clusterNodes.keySet()) {
            block7: {
                try {
                    resource = ((JedisPool)clusterNodes.get(host)).getResource();
                    if (resource.info("replication").contains("role:slave")) {
                        slaveNodes.append(host).append(" ");
                        break block7;
                    }
                    masters.add(host);
                    masterNodes.append(host).append(" ");
                }
                catch (Exception e) {
                    try {
                        logger.error("redis {} is not reachable", (Object)host);
                    }
                    catch (Throwable throwable) {
                        RedisCache.close(resource);
                        throw throwable;
                    }
                    RedisCache.close(resource);
                    continue;
                }
            }
            RedisCache.close(resource);
        }
        Preconditions.checkState((!masters.isEmpty() ? 1 : 0) != 0, (Object)"there is no master node alive for redis.");
        logger.info("redis cluster master nodes: {}", (Object)Joiner.on((String)" ").join(masters));
        logger.info("redis cluster slave node: {}", (Object)slaveNodes);
    }

    private static void close(Jedis redisClient) {
        try {
            if (redisClient != null) {
                redisClient.close();
            }
        }
        catch (Exception e) {
            logger.error("ignore error closing redis client", (Throwable)e);
        }
    }

    private RedisCache() throws JedisException {
        String[] hostAndPorts;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.redisClusterEnabled = kylinConfig.isRedisClusterEnabled();
        this.redisExpireTimeUnit = kylinConfig.getRedisExpireTimeUnit();
        this.redisExpireTime = kylinConfig.getRedisExpireTime();
        this.redisExpireTimeForException = kylinConfig.getRedisExpireTimeForException();
        String redisHosts = kylinConfig.getRedisHosts();
        String redisPassword = kylinConfig.getRedisPassword();
        if (EncryptUtil.isEncrypted((String)redisPassword)) {
            redisPassword = EncryptUtil.getDecryptedValue((String)redisPassword);
        }
        if ((hostAndPorts = redisHosts.split(",")) == null || hostAndPorts.length < 1) {
            throw new RuntimeException("redis client init failed because there are some errors in kylin.properties for 'kylin.cache.redis.hosts'");
        }
        logger.info("The 'kylin.cache.redis.cluster-enabled' is {}", (Object)this.redisClusterEnabled);
        if (kylinConfig.isRedisClusterEnabled()) {
            logger.info("ke will use redis cluster");
            HashSet hosts = Sets.newHashSet();
            for (String hostAndPort : hostAndPorts) {
                String host = hostAndPort.substring(0, hostAndPort.lastIndexOf(":"));
                int port = Integer.parseInt(hostAndPort.substring(hostAndPort.lastIndexOf(":") + 1));
                hosts.add(new HostAndPort(host, port));
            }
            GenericObjectPoolConfig config = new GenericObjectPoolConfig();
            config.setMaxTotal(kylinConfig.getRedisMaxTotal());
            config.setMaxIdle(kylinConfig.getRedisMaxIdle());
            config.setMinIdle(kylinConfig.getRedisMinIdle());
            config.setMaxWaitMillis(kylinConfig.getMaxWaitMillis());
            jedisCluster = StringUtils.isNotBlank((CharSequence)redisPassword) ? new JedisCluster((Set)hosts, kylinConfig.getRedisConnectionTimeout(), kylinConfig.getRedisSoTimeout(), kylinConfig.getRedisMaxAttempts(), redisPassword, config) : new JedisCluster((Set)hosts, kylinConfig.getRedisConnectionTimeout(), kylinConfig.getRedisSoTimeout(), kylinConfig.getRedisMaxAttempts(), config);
            logger.warn("jedis cluster is not support ping");
        } else {
            logger.info("ke will use redis pool. The redis host ke will connect to is {}", (Object)hostAndPorts[0]);
            String host = hostAndPorts[0].substring(0, hostAndPorts[0].lastIndexOf(":"));
            int port = Integer.parseInt(hostAndPorts[0].substring(hostAndPorts[0].lastIndexOf(":") + 1));
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(kylinConfig.getRedisMaxTotal());
            config.setMaxIdle(kylinConfig.getRedisMaxIdle());
            config.setMinIdle(kylinConfig.getRedisMinIdle());
            config.setTestOnBorrow(true);
            jedisPool = !StringUtils.isEmpty((CharSequence)redisPassword) ? new JedisPool((GenericObjectPoolConfig)config, host, port, kylinConfig.getRedisConnectionTimeout(), redisPassword) : new JedisPool((GenericObjectPoolConfig)config, host, port, kylinConfig.getRedisConnectionTimeout());
        }
        logger.info("Jedis init success.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KylinCache recoverInstance() {
        RedisCache cache;
        isRecovering.set(true);
        try {
            Class<RedisCache> clazz = RedisCache.class;
            synchronized (RedisCache.class) {
                logger.info("Destroy RedisCache.");
                if (jedisCluster != null) {
                    jedisCluster.close();
                }
                if (jedisPool != null) {
                    jedisPool.close();
                }
                logger.info("Initiate RedisCache.");
                cache = new RedisCache();
                // ** MonitorExit[var1] (shouldn't be in output)
            }
        }
        finally {
            isRecovering.set(false);
        }
        {
            return cache;
        }
    }

    private String getTypeProjectPrefix(String type, String project) {
        return String.format(Locale.ROOT, "%s-%s", type, project);
    }

    private boolean isExceptionQuery(String type) {
        return type.equals(CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE.rootCacheName);
    }

    public void put(String type, String project, Object key, Object value) {
        if (isRecovering.get()) {
            return;
        }
        if (this.isExceptionQuery(type)) {
            this.put(this.getTypeProjectPrefix(type, project), key, value, NX, this.redisExpireTimeUnit, this.redisExpireTimeForException);
            return;
        }
        this.put(this.getTypeProjectPrefix(type, project), key, value, NX, this.redisExpireTimeUnit, this.redisExpireTime);
    }

    public void update(String type, String project, Object key, Object value) {
        if (isRecovering.get()) {
            return;
        }
        if (this.isExceptionQuery(type)) {
            this.put(this.getTypeProjectPrefix(type, project), key, value, XX, this.redisExpireTimeUnit, this.redisExpireTimeForException);
            return;
        }
        this.put(this.getTypeProjectPrefix(type, project), key, value, XX, this.redisExpireTimeUnit, this.redisExpireTime);
    }

    public void put(String type, Object key, Object value, String expireTimeUnit, long expireTime) {
        this.put(type, key, value, NX, expireTimeUnit, expireTime);
    }

    public void put(String type, Object key, Object value, String nx, String expireTimeUnit, long expireTime) {
        byte[] realKey = this.convertKeyToByte(type, key);
        byte[] valueBytes = this.convertValueToByte(value);
        if (this.redisClusterEnabled) {
            if (jedisCluster == null) {
                logger.error("[Redis cache log] Jedis Cluster failed to initiate.");
                return;
            }
            jedisCluster.set(realKey, valueBytes, this.getJedisSetParams(nx, expireTimeUnit, expireTime));
        } else {
            this.singleRedisPut(realKey, valueBytes, expireTimeUnit, expireTime);
        }
    }

    private void singleRedisPut(byte[] key, byte[] value, String expireTimeUnit, long expireTime) {
        try (Jedis redisClient = jedisPool.getResource();){
            if (redisClient.exists(key).booleanValue()) {
                redisClient.del(key);
            }
            redisClient.set(key, value, this.getJedisSetParams(NX, expireTimeUnit, expireTime));
        }
    }

    private SetParams getJedisSetParams(String ifExist, String expireTimeUnit, Long expireTime) {
        SetParams params = new SetParams();
        if (expireTimeUnit.equals("EX")) {
            params.ex(expireTime.longValue());
        } else {
            params.px(expireTime.longValue());
        }
        if (ifExist.equals(NX)) {
            params.nx();
        } else {
            params.xx();
        }
        return params;
    }

    public Object get(String type, String project, Object key) {
        if (isRecovering.get()) {
            return null;
        }
        byte[] realKey = this.convertKeyToByte(this.getTypeProjectPrefix(type, project), key);
        byte[] sqlResp = null;
        try {
            if (this.redisClusterEnabled) {
                if (jedisCluster == null) {
                    logger.error("[Redis cache log] Jedis Cluster failed to initiate.");
                    return null;
                }
                if (jedisCluster.getClusterNodes().isEmpty()) {
                    RedisCache.recoverInstance();
                }
                logger.trace("redis get start");
                sqlResp = jedisCluster.get(realKey);
                logger.trace("redis get done, size = {}bytes", (Object)(sqlResp == null ? 0 : sqlResp.length));
            } else {
                logger.trace("redis get start");
                sqlResp = this.singleRedisGet(realKey);
                logger.trace("redis get done, size = {}bytes", (Object)(sqlResp == null ? 0 : sqlResp.length));
            }
        }
        catch (JedisClusterException | JedisConnectionException e) {
            logger.error("Get jedis connection failed: ", e);
        }
        catch (JedisMovedDataException e) {
            logger.error("Failed to get redis data: ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unknown redis cache error: ", (Throwable)e);
        }
        if (sqlResp != null) {
            Object result = this.convertByteToObject(sqlResp);
            logger.trace("redis result deserialized");
            return result;
        }
        return null;
    }

    private boolean removeImpl(String type, Object key) {
        byte[] realKey = this.convertKeyToByte(type, key);
        boolean res = false;
        res = this.redisClusterEnabled ? jedisCluster.del(realKey) > 0L : this.singleRedisRemove(realKey);
        return res;
    }

    private byte[] singleRedisGet(byte[] key) {
        try (Jedis redisClient = jedisPool.getResource();){
            byte[] byArray = redisClient.get(key);
            return byArray;
        }
    }

    private boolean singleRedisRemove(byte[] key) {
        try (Jedis redisClient = jedisPool.getResource();){
            boolean bl = redisClient.del(key) > 0L;
            return bl;
        }
    }

    public void clearAll() {
        this.clearByType("", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clusterRedisClearByPattern(String pattern) {
        if (masters.isEmpty()) {
            logger.error("[Redis cache log] No masters in the cluster, fail to clear by pattern.");
            return;
        }
        for (String host : masters) {
            HashMap slotToKeys = Maps.newHashMap();
            Jedis master = null;
            try {
                master = ((JedisPool)jedisCluster.getClusterNodes().get(host)).getResource();
                for (byte[] k : this.getScannedKeys(pattern, master)) {
                    int slot = JedisClusterCRC16.getSlot((byte[])k);
                    if (slotToKeys.containsKey(slot)) {
                        ((List)slotToKeys.get(slot)).add(k);
                        continue;
                    }
                    slotToKeys.put(slot, Lists.newArrayList((Object[])new byte[][]{k}));
                }
                Iterator<Object> iterator = slotToKeys.keySet().iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    master.del((byte[][])((List)slotToKeys.get(slot)).toArray((T[])new byte[((List)slotToKeys.get(slot)).size()][]));
                }
            }
            catch (Throwable throwable) {
                RedisCache.close(master);
                throw throwable;
            }
            RedisCache.close(master);
        }
    }

    public void clearByType(String type, String project) {
        if (isRecovering.get()) {
            return;
        }
        String prefixAndType = PREFIX;
        if (!type.isEmpty()) {
            prefixAndType = prefixAndType + this.getTypeProjectPrefix(type, project);
        }
        if (this.redisClusterEnabled) {
            this.clusterRedisClearByPattern(prefixAndType + "*");
        } else {
            this.singleRedisClearByType(prefixAndType);
        }
    }

    private void singleRedisClearByType(String prefixAndType) {
        try (Jedis redisClient = jedisPool.getResource();){
            this.delByProject(prefixAndType + "*", redisClient);
        }
    }

    private void delByProject(String key, Jedis redisClient) {
        List<byte[]> keys = this.getScannedKeys(key, redisClient);
        if (CollectionUtils.isNotEmpty(keys)) {
            redisClient.del((byte[][])keys.toArray((T[])new byte[keys.size()][]));
        }
    }

    private List<byte[]> getScannedKeys(String key, Jedis redisClient) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        byte[] cursor = ScanParams.SCAN_POINTER_START_BINARY;
        ScanParams scanParams = new ScanParams();
        scanParams.match(this.getBytesFromString(key));
        scanParams.count(Integer.valueOf(config.getRedisScanKeysBatchCount()));
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        do {
            ScanResult scanResult = redisClient.scan(cursor, scanParams);
            cursor = scanResult.getCursorAsBytes();
            List list = scanResult.getResult();
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            keys.addAll(list);
        } while (!SCAN_POINTER_START_STR.equals(new String(cursor, CHARSET)));
        return keys;
    }

    private byte[] convertValueToByte(Object value) {
        try {
            return CompressionUtils.compress((byte[])SerializeUtil.serialize(value));
        }
        catch (Exception e) {
            logger.error("serialize failed!", (Throwable)e);
            return null;
        }
    }

    private byte[] getBytesFromString(String str) {
        try {
            return str.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unsupported encoding:UTF-8", e);
        }
    }

    private byte[] convertKeyToByte(String type, Object key) {
        try {
            String prefixAndType = PREFIX + type;
            byte[] typeBytes = this.getBytesFromString(prefixAndType);
            byte[] keyBytes = SerializeUtil.serialize(key);
            byte[] trueKeyBytes = new byte[keyBytes.length + typeBytes.length];
            System.arraycopy(typeBytes, 0, trueKeyBytes, 0, typeBytes.length);
            System.arraycopy(keyBytes, 0, trueKeyBytes, typeBytes.length, keyBytes.length);
            return trueKeyBytes;
        }
        catch (Exception e) {
            logger.error("serialize fail!", (Throwable)e);
            return null;
        }
    }

    private Object convertByteToObject(byte[] bytes) {
        try {
            return SerializeUtil.deserialize(CompressionUtils.decompress((byte[])bytes));
        }
        catch (Exception e) {
            logger.error("deserialize fail!", (Throwable)e);
            return null;
        }
    }

    public boolean remove(String type, String project, Object key) {
        if (isRecovering.get()) {
            return false;
        }
        return this.removeImpl(this.getTypeProjectPrefix(type, project), key);
    }

    static {
        masters = Sets.newHashSet();
        isRecovering = new AtomicBoolean(false);
    }
}

