/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cache.memcached;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.DataFormatException;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.ops.ArrayOperationQueueFactory;
import net.spy.memcached.ops.LinkedOperationQueueFactory;
import net.spy.memcached.ops.OperationQueueFactory;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.rest.cache.memcached.CacheStats;
import org.apache.kylin.rest.cache.memcached.MemcachedCacheConfig;
import org.apache.kylin.rest.cache.memcached.MemcachedConnectionFactory;
import org.apache.kylin.rest.cache.memcached.MemcachedConnectionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedCache {
    public static final int MAX_PREFIX_LENGTH = 168;
    private static final Logger logger = LoggerFactory.getLogger(MemcachedCache.class);
    private static final int DEFAULT_TTL = 604800;
    private static final String UNABLE_TO_QUEUE_CACHE_OPERATION = "Unable to queue cache operation.";
    protected final MemcachedCacheConfig config;
    protected final MemcachedClientIF client;
    protected final String memcachedPrefix;
    protected final int compressThreshold;
    protected final AtomicLong hitCount = new AtomicLong(0L);
    protected final AtomicLong missCount = new AtomicLong(0L);
    protected final AtomicLong readBytes = new AtomicLong(0L);
    protected final AtomicLong timeoutCount = new AtomicLong(0L);
    protected final AtomicLong errorCount = new AtomicLong(0L);
    protected final AtomicLong putCount = new AtomicLong(0L);
    protected final AtomicLong putBytes = new AtomicLong(0L);
    private final int timeToLiveSeconds;
    protected AtomicLong cacheGetTime = new AtomicLong(0L);

    public MemcachedCache(MemcachedClientIF client, MemcachedCacheConfig config, String memcachedPrefix, int timeToLiveSeconds) {
        Preconditions.checkArgument((memcachedPrefix.length() <= 168 ? 1 : 0) != 0, (String)"memcachedPrefix length [%d] exceeds maximum length [%d]", (Object[])new Object[]{memcachedPrefix.length(), 168});
        this.memcachedPrefix = memcachedPrefix;
        this.client = client;
        this.config = config;
        this.compressThreshold = config.getMaxObjectSize() / 2;
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public MemcachedCache(MemcachedCache cache) {
        this(cache.client, cache.config, cache.memcachedPrefix, cache.timeToLiveSeconds);
    }

    public static MemcachedCache create(MemcachedCacheConfig config, String memcachedPrefix) {
        return MemcachedCache.create(config, memcachedPrefix, 604800);
    }

    public static MemcachedCache create(MemcachedCacheConfig config, String memcachedPrefix, int timeToLive) {
        try {
            SerializingTranscoder transcoder = new SerializingTranscoder(config.getMaxObjectSize());
            transcoder.setCompressionThreshold(Integer.MAX_VALUE);
            int maxQueueSize = config.getMaxOperationQueueSize();
            Object opQueueFactory = maxQueueSize > 0 ? new ArrayOperationQueueFactory(maxQueueSize) : new LinkedOperationQueueFactory();
            String hostsStr = config.getHosts();
            ConnectionFactory connectionFactory = new MemcachedConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setHashAlg((HashAlgorithm)DefaultHashAlgorithm.FNV1A_64_HASH).setLocatorType(ConnectionFactoryBuilder.Locator.CONSISTENT).setDaemon(true).setFailureMode(FailureMode.Redistribute).setTranscoder((Transcoder)transcoder).setShouldOptimize(true).setOpQueueMaxBlockTime(config.getTimeout()).setOpTimeout(config.getTimeout()).setReadBufferSize(config.getReadBufferSize()).setOpQueueFactory((OperationQueueFactory)opQueueFactory).build();
            return new MemcachedCache((MemcachedClientIF)new MemcachedClient((ConnectionFactory)new MemcachedConnectionFactory(connectionFactory), MemcachedCache.getResolvedAddrList(hostsStr)), config, memcachedPrefix, timeToLive);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static List<InetSocketAddress> getResolvedAddrList(String hostsStr) {
        List addrs = AddrUtil.getAddresses((String)hostsStr);
        Iterator addrIterator = addrs.iterator();
        while (addrIterator.hasNext()) {
            if (!((InetSocketAddress)addrIterator.next()).isUnresolved()) continue;
            addrIterator.remove();
        }
        return addrs;
    }

    public String getName() {
        return this.memcachedPrefix;
    }

    public Object getNativeCache() {
        return this.client;
    }

    protected byte[] serializeValue(Object value) {
        return SerializationUtils.serialize((Serializable)((Serializable)value));
    }

    @VisibleForTesting
    byte[] encodeValue(String keyS, Object value) {
        if (keyS == null) {
            return new byte[0];
        }
        return this.encodeValue(keyS.getBytes(StandardCharsets.UTF_8), this.serializeValue(value));
    }

    public byte[] get(Object key) {
        return this.get((String)key);
    }

    public byte[] get(String keyS) {
        return this.getBinary(keyS);
    }

    public void put(Object key, Object value) {
        this.put((String)key, value);
    }

    public void put(String keyS, Object value) {
        if (keyS != null) {
            this.putBinary(keyS, this.serializeValue(value), this.timeToLiveSeconds);
        }
    }

    public void evict(Object key) {
        if (key == null) {
            return;
        }
        this.evict((String)key);
    }

    public void evict(String keyS) {
        if (keyS == null) {
            return;
        }
        this.client.delete(this.computeKeyHash(keyS));
    }

    public void clearByType(String pattern) {
        logger.debug("clear by pattern: {} will caused clear all method here", (Object)pattern);
        this.clear();
    }

    public void clear() {
        logger.warn("Clear Remote Cache!");
        Future resultFuture = this.client.flush();
        try {
            boolean result = (Boolean)resultFuture.get();
            logger.warn("Clear Remote Cache returned with result: {}", (Object)result);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Can't clear Remote Cache.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public CacheStats getStats() {
        return new CacheStats(this.readBytes.get(), this.cacheGetTime.get(), this.putBytes.get(), new CacheStats.CacheStatsCounter(this.putCount.get(), this.hitCount.get(), this.missCount.get(), 0L, this.timeoutCount.get(), this.errorCount.get()));
    }

    protected byte[] getBinary(String keyS) {
        if (Strings.isNullOrEmpty((String)keyS)) {
            return new byte[0];
        }
        byte[] bytes = this.internalGet(this.computeKeyHash(keyS));
        return this.decodeValue(keyS.getBytes(StandardCharsets.UTF_8), bytes);
    }

    protected void putBinary(String keyS, byte[] valueB, int expiration) {
        if (Strings.isNullOrEmpty((String)keyS)) {
            return;
        }
        this.internalPut(this.computeKeyHash(keyS), this.encodeValue(keyS.getBytes(StandardCharsets.UTF_8), valueB), expiration);
    }

    protected byte[] internalGet(String hashedKey) {
        Future future;
        long start = System.currentTimeMillis();
        try {
            future = this.client.asyncGet(hashedKey);
        }
        catch (IllegalStateException e) {
            this.errorCount.incrementAndGet();
            logger.error(UNABLE_TO_QUEUE_CACHE_OPERATION, (Throwable)e);
            return new byte[0];
        }
        catch (Throwable t) {
            this.errorCount.incrementAndGet();
            logger.error(UNABLE_TO_QUEUE_CACHE_OPERATION, t);
            return new byte[0];
        }
        try {
            byte[] result = future != null ? (byte[])future.get(this.config.getTimeout(), TimeUnit.MILLISECONDS) : null;
            this.cacheGetTime.addAndGet(System.currentTimeMillis() - start);
            if (result != null) {
                this.hitCount.incrementAndGet();
                this.readBytes.addAndGet(result.length);
            } else {
                this.missCount.incrementAndGet();
            }
            return result;
        }
        catch (TimeoutException e) {
            this.timeoutCount.incrementAndGet();
            future.cancel(false);
            return new byte[0];
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            this.errorCount.incrementAndGet();
            logger.error("ExecutionException when pulling key meta from cache.", (Throwable)e);
            return new byte[0];
        }
    }

    private void internalPut(String hashedKey, byte[] encodedValue, int expiration) {
        try {
            this.client.set(hashedKey, expiration, (Object)encodedValue);
            this.putCount.incrementAndGet();
            this.putBytes.addAndGet(encodedValue.length);
        }
        catch (IllegalStateException e) {
            this.errorCount.incrementAndGet();
            logger.error(UNABLE_TO_QUEUE_CACHE_OPERATION, (Throwable)e);
        }
        catch (Throwable t) {
            this.errorCount.incrementAndGet();
            logger.error(UNABLE_TO_QUEUE_CACHE_OPERATION, t);
        }
    }

    protected byte[] encodeValue(byte[] key, byte[] valueB) {
        byte[] compressed = null;
        if (this.config.isEnableCompression() && valueB.length + 4 + key.length > this.compressThreshold) {
            try {
                compressed = CompressionUtils.compress((byte[])ByteBuffer.allocate(4 + key.length + valueB.length).putInt(key.length).put(key).put(valueB).array());
            }
            catch (IOException e) {
                compressed = null;
                logger.warn("Compressing value bytes error.", (Throwable)e);
            }
        }
        if (compressed != null) {
            return ByteBuffer.allocate(2 + compressed.length).putShort((short)1).put(compressed).array();
        }
        return ByteBuffer.allocate(6 + key.length + valueB.length).putShort((short)0).putInt(key.length).put(key).put(valueB).array();
    }

    protected byte[] decodeValue(byte[] key, byte[] valueE) {
        if (valueE == null || valueE.length == 0) {
            return new byte[0];
        }
        ByteBuffer buf = ByteBuffer.wrap(valueE);
        short enableCompression = buf.getShort();
        byte[] uncompressed = null;
        if (enableCompression == 1) {
            byte[] value = new byte[buf.remaining()];
            buf.get(value);
            try {
                uncompressed = CompressionUtils.decompress((byte[])value);
            }
            catch (IOException | DataFormatException e) {
                logger.error("Decompressing value bytes error.", (Throwable)e);
                return new byte[0];
            }
        }
        if (uncompressed != null) {
            buf = ByteBuffer.wrap(uncompressed);
        }
        int keyLength = buf.getInt();
        byte[] keyBytes = new byte[keyLength];
        buf.get(keyBytes);
        if (!Arrays.equals(keyBytes, key)) {
            logger.error("Keys do not match, possible hash collision!");
            return new byte[0];
        }
        byte[] value = new byte[buf.remaining()];
        buf.get(value);
        return value;
    }

    protected String computeKeyHash(String key) {
        return Joiner.on((String)":").skipNulls().join((Object)KylinConfig.getInstanceFromEnv().getDeployEnv(), (Object)this.memcachedPrefix, new Object[]{DigestUtils.sha1Hex((String)key)});
    }
}

