/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterManager
implements ClusterManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterManager.class);
    int port;

    @Override
    public String getLocalServer() {
        try {
            return InetAddress.getLocalHost().getHostName() + ":" + this.port;
        }
        catch (UnknownHostException e) {
            log.warn("cannot get hostname", (Throwable)e);
            return "localhost:" + this.port;
        }
    }

    @Override
    public List<ServerInfoResponse> getQueryServers() {
        ArrayList<ServerInfoResponse> servers = new ArrayList<ServerInfoResponse>();
        ServerInfoResponse server = new ServerInfoResponse();
        server.setHost(this.getLocalServer());
        server.setMode(ClusterConstant.ALL);
        servers.add(server);
        return servers;
    }

    @Override
    public List<ServerInfoResponse> getServersFromCache() {
        return this.getQueryServers();
    }

    @Override
    public List<ServerInfoResponse> getJobServers() {
        return this.getQueryServers();
    }

    @Override
    public List<ServerInfoResponse> getServers() {
        return this.getQueryServers();
    }

    @Generated
    public DefaultClusterManager(int port) {
        this.port = port;
    }
}

