/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config;

import java.net.URLStreamHandlerFactory;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.jnet.Installer;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.hystrix.NCircuitBreaker;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.metadata.EpochStore;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.persistence.transaction.EventListenerRegistry;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.HostInfoFetcher;
import org.apache.kylin.engine.spark.ExecutableUtils;
import org.apache.kylin.metadata.epoch.EpochOrchestrator;
import org.apache.kylin.metadata.project.NProjectLoader;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.streaming.JdbcStreamingJobStatsStore;
import org.apache.kylin.rest.config.initialize.AclTCRListener;
import org.apache.kylin.rest.config.initialize.AfterMetadataReadyEvent;
import org.apache.kylin.rest.config.initialize.CacheCleanListener;
import org.apache.kylin.rest.config.initialize.EpochChangedListener;
import org.apache.kylin.rest.config.initialize.JobSchedulerListener;
import org.apache.kylin.rest.config.initialize.ModelBrokenListener;
import org.apache.kylin.rest.config.initialize.ProcessStatusListener;
import org.apache.kylin.rest.config.initialize.QueryMetricsListener;
import org.apache.kylin.rest.config.initialize.SparderStartEvent;
import org.apache.kylin.rest.config.initialize.TableSchemaChangeListener;
import org.apache.kylin.rest.config.initialize.UserAclListener;
import org.apache.kylin.rest.service.CommonQueryCacheSupporter;
import org.apache.kylin.rest.util.JStackDumpTask;
import org.apache.kylin.streaming.jobs.StreamingJobListener;
import org.apache.kylin.tool.daemon.KapGuardianHATask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.TaskScheduler;

@Configuration
@Order(value=1)
@Profile(value={"!test"})
public class AppInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppInitializer.class);
    @Autowired
    TaskScheduler taskScheduler;
    @Autowired(required=false)
    CommonQueryCacheSupporter queryCacheManager;
    @Autowired(required=false)
    EpochChangedListener epochChangedListener;
    @Autowired(required=false)
    HostInfoFetcher hostInfoFetcher;
    @Autowired
    ApplicationContext context;
    JdbcStreamingJobStatsStore streamingJobStatsStore;

    @PostConstruct
    public void init() throws Exception {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NCircuitBreaker.start((KapConfig)KapConfig.wrap((KylinConfig)kylinConfig));
        if (kylinConfig.isJobNode()) {
            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig);
            resourceStore.setChecker(e -> {
                String instance = e.getInstance();
                String localIdentify = EpochOrchestrator.getOwnerIdentity().split("\\|")[0];
                return localIdentify.equalsIgnoreCase(instance);
            });
            this.streamingJobStatsStore = new JdbcStreamingJobStatsStore(kylinConfig);
            EventBusFactory.getInstance().register((Object)new JobSchedulerListener(), false);
            EventBusFactory.getInstance().register((Object)new ModelBrokenListener(), false);
            EventBusFactory.getInstance().register((Object)this.epochChangedListener, false);
            EventBusFactory.getInstance().register((Object)new ProcessStatusListener(), true);
            EventBusFactory.getInstance().register((Object)new StreamingJobListener(), true);
            ExecutableUtils.initJobFactory();
        } else {
            JdbcAuditLogStore auditLogStore = new JdbcAuditLogStore(kylinConfig);
            EpochStore epochStore = EpochStore.getEpochStore((KylinConfig)kylinConfig);
            kylinConfig.setQueryHistoryUrl(kylinConfig.getQueryHistoryUrl().toString());
            kylinConfig.setStreamingStatsUrl(kylinConfig.getStreamingStatsUrl().toString());
            if (kylinConfig.getMetadataStoreType().equals("hdfs")) {
                kylinConfig.setProperty("kylin.metadata.url", kylinConfig.getMetadataUrlPrefix() + "@hdfs");
            }
            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig);
            resourceStore.getMetadataStore().setAuditLogStore((AuditLogStore)auditLogStore);
            resourceStore.catchup();
            resourceStore.getMetadataStore().setEpochStore(epochStore);
        }
        kylinConfig.getDistributedLockFactory().initialize();
        this.warmUpSystemCache();
        this.context.publishEvent((ApplicationEvent)new AfterMetadataReadyEvent(this.context));
        if (kylinConfig.isQueryNode()) {
            if (kylinConfig.isSparderAsync().booleanValue()) {
                this.context.publishEvent((ApplicationEvent)new SparderStartEvent.AsyncEvent(this.context));
            } else {
                this.context.publishEvent((ApplicationEvent)new SparderStartEvent.SyncEvent(this.context));
            }
        }
        EventListenerRegistry.getInstance((KylinConfig)kylinConfig).register((EventListenerRegistry.ResourceEventListener)new AclTCRListener(this.queryCacheManager), "acl");
        EventListenerRegistry.getInstance((KylinConfig)kylinConfig).register((EventListenerRegistry.ResourceEventListener)new TableSchemaChangeListener(this.queryCacheManager), "table");
        EventListenerRegistry.getInstance((KylinConfig)kylinConfig).register((EventListenerRegistry.ResourceEventListener)new CacheCleanListener(), "cacheInManager");
        EventBusFactory.getInstance().register((Object)new QueryMetricsListener(), false);
        EventBusFactory.getInstance().register((Object)new UserAclListener(), true);
        this.postInit();
        log.info("Application metadata initialization is complete.");
    }

    private void warmUpSystemCache() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        List prjInstances = NProjectManager.getInstance((KylinConfig)kylinConfig).listAllProjects();
        prjInstances.forEach(prjInstance -> {
            NProjectLoader.updateCache((String)prjInstance.getName());
            NProjectLoader.removeCache();
        });
        log.info("The system cache is warmed up.");
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void afterReady(ApplicationReadyEvent event) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        AppInitializer.setFsUrlStreamHandlerFactory();
        if (kylinConfig.isJobNode()) {
            new EpochOrchestrator(kylinConfig);
        }
        if (kylinConfig.getJStackDumpTaskEnabled()) {
            this.taskScheduler.scheduleAtFixedRate((Runnable)new JStackDumpTask(), kylinConfig.getJStackDumpTaskPeriod() * 60000L);
        }
        if (kylinConfig.isGuardianEnabled() && kylinConfig.isGuardianHAEnabled()) {
            log.info("Guardian Process ha is enabled, start check scheduler");
            this.taskScheduler.scheduleAtFixedRate((Runnable)new KapGuardianHATask(), new Date(System.currentTimeMillis() + kylinConfig.getGuardianHACheckInitDelay() * 1000L), kylinConfig.getGuardianHACheckInterval() * 1000L);
        }
    }

    private void postInit() {
        AddressUtil.setHostInfoFetcher((HostInfoFetcher)this.hostInfoFetcher);
    }

    private static void setFsUrlStreamHandlerFactory() {
        try {
            Installer.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory());
        }
        catch (Exception e) {
            log.warn("set Fs URL stream handler factory failed", (Throwable)e);
        }
    }
}

