/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.transaction.EventListenerRegistry;
import org.apache.kylin.rest.service.CommonQueryCacheSupporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclTCRListener
implements EventListenerRegistry.ResourceEventListener {
    private static final Logger logger = LoggerFactory.getLogger(AclTCRListener.class);
    private final CommonQueryCacheSupporter queryCacheManager;

    public AclTCRListener(CommonQueryCacheSupporter queryCacheManager) {
        this.queryCacheManager = queryCacheManager;
    }

    public void onUpdate(KylinConfig config, RawResource rawResource) {
        if (Objects.isNull(rawResource)) {
            return;
        }
        this.getProjectName(rawResource.getResPath()).ifPresent(project -> this.clearCache(config, (String)project));
    }

    public void onDelete(KylinConfig config, String resPath) {
        this.getProjectName(resPath).ifPresent(project -> this.clearCache(config, (String)project));
    }

    private Optional<String> getProjectName(String resourcePath) {
        if (Objects.isNull(resourcePath)) {
            return Optional.empty();
        }
        String[] elements = resourcePath.split("/");
        if (elements.length < 4 || !"acl".equals(elements[2]) || StringUtils.isEmpty((String)elements[1])) {
            return Optional.empty();
        }
        return Optional.of(elements[1]);
    }

    private void clearCache(KylinConfig config, String project) {
        if (!config.isRedisEnabled()) {
            this.queryCacheManager.onClearProjectCache(project);
        }
    }
}

