/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.impl.threadpool.NDefaultScheduler;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BootstrapCommand
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BootstrapCommand.class);

    @Override
    public void run() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)kylinConfig);
        for (ProjectInstance project : projectManager.listAllProjects()) {
            this.initProject(kylinConfig, project);
        }
        for (NDefaultScheduler scheduler : NDefaultScheduler.listAllSchedulers()) {
            String project = scheduler.getProject();
            if (projectManager.getProject(scheduler.getProject()) != null) continue;
            NDefaultScheduler.shutdownByProject((String)project);
        }
    }

    void initProject(KylinConfig config, ProjectInstance project) {
        NDefaultScheduler scheduler = NDefaultScheduler.getInstance((String)project.getName());
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            scheduler.init(new JobEngineConfig(config));
            if (!scheduler.hasStarted()) {
                throw new RuntimeException("Scheduler for " + project.getName() + " has not been started");
            }
            return 0;
        }, (String)project.getName(), (int)1, (long)-1L);
        scheduler.setHasFinishedTransactions(new AtomicBoolean(true));
        log.info("init project {} finished", (Object)project.getName());
    }
}

