/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.transaction.EventListenerRegistry;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.streaming.KafkaConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCleanListener
implements EventListenerRegistry.ResourceEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheCleanListener.class);
    private static final List<Pattern> PROJECT_RESOURCE_PATTERN = Lists.newArrayList((Object[])new Pattern[]{Pattern.compile("/_global/project/([^/]+)$")});
    private static final List<Pattern> TABLE_RESOURCE_PATTERN = Lists.newArrayList((Object[])new Pattern[]{Pattern.compile("/([^/]+)/table/([^/]+)"), Pattern.compile("/([^/]+)/table_exd/([^/]+)"), Pattern.compile("/([^/]+)/ext_filter/([^/]+)")});
    private static final List<Pattern> KAFKA_RESOURCE_PATTERN = Lists.newArrayList((Object[])new Pattern[]{Pattern.compile("/([^/]+)/kafka/([^/]+)")});

    public void onUpdate(KylinConfig config, RawResource rawResource) {
    }

    public void onDelete(KylinConfig config, String resPath) {
        try {
            PROJECT_RESOURCE_PATTERN.forEach(pattern -> {
                String project = this.extractProject(resPath, (Pattern)pattern);
                if (StringUtils.isNotBlank((String)project)) {
                    NProjectManager.getInstance((KylinConfig)config).invalidCache(project);
                }
            });
            TABLE_RESOURCE_PATTERN.forEach(pattern -> {
                String project = this.extractProject(resPath, (Pattern)pattern);
                String table = this.extractTable(resPath, (Pattern)pattern);
                if (StringUtils.isNotBlank((String)project) && StringUtils.isNotBlank((String)table)) {
                    NTableMetadataManager.getInstance((KylinConfig)config, (String)project).invalidCache(table);
                }
            });
            KAFKA_RESOURCE_PATTERN.forEach(pattern -> {
                String project = this.extractProject(resPath, (Pattern)pattern);
                String kafkaTableName = this.extractTable(resPath, (Pattern)pattern);
                if (StringUtils.isNotBlank((String)project) && StringUtils.isNotBlank((String)kafkaTableName)) {
                    KafkaConfigManager.getInstance((KylinConfig)config, (String)project).invalidCache(kafkaTableName);
                }
            });
        }
        catch (Exception e) {
            log.error("Unexpected error happened! Clean resource {} cache failed.", (Object)resPath, (Object)e);
        }
    }

    private String extractProject(String resPath, Pattern pattern) {
        Matcher matcher = pattern.matcher(resPath);
        if (matcher.find()) {
            return matcher.group(1).replace(".json", "");
        }
        return null;
    }

    private String extractTable(String resPath, Pattern pattern) {
        Matcher matcher = pattern.matcher(resPath);
        if (matcher.find() && matcher.groupCount() == 2) {
            return matcher.group(2).replace(".json", "");
        }
        return null;
    }
}

