/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import com.google.common.collect.Maps;
import io.kyligence.kap.guava20.shaded.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.metrics.MetricsTag;
import org.apache.kylin.common.scheduler.JobAddedNotifier;
import org.apache.kylin.common.scheduler.JobDiscardNotifier;
import org.apache.kylin.common.scheduler.JobReadyNotifier;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.job.impl.threadpool.NDefaultScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobSchedulerListener.class);

    @Subscribe
    public void onJobIsReady(JobReadyNotifier notifier) {
        NDefaultScheduler.getInstance((String)notifier.getProject()).fetchJobsImmediately();
    }

    @Subscribe
    public void onJobAdded(JobAddedNotifier notifier) {
        String project = notifier.getProject();
        MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.JOB, (MetricsCategory)MetricsCategory.PROJECT, (String)project);
        HashMap tags = Maps.newHashMap();
        tags.put(MetricsTag.HOST.getVal(), AddressUtil.getZkLocalInstance());
        tags.put(MetricsTag.JOB_TYPE.getVal(), notifier.getJobType());
        MetricsGroup.counterInc((MetricsName)MetricsName.JOB_COUNT, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
    }

    @Subscribe
    public void onJobDiscard(JobDiscardNotifier notifier) {
        String project = notifier.getProject();
        MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.JOB_DISCARDED, (MetricsCategory)MetricsCategory.PROJECT, (String)project);
        HashMap tags = Maps.newHashMap();
        tags.put(MetricsTag.HOST.getVal(), AddressUtil.getZkLocalInstance());
        tags.put(MetricsTag.JOB_TYPE.getVal(), notifier.getJobType());
        MetricsGroup.counterInc((MetricsName)MetricsName.TERMINATED_JOB_COUNT, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
    }
}

