/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import com.codahale.metrics.MetricSet;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.event.ModelAddEvent;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.metrics.MetricsTag;
import org.apache.kylin.common.metrics.prometheus.PrometheusMetrics;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.execution.NExecutableManager;
import org.apache.kylin.job.impl.threadpool.NDefaultScheduler;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.storage.ProjectStorageInfoCollector;
import org.apache.kylin.metadata.cube.storage.StorageInfoEnum;
import org.apache.kylin.metadata.cube.storage.StorageVolumeInfo;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.apache.kylin.query.util.LoadCounter;
import org.apache.kylin.query.util.LoadDesc;
import org.apache.kylin.rest.response.StorageVolumeInfoResponse;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.util.SpringContext;
import org.apache.spark.sql.SparderEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsRegistry.class);
    private static final String GLOBAL = "global";
    private static final Map<String, Long> totalStorageSizeMap = Maps.newHashMap();
    private static volatile Map<String, Map<Integer, Long>> projectPendingJobMap = Maps.newHashMap();
    private static volatile Map<String, Map<Double, Long>> projectRunningJobMap = Maps.newHashMap();
    private static final int[] PENDING_JOB_TIMEOUT_MINUTE = new int[]{5, 10, 15, 30};
    private static final double[] RUNNING_JOB_TIMEOUT_HOUR = new double[]{0.5, 1.0, 1.5, 2.0, 3.0};
    private static final Logger logger = LoggerFactory.getLogger(MetricsRegistry.class);

    private MetricsRegistry() {
    }

    public static void refreshTotalStorageSize() {
        ProjectService projectService = (ProjectService)SpringContext.getBean(ProjectService.class);
        totalStorageSizeMap.forEach((project, totalStorageSize) -> {
            StorageVolumeInfoResponse storageVolumeInfoResponse = projectService.getStorageVolumeInfoResponse((String)project);
            totalStorageSizeMap.put((String)project, storageVolumeInfoResponse.getTotalStorageSize());
        });
    }

    public static void refreshProjectLongRunningJobs(KylinConfig kylinConfig, Set<String> projects) {
        HashMap tempProjectPendingJobMap = Maps.newHashMap();
        HashMap tempProjectRunningJobMap = Maps.newHashMap();
        for (String project : projects) {
            NExecutableManager executableManager = NExecutableManager.getInstance((KylinConfig)kylinConfig, (String)project);
            tempProjectPendingJobMap.put(project, MetricsRegistry.collectTimeoutToPendingJobsMap(executableManager));
            tempProjectRunningJobMap.put(project, MetricsRegistry.collectTimeoutToRunningJobsMap(executableManager));
        }
        projectPendingJobMap = tempProjectPendingJobMap;
        projectRunningJobMap = tempProjectRunningJobMap;
    }

    private static Map<Integer, Long> collectTimeoutToPendingJobsMap(NExecutableManager executableManager) {
        HashMap timeoutToPendingJobsMap = Maps.newHashMap();
        List pendingJobs = executableManager.getAllJobs().stream().filter(e -> ExecutableState.READY.name().equals(e.getOutput().getStatus())).map(arg_0 -> ((NExecutableManager)executableManager).fromPO(arg_0)).collect(Collectors.toList());
        for (int pendingJobMin : PENDING_JOB_TIMEOUT_MINUTE) {
            timeoutToPendingJobsMap.put(pendingJobMin, pendingJobs.stream().filter(e -> (double)e.getWaitTime() / 1000.0 > (double)(pendingJobMin * 60)).count());
        }
        return timeoutToPendingJobsMap;
    }

    private static Map<Double, Long> collectTimeoutToRunningJobsMap(NExecutableManager executableManager) {
        HashMap timeoutToRunningJobsMap = Maps.newHashMap();
        List runningJobs = executableManager.getAllJobs().stream().filter(e -> ExecutableState.RUNNING.name().equals(e.getOutput().getStatus())).map(arg_0 -> ((NExecutableManager)executableManager).fromPO(arg_0)).collect(Collectors.toList());
        for (double runningJobHour : RUNNING_JOB_TIMEOUT_HOUR) {
            timeoutToRunningJobsMap.put(runningJobHour, runningJobs.stream().filter(e -> (double)e.getDuration() / 1000.0 > runningJobHour * 3600.0).count());
        }
        return timeoutToRunningJobsMap;
    }

    public static void removeProjectFromStorageSizeMap(String project) {
        totalStorageSizeMap.remove(project);
    }

    public static void registerGlobalMetrics(KylinConfig config, String host) {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)config);
        MetricsGroup.newGauge((MetricsName)MetricsName.PROJECT_GAUGE, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, () -> {
            List list = projectManager.listAllProjects();
            if (list == null) {
                return 0;
            }
            return list.size();
        });
        NKylinUserManager userManager = NKylinUserManager.getInstance((KylinConfig)config);
        MetricsGroup.newGauge((MetricsName)MetricsName.USER_GAUGE, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, () -> {
            List list = userManager.list();
            if (list == null) {
                return 0;
            }
            return list.size();
        });
        Map tags = MetricsGroup.getHostTagMap((String)host, (String)GLOBAL);
        MetricsGroup.newCounter((MetricsName)MetricsName.STORAGE_CLEAN, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (Map)tags);
        MetricsGroup.newCounter((MetricsName)MetricsName.STORAGE_CLEAN_DURATION, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (Map)tags);
        MetricsGroup.newCounter((MetricsName)MetricsName.STORAGE_CLEAN_FAILED, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (Map)tags);
        MetricsGroup.newCounter((MetricsName)MetricsName.METADATA_BACKUP, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (Map)tags);
        MetricsGroup.newCounter((MetricsName)MetricsName.METADATA_BACKUP_DURATION, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (Map)tags);
        MetricsGroup.newCounter((MetricsName)MetricsName.METADATA_BACKUP_FAILED, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (Map)tags);
        MetricsGroup.newCounter((MetricsName)MetricsName.METADATA_OPS_CRON, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (Map)tags);
        MetricsGroup.newCounter((MetricsName)MetricsName.METADATA_OPS_CRON_SUCCESS, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (Map)tags);
        MetricsGroup.newCounter((MetricsName)MetricsName.TRANSACTION_RETRY_COUNTER, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (Map)tags);
        MetricsGroup.newHistogram((MetricsName)MetricsName.TRANSACTION_LATENCY, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (Map)tags);
    }

    public static void registerGlobalPrometheusMetrics() {
        MeterRegistry meterRegistry = (MeterRegistry)SpringContext.getBean(MeterRegistry.class);
        for (String state : Lists.newArrayList((Object[])new String[]{"idle", "active"})) {
            JdbcDataSource.getDataSources().stream().collect(Collectors.groupingBy(ds -> ((BasicDataSource)ds).getDriverClassName())).forEach((driver, sources) -> Gauge.builder((String)PrometheusMetrics.JVM_DB_CONNECTIONS.getValue(), (Object)sources, dataSources -> {
                int count = 0;
                for (DataSource dataSource : dataSources) {
                    BasicDataSource basicDataSource = (BasicDataSource)dataSource;
                    if (state.equals("idle")) {
                        count += basicDataSource.getNumIdle();
                        continue;
                    }
                    count += basicDataSource.getNumActive();
                }
                return count;
            }).tags(new String[]{MetricsTag.STATE.getVal(), state, MetricsTag.POOL.getVal(), "dbcp2", MetricsTag.TYPE.getVal(), driver}).strongReference(true).register(meterRegistry));
        }
        Gauge.builder((String)PrometheusMetrics.SPARDER_UP.getValue(), () -> SparderEnv.isSparkAvailable() ? 1 : 0).strongReference(true).register(meterRegistry);
        Gauge.builder((String)PrometheusMetrics.SPARK_TASKS.getValue(), (Object)LoadCounter.getInstance(), e -> SparderEnv.isSparkAvailable() ? (double)e.getPendingTaskCount() : 0.0).tags(new String[]{MetricsTag.STATE.getVal(), MetricsTag.PENDING.getVal()}).strongReference(true).register(meterRegistry);
        Gauge.builder((String)PrometheusMetrics.SPARK_TASKS.getValue(), (Object)LoadCounter.getInstance(), e -> SparderEnv.isSparkAvailable() ? (double)e.getRunningTaskCount() : 0.0).tags(new String[]{MetricsTag.STATE.getVal(), MetricsTag.RUNNING.getVal()}).strongReference(true).register(meterRegistry);
        Gauge.builder((String)PrometheusMetrics.SPARK_TASK_UTILIZATION.getValue(), (Object)LoadCounter.getInstance(), e -> SparderEnv.isSparkAvailable() ? (double)e.getRunningTaskCount() * 1.0 / (double)e.getSlotCount() : 0.0).strongReference(true).register(meterRegistry);
    }

    public static void registerProjectPrometheusMetrics(KylinConfig kylinConfig, String project) {
        if (!kylinConfig.isPrometheusMetricsEnabled()) {
            return;
        }
        MeterRegistry meterRegistry = (MeterRegistry)SpringContext.getBean(MeterRegistry.class);
        Tags projectTag = Tags.of((String)MetricsTag.PROJECT.getVal(), (String)project);
        NDefaultScheduler scheduler = NDefaultScheduler.getInstance((String)project);
        Gauge.builder((String)PrometheusMetrics.JOB_COUNTS.getValue(), () -> Objects.isNull(scheduler.getContext()) ? 0L : scheduler.getContext().getRunningJobs().values().stream().filter(job -> ExecutableState.RUNNING.equals((Object)job.getOutput().getState())).count()).tags((Iterable)projectTag).tags(new String[]{MetricsTag.STATE.getVal(), MetricsTag.RUNNING.getVal()}).register(meterRegistry);
        for (double runningTimeoutHour : RUNNING_JOB_TIMEOUT_HOUR) {
            Gauge.builder((String)PrometheusMetrics.JOB_LONG_RUNNING.getValue(), () -> projectRunningJobMap.getOrDefault(project, Maps.newHashMap()).getOrDefault(runningTimeoutHour, 0L)).tags((Iterable)projectTag).tags(new String[]{MetricsTag.STATE.getVal(), MetricsTag.RUNNING.getVal(), MetricsTag.TIMEOUT.getVal(), runningTimeoutHour + "h"}).register(meterRegistry);
        }
        for (int waitTimeoutMin : PENDING_JOB_TIMEOUT_MINUTE) {
            Gauge.builder((String)PrometheusMetrics.JOB_LONG_RUNNING.getValue(), () -> projectPendingJobMap.getOrDefault(project, Maps.newHashMap()).getOrDefault(waitTimeoutMin, 0L)).tags((Iterable)projectTag).tags(new String[]{MetricsTag.STATE.getVal(), MetricsTag.WAITING.getVal(), MetricsTag.TIMEOUT.getVal(), waitTimeoutMin + "m"}).register(meterRegistry);
        }
    }

    public static void registerHostMetrics(String host) {
        MetricsGroup.newCounter((MetricsName)MetricsName.SPARDER_RESTART, (MetricsCategory)MetricsCategory.HOST, (String)host);
        MetricsGroup.newCounter((MetricsName)MetricsName.QUERY_HOST, (MetricsCategory)MetricsCategory.HOST, (String)host);
        MetricsGroup.newCounter((MetricsName)MetricsName.QUERY_SCAN_BYTES_HOST, (MetricsCategory)MetricsCategory.HOST, (String)host);
        MetricsGroup.newHistogram((MetricsName)MetricsName.QUERY_TIME_HOST, (MetricsCategory)MetricsCategory.HOST, (String)host);
        MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();
        MetricsGroup.newGauge((MetricsName)MetricsName.HEAP_MAX, (MetricsCategory)MetricsCategory.HOST, (String)host, () -> mxBean.getHeapMemoryUsage().getMax());
        MetricsGroup.newGauge((MetricsName)MetricsName.HEAP_USED, (MetricsCategory)MetricsCategory.HOST, (String)host, () -> mxBean.getHeapMemoryUsage().getUsed());
        MetricsGroup.newGauge((MetricsName)MetricsName.HEAP_USAGE, (MetricsCategory)MetricsCategory.HOST, (String)host, () -> {
            MemoryUsage usage = mxBean.getHeapMemoryUsage();
            return RatioGauge.Ratio.of((double)usage.getUsed(), (double)usage.getMax()).getValue();
        });
        MetricsGroup.newMetricSet((MetricsName)MetricsName.JVM_GC, (MetricsCategory)MetricsCategory.HOST, (String)host, (MetricSet)new GarbageCollectorMetricSet());
        MetricsGroup.newGauge((MetricsName)MetricsName.JVM_AVAILABLE_CPU, (MetricsCategory)MetricsCategory.HOST, (String)host, () -> Runtime.getRuntime().availableProcessors());
        MetricsGroup.newGauge((MetricsName)MetricsName.QUERY_LOAD, (MetricsCategory)MetricsCategory.HOST, (String)host, () -> {
            LoadDesc loadDesc = LoadCounter.getInstance().getLoadDesc();
            return loadDesc.getLoad();
        });
        MetricsGroup.newGauge((MetricsName)MetricsName.CPU_CORES, (MetricsCategory)MetricsCategory.HOST, (String)host, () -> {
            LoadDesc loadDesc = LoadCounter.getInstance().getLoadDesc();
            return loadDesc.getCoreNum();
        });
    }

    static void registerJobMetrics(KylinConfig config, String project) {
        NExecutableManager executableManager = NExecutableManager.getInstance((KylinConfig)config, (String)project);
        MetricsGroup.newGauge((MetricsName)MetricsName.JOB_ERROR_GAUGE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, () -> {
            List list = executableManager.getAllJobs();
            return list == null ? 0L : list.stream().filter(e -> ExecutableState.ERROR.name().equals(e.getOutput().getStatus())).count();
        });
        MetricsGroup.newGauge((MetricsName)MetricsName.JOB_RUNNING_GAUGE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, () -> {
            List list = executableManager.getAllJobs();
            return list == null ? 0L : list.stream().filter(e -> {
                String status = e.getOutput().getStatus();
                return ExecutableState.RUNNING.name().equals(status) || ExecutableState.READY.name().equals(status);
            }).count();
        });
        MetricsGroup.newGauge((MetricsName)MetricsName.JOB_PENDING_GAUGE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, () -> {
            List list = executableManager.getAllJobs();
            return list == null ? 0L : list.stream().filter(e -> ExecutableState.READY.name().equals(e.getOutput().getStatus())).count();
        });
    }

    static void registerStorageMetrics(String project) {
        ProjectService projectService = (ProjectService)SpringContext.getBean(ProjectService.class);
        totalStorageSizeMap.put(project, projectService.getStorageVolumeInfoResponse(project).getTotalStorageSize());
        MetricsGroup.newGauge((MetricsName)MetricsName.PROJECT_STORAGE_SIZE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, () -> totalStorageSizeMap.getOrDefault(project, 0L));
        MetricsGroup.newGauge((MetricsName)MetricsName.PROJECT_GARBAGE_SIZE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, () -> {
            ProjectStorageInfoCollector collector = new ProjectStorageInfoCollector((List)Lists.newArrayList((Object[])new StorageInfoEnum[]{StorageInfoEnum.GARBAGE_STORAGE}));
            StorageVolumeInfo storageVolumeInfo = collector.getStorageVolumeInfo(KylinConfig.getInstanceFromEnv(), project);
            return storageVolumeInfo.getGarbageStorageSize();
        });
    }

    public static void registerProjectMetrics(KylinConfig config, String project, String host) {
        MetricsGroup.registerProjectMetrics((String)project, (String)host);
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        MetricsGroup.newGauge((MetricsName)MetricsName.MODEL_GAUGE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, () -> {
            List list = dataModelManager.listAllModels();
            return list == null ? 0 : list.size();
        });
        boolean streamingEnabled = config.streamingEnabled();
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)config, (String)project);
        MetricsGroup.newGauge((MetricsName)MetricsName.HEALTHY_MODEL_GAUGE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, () -> {
            List list = dataflowManager.listUnderliningDataModels().stream().filter(model -> model.isAccessible(streamingEnabled)).collect(Collectors.toList());
            return list.size();
        });
        MetricsRegistry.registerStorageMetrics(project);
        MetricsRegistry.registerJobMetrics(config, project);
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)project);
        MetricsGroup.newGauge((MetricsName)MetricsName.TABLE_GAUGE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, () -> {
            List list = tableMetadataManager.listAllTables().stream().filter(table -> table.isAccessible(streamingEnabled)).collect(Collectors.toList());
            return list.size();
        });
        MetricsGroup.newGauge((MetricsName)MetricsName.DB_GAUGE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, () -> {
            List list = tableMetadataManager.listAllTables();
            return list == null ? 0 : list.stream().filter(table -> table.isAccessible(streamingEnabled)).map(TableDesc::getCaseSensitiveDatabase).collect(Collectors.toSet()).size();
        });
        MetricsRegistry.registerModelMetrics(config, project);
        MetricsRegistry.registerJobStatisticsMetrics(project, host);
    }

    static void registerModelMetrics(KylinConfig config, String project) {
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        boolean streamingEnabled = config.streamingEnabled();
        modelManager.listAllModels().stream().filter(model -> model.isAccessible(streamingEnabled)).forEach(model -> MetricsRegistry.registerModelMetrics(project, model.getId(), model.getAlias()));
    }

    static void registerModelMetrics(String project, String modelId, String modelAlias) {
        EventBusFactory.getInstance().postSync((Object)new ModelAddEvent(project, modelId, modelAlias));
    }

    public static void deletePrometheusProjectMetrics(String project) {
        if (StringUtils.isEmpty((String)project)) {
            throw new IllegalArgumentException("Remove prometheus project metrics, project shouldn't be empty.");
        }
        MeterRegistry meterRegistry = (MeterRegistry)SpringContext.getBean(MeterRegistry.class);
        meterRegistry.getMeters().stream().map(Meter::getId).filter(id -> project.equals(id.getTag(MetricsTag.PROJECT.getVal()))).forEach(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
        logger.info("Remove project prometheus metrics for {} success.", (Object)project);
    }

    public static void removePrometheusModelMetrics(String project, String modelName) {
        if (StringUtils.isBlank((String)project) || StringUtils.isBlank((String)modelName)) {
            throw new IllegalArgumentException("Remove prometheus model metrics, project or modelName shouldn't be empty.");
        }
        Set modelMetrics = PrometheusMetrics.listModelMetrics();
        modelMetrics.forEach(metricName -> MetricsRegistry.doRemoveMetric(metricName, Tags.of((String[])new String[]{MetricsTag.PROJECT.getVal(), project, MetricsTag.MODEL.getVal(), modelName})));
    }

    private static void doRemoveMetric(PrometheusMetrics metricName, Tags tags) {
        MeterRegistry meterRegistry = (MeterRegistry)SpringContext.getBean(MeterRegistry.class);
        Meter result = meterRegistry.remove(new Meter.Id(metricName.getValue(), tags, null, null, Meter.Type.DISTRIBUTION_SUMMARY));
        if (Objects.isNull(result)) {
            logger.warn("Remove prometheus metric failed, metric name: {}, tags: {}", (Object)metricName.getValue(), (Object)tags);
        }
    }

    private static void registerJobStatisticsMetrics(String project, String host) {
        List types = Stream.of(JobTypeEnum.values()).collect(Collectors.toList());
        for (JobTypeEnum type : types) {
            HashMap tags = Maps.newHashMap();
            tags.put(MetricsTag.HOST.getVal(), host);
            tags.put(MetricsTag.JOB_TYPE.getVal(), type.name());
            MetricsGroup.newCounter((MetricsName)MetricsName.JOB_COUNT, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
            MetricsGroup.newCounter((MetricsName)MetricsName.SUCCESSFUL_JOB_COUNT, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
            MetricsGroup.newCounter((MetricsName)MetricsName.ERROR_JOB_COUNT, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
            MetricsGroup.newCounter((MetricsName)MetricsName.TERMINATED_JOB_COUNT, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
            MetricsGroup.newCounter((MetricsName)MetricsName.JOB_COUNT_LT_5, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
            MetricsGroup.newCounter((MetricsName)MetricsName.JOB_COUNT_5_10, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
            MetricsGroup.newCounter((MetricsName)MetricsName.JOB_COUNT_10_30, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
            MetricsGroup.newCounter((MetricsName)MetricsName.JOB_COUNT_30_60, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
            MetricsGroup.newCounter((MetricsName)MetricsName.JOB_COUNT_GT_60, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
            MetricsGroup.newCounter((MetricsName)MetricsName.JOB_TOTAL_DURATION, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
        }
    }
}

