/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import com.google.common.collect.Lists;
import io.kyligence.kap.guava20.shaded.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.ManagementType;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.util.scd2.SCD2CondChecker;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.recommendation.ref.OptRecManagerV2;
import org.apache.kylin.metadata.sourceusage.SourceUsageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ModelBrokenListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelBrokenListener.class);

    private boolean needHandleModelBroken(String project, String modelId) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        NDataModel model = modelManager.getDataModelDesc(modelId);
        return model != null && model.isBroken() && !model.isHandledAfterBroken();
    }

    @Subscribe
    public void onModelBroken(NDataModel.ModelBrokenEvent event) {
        String modelId;
        String project = event.getProject();
        if (!this.needHandleModelBroken(project, modelId = event.getSubject())) {
            return;
        }
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            if (!this.needHandleModelBroken(project, modelId)) {
                return null;
            }
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
            NDataModel model = this.getBrokenModel(project, NDataModel.concatResourcePath((String)modelId, (String)project));
            NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)config, (String)project);
            NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)config, (String)project);
            if (config.getSmartModeBrokenModelDeleteEnabled()) {
                dataflowManager.dropDataflow(model.getId());
                indexPlanManager.dropIndexPlan(model.getId());
                modelManager.dropModel(model);
                return null;
            }
            NDataflow dataflow = dataflowManager.getDataflow(modelId);
            NDataflowUpdate dfUpdate = new NDataflowUpdate(dataflow.getId());
            dfUpdate.setStatus(RealizationStatusEnum.BROKEN);
            if (model.getBrokenReason() == NDataModel.BrokenReason.SCHEMA) {
                dfUpdate.setToRemoveSegs((NDataSegment[])dataflow.getSegments().toArray((Object[])new NDataSegment[0]));
            }
            dataflowManager.updateDataflow(dfUpdate);
            model.setHandledAfterBroken(true);
            model.setRecommendationsCount(0);
            modelManager.updateDataBrokenModelDesc(model);
            OptRecManagerV2 optRecManagerV2 = OptRecManagerV2.getInstance((String)project);
            optRecManagerV2.discardAll(model.getId());
            return null;
        }, (String)project);
    }

    private boolean needHandleModelRepair(String project, String modelId) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        NDataModel model = modelManager.getDataModelDesc(modelId);
        return model != null && !model.isBroken() && model.isHandledAfterBroken();
    }

    @Subscribe
    public void onModelRepair(NDataModel.ModelRepairEvent event) {
        String modelId;
        String project = event.getProject();
        if (!this.needHandleModelRepair(project, modelId = event.getSubject())) {
            return;
        }
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            if (!this.needHandleModelRepair(project, modelId)) {
                return null;
            }
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
            NDataModel modelOrigin = modelManager.getDataModelDesc(modelId);
            NDataModel model = modelManager.copyForWrite(modelOrigin);
            NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)config, (String)project);
            NDataflow dataflow = dataflowManager.getDataflow(modelId);
            NDataflowUpdate dfUpdate = new NDataflowUpdate(dataflow.getId());
            dfUpdate.setStatus(RealizationStatusEnum.OFFLINE);
            if (dataflow.getLastStatus() != null && !this.checkSCD2Disabled(project, modelId)) {
                dfUpdate.setStatus(dataflow.getLastStatus());
            }
            dataflowManager.updateDataflow(dfUpdate);
            if (CollectionUtils.isEmpty((Collection)dataflow.getSegments())) {
                if (model.getManagementType() == ManagementType.MODEL_BASED && model.getPartitionDesc() == null) {
                    dataflowManager.fillDfManually(dataflow, (List)Lists.newArrayList((Object[])new SegmentRange[]{SegmentRange.TimePartitionedSegmentRange.createInfinite()}));
                } else if (model.getManagementType() == ManagementType.TABLE_ORIENTED) {
                    dataflowManager.fillDf(dataflow);
                }
                JobManager jobManager = JobManager.getInstance((KylinConfig)config, (String)project);
                SourceUsageManager sourceUsageManager = SourceUsageManager.getInstance((KylinConfig)config);
                sourceUsageManager.licenseCheckWrap(project, () -> jobManager.addIndexJob(new JobParam(model.getId(), "ADMIN")));
            }
            model.setHandledAfterBroken(false);
            modelManager.updateDataBrokenModelDesc(model);
            return null;
        }, (String)project);
    }

    private boolean checkSCD2Disabled(String project, String modelId) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        NDataModel model = modelManager.getDataModelDesc(modelId);
        boolean isSCD2 = SCD2CondChecker.INSTANCE.isScd2Model(model);
        return !NProjectManager.getInstance((KylinConfig)config).getProject(project).getConfig().isQueryNonEquiJoinModelEnabled() && isSCD2;
    }

    private NDataModel getBrokenModel(String project, String resourcePath) {
        try {
            RawResource resource = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).getResource(resourcePath);
            NDataModel modelDesc = (NDataModel)JsonUtil.readValue((byte[])resource.getByteSource().read(), NDataModel.class);
            modelDesc.setBroken(true);
            modelDesc.setProject(project);
            modelDesc.setMvcc(resource.getMvcc());
            return modelDesc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

