/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import io.kyligence.kap.guava20.shaded.common.eventbus.Subscribe;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessStatusListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessStatusListener.class);
    private static final File CHILD_PROCESS_FILE = new File(KapConfig.getKylinHomeAtBestEffort(), "child_process");
    private static final String KILL_PROCESS_TREE = "kill-process-tree.sh";
    private static final int CMD_EXEC_TIMEOUT_SEC = 60;
    private final Lock fileLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void onProcessStart(CliCommandExecutor.ProcessStart processStart) {
        int pid = processStart.getPid();
        this.fileLock.lock();
        try (FileOutputStream os = new FileOutputStream(CHILD_PROCESS_FILE, true);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, Charset.defaultCharset().name()));){
            writer.write(pid + "," + processStart.getJobId() + "\n");
            writer.flush();
        }
        catch (IOException ex) {
            log.error("write child job process {} from {} failed", (Object)pid, (Object)CHILD_PROCESS_FILE.getAbsolutePath());
        }
        finally {
            this.fileLock.unlock();
        }
    }

    @Subscribe
    public void onProcessFinished(CliCommandExecutor.ProcessFinished processFinished) {
        int pid = processFinished.getPid();
        this.removeProcessPidInChildProcess(pid);
    }

    private void removeProcessPidInChildProcess(int pid) {
        if (!CHILD_PROCESS_FILE.exists()) {
            return;
        }
        this.fileLock.lock();
        try {
            Map<Integer, String> children = ProcessStatusListener.parseProcessFile();
            if (!children.containsKey(pid)) {
                return;
            }
            children.remove(pid);
            this.persistProcessFile(children);
        }
        finally {
            this.fileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void destroyProcessByJobId(CliCommandExecutor.JobKilled jobKilled) {
        block11: {
            Map<Integer, String> children;
            String jobId = jobKilled.getJobId();
            this.fileLock.lock();
            try {
                children = ProcessStatusListener.parseProcessFile();
            }
            finally {
                this.fileLock.unlock();
            }
            Optional<Integer> maybePid = children.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(jobId)).map(Map.Entry::getKey).findAny();
            if (!maybePid.isPresent()) {
                log.info("Cannot find pid for job:<{}>", (Object)jobId);
                return;
            }
            int pid = maybePid.get();
            log.debug("Try to kill process {}", (Object)pid);
            if (ProcessUtils.isAlive((int)pid)) {
                try {
                    log.info("Start to destroy process {} of job {}", (Object)pid, (Object)jobId);
                    String killCmd = String.format(Locale.ROOT, "bash %s/sbin/%s %s", KylinConfig.getKylinHome(), KILL_PROCESS_TREE, pid);
                    Process killProc = Runtime.getRuntime().exec(killCmd);
                    if (killProc.waitFor(60L, TimeUnit.SECONDS)) {
                        log.info("Try to destroy process {} of job {}, exec cmd '{}', exitValue : {}", new Object[]{pid, jobId, killCmd, killProc.exitValue()});
                        if (!ProcessUtils.isAlive((int)pid)) {
                            log.info("Destroy process {} of job {} SUCCEED.", (Object)pid, (Object)jobId);
                            return;
                        }
                        log.info("Destroy process {} of job {} FAILED.", (Object)pid, (Object)jobId);
                        break block11;
                    }
                    log.warn("Destroy process {} of job {} TIMEOUT exceed {}s.", new Object[]{pid, jobId, 60});
                }
                catch (Exception e) {
                    log.error("Destroy process of job {} FAILED.", (Object)jobId, (Object)e);
                }
            } else {
                log.info("Ignore not alive process {} of job {}", (Object)pid, (Object)jobId);
                this.removeProcessPidInChildProcess(pid);
            }
        }
    }

    private void persistProcessFile(Map<Integer, String> children) {
        try {
            FileUtils.writeLines((File)CHILD_PROCESS_FILE, (Collection)children.entrySet().stream().map(entry -> entry.getKey() + "," + (String)entry.getValue()).collect(Collectors.toList()));
        }
        catch (IOException e) {
            log.error("persist child_process failed, expected status is {}", children);
        }
    }

    @VisibleForTesting
    static Map<Integer, String> parseProcessFile() {
        HashMap result = Maps.newHashMap();
        try {
            for (String line : FileUtils.readLines((File)CHILD_PROCESS_FILE)) {
                String[] elements = line.split(",");
                result.put(Integer.parseInt(elements[0]), elements[1]);
            }
        }
        catch (IOException e) {
            log.error("read child job process from {} failed", (Object)CHILD_PROCESS_FILE.getAbsolutePath());
        }
        return result;
    }
}

