/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import java.io.IOException;
import lombok.Generated;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.job.execution.NExecutableManager;
import org.apache.kylin.job.impl.threadpool.NDefaultScheduler;
import org.apache.kylin.metadata.epoch.EpochManager;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.rest.config.initialize.MetricsRegistry;
import org.apache.kylin.rest.service.task.QueryHistoryTaskScheduler;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectDropListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectDropListener.class);

    public void onDelete(String project) {
        log.debug("delete project {}", (Object)project);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        try {
            NExecutableManager.getInstance((KylinConfig)kylinConfig, (String)project).destoryAllProcess();
            StreamingJobManager.getInstance((KylinConfig)kylinConfig, (String)project).destroyAllProcess();
            RDBMSQueryHistoryDAO.getInstance().dropProjectMeasurement(project);
            RawRecManager.getInstance((String)project).deleteByProject(project);
            QueryHistoryTaskScheduler.shutdownByProject(project);
            NDefaultScheduler.shutdownByProject((String)project);
            MetricsGroup.removeProjectMetrics((String)project);
            if (KylinConfig.getInstanceFromEnv().isPrometheusMetricsEnabled()) {
                MetricsRegistry.deletePrometheusProjectMetrics(project);
            }
            EpochManager epochManager = EpochManager.getInstance();
            epochManager.deleteEpoch(project);
            this.deleteStorage(kylinConfig, project.split("\\.")[0]);
        }
        catch (Exception e) {
            log.warn("error when delete " + project + " storage", (Throwable)e);
        }
    }

    private void deleteStorage(KylinConfig config, String project) throws IOException {
        String strPath = config.getHdfsWorkingDirectory(project);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (fs.exists(new Path(strPath))) {
            fs.delete(new Path(strPath), true);
        }
    }
}

