/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.transaction.EventListenerRegistry;
import org.apache.kylin.rest.service.CommonQueryCacheSupporter;

public class TableSchemaChangeListener
implements EventListenerRegistry.ResourceEventListener {
    private final CommonQueryCacheSupporter queryCacheManager;

    public TableSchemaChangeListener(CommonQueryCacheSupporter queryCacheManager) {
        this.queryCacheManager = queryCacheManager;
    }

    public void onUpdate(KylinConfig config, RawResource rawResource) {
        if (Objects.isNull(rawResource)) {
            return;
        }
        this.getProjectName(rawResource.getResPath()).ifPresent(project -> this.clearSchemaCache(config, (String)project));
    }

    public void onDelete(KylinConfig config, String resPath) {
        this.getProjectName(resPath).ifPresent(project -> this.clearSchemaCache(config, (String)project));
    }

    private Optional<String> getProjectName(String resourcePath) {
        if (Objects.isNull(resourcePath)) {
            return Optional.empty();
        }
        if (!resourcePath.contains("table")) {
            return Optional.empty();
        }
        String[] elements = resourcePath.split("/");
        if (elements.length != 4 || elements[2].equalsIgnoreCase("table") || StringUtils.isEmpty((String)elements[1])) {
            return Optional.empty();
        }
        return Optional.of(elements[1]);
    }

    private void clearSchemaCache(KylinConfig config, String project) {
        if (!config.isRedisEnabled()) {
            this.queryCacheManager.onClearSchemaCache(project);
        }
    }
}

