/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.constant;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ProjectInfoParserConstant {
    public static final ProjectInfoParserConstant INSTANCE = new ProjectInfoParserConstant();
    public final List<String> PROJECT_PARSER_URI_LIST;
    public final List<String> PROJECT_PARSER_URI_EXCLUDED_LIST;

    private ProjectInfoParserConstant() {
        ImmutableList.Builder urisBuilder = ImmutableList.builder();
        this.constructUris((ImmutableList.Builder<String>)urisBuilder);
        this.PROJECT_PARSER_URI_LIST = urisBuilder.build();
        ImmutableList.Builder uriExcludedBuilder = ImmutableList.builder();
        this.constructExcludeUris((ImmutableList.Builder<String>)uriExcludedBuilder);
        this.PROJECT_PARSER_URI_EXCLUDED_LIST = uriExcludedBuilder.build();
    }

    private void constructExcludeUris(ImmutableList.Builder<String> uriExcludedBuilder) {
        List<String> projectsSubUris = Arrays.asList("statistics", "acceleration", "acceleration_tag", "config/deletion", "default_configs");
        projectsSubUris.forEach(projectsSubUri -> uriExcludedBuilder.add((Object)String.format(Locale.ROOT, "/kylin/api/projects/%s", projectsSubUri)));
    }

    private void constructUris(ImmutableList.Builder<String> urisBuilder) {
        List<String> projectsSubUris = Arrays.asList("backup", "default_database", "query_accelerate_threshold", "storage_volume_info", "storage", "storage_quota", "favorite_rules", "statistics", "acceleration", "shard_num_config", "garbage_cleanup_config", "job_notification_config", "push_down_config", "scd2_config", "push_down_project_config", "snapshot_config", "computed_column_config", "segment_config", "project_general_info", "project_config", "source_type", "yarn_queue", "project_kerberos_info", "owner", "config", "jdbc_config");
        projectsSubUris.forEach(projectsSubUri -> urisBuilder.add((Object)String.format(Locale.ROOT, "/kylin/api/projects/{project}/%s", projectsSubUri)));
        urisBuilder.add((Object)"/kylin/api/projects/{project}");
        urisBuilder.add((Object)"/kylin/api/models/{project}/{model}/model_desc");
        urisBuilder.add((Object)"/kylin/api/models/{project}/{model}/partition_desc");
        urisBuilder.add((Object)"/api/access/{type}/{project}");
    }
}

