/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.handler.resourcegroup;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupEntity;
import org.apache.kylin.rest.handler.resourcegroup.IResourceGroupRequestValidator;
import org.apache.kylin.rest.request.resourecegroup.ResourceGroupRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=300)
@Component
public class ResourceGroupEntityValidator
implements IResourceGroupRequestValidator {
    @Override
    public void validate(ResourceGroupRequest request) {
        if (!request.isResourceGroupEnabled()) {
            return;
        }
        List<ResourceGroupEntity> entities = request.getResourceGroupEntities();
        HashMap<String, Integer> entityIds = new HashMap<String, Integer>();
        for (ResourceGroupEntity entity : entities) {
            String entityId = entity.getId();
            if (StringUtils.isBlank((String)entityId)) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.RESOURCE_GROUP_ID_EMPTY, new Object[0]);
            }
            if (!entityIds.containsKey(entityId)) {
                entityIds.put(entityId, 1);
            } else {
                entityIds.put(entityId, (Integer)entityIds.get(entityId) + 1);
            }
            if ((Integer)entityIds.get(entityId) <= 1) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.RESOURCE_GROUP_ID_ALREADY_EXIST, new Object[]{entityId});
        }
    }
}

