/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.handler.resourcegroup;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.metadata.resourcegroup.KylinInstance;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupEntity;
import org.apache.kylin.rest.handler.resourcegroup.IResourceGroupRequestValidator;
import org.apache.kylin.rest.request.resourecegroup.ResourceGroupRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=400)
@Component
public class ResourceGroupKylinInstanceValidator
implements IResourceGroupRequestValidator {
    @Override
    public void validate(ResourceGroupRequest request) {
        if (!request.isResourceGroupEnabled()) {
            return;
        }
        List resourceGroups = request.getResourceGroupEntities().stream().map(ResourceGroupEntity::getId).collect(Collectors.toList());
        List<KylinInstance> instances = request.getKylinInstances();
        for (KylinInstance instance : instances) {
            if (StringUtils.isBlank((String)instance.getInstance())) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{"instance"});
            }
            if (StringUtils.isBlank((String)instance.getResourceGroupId())) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{"resource_group_id"});
            }
            if (resourceGroups.contains(instance.getResourceGroupId())) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.RESOURCE_GROUP_ID_NOT_FOUND_IN_INSTANCE, new Object[]{instance.getResourceGroupId()});
        }
        List identities = instances.stream().map(KylinInstance::getInstance).collect(Collectors.toList());
        if (identities.size() != Sets.newHashSet(identities).size()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REPEATED_INSTANCE, new Object[0]);
        }
    }
}

