/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.interceptor;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.constant.ProjectInfoParserConstant;
import org.glassfish.jersey.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectInfoParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectInfoParser.class);
    private static final String PROJECT_PARAM = "project";

    private ProjectInfoParser() {
        throw new IllegalStateException("Utility class");
    }

    public static Pair<String, HttpServletRequest> parseProjectInfo(HttpServletRequest request) {
        Object requestWrapper = request;
        String project = null;
        try {
            ProjectRequest projectRequest;
            String contentType = request.getContentType();
            if (contentType != null && contentType.contains("application/x-www-form-urlencoded")) {
                project = requestWrapper.getParameter(PROJECT_PARAM);
            }
            if (StringUtils.isEmpty((CharSequence)(project = (requestWrapper = new RepeatableBodyRequestWrapper(request)).getParameter(PROJECT_PARAM))) && contentType != null && contentType.contains("json") && (projectRequest = (ProjectRequest)JsonUtil.readValue((byte[])((RepeatableBodyRequestWrapper)((Object)requestWrapper)).getBody(), ProjectRequest.class)) != null) {
                project = projectRequest.getProject();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (StringUtils.isEmpty(project)) {
            project = ProjectInfoParser.extractProject(request.getRequestURI());
        }
        if (StringUtils.isEmpty(project)) {
            project = "_global";
        }
        log.debug("Parsed project {} from request {}", (Object)project, (Object)request.getRequestURI());
        return new Pair((Object)project, requestWrapper);
    }

    static String extractProject(String url) {
        if (ProjectInfoParserConstant.INSTANCE.PROJECT_PARSER_URI_EXCLUDED_LIST.contains(url)) {
            return null;
        }
        for (String needParserURI : ProjectInfoParserConstant.INSTANCE.PROJECT_PARSER_URI_LIST) {
            HashMap kvMap;
            UriTemplate uriTemplate = new UriTemplate(needParserURI);
            if (!uriTemplate.match((CharSequence)url, kvMap = new HashMap())) continue;
            return (String)kvMap.get(PROJECT_PARAM);
        }
        return null;
    }

    public static class ProjectRequest {
        private String project;

        @Generated
        public ProjectRequest() {
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public void setProject(String project) {
            this.project = project;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectRequest)) {
                return false;
            }
            ProjectRequest other = (ProjectRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$project = this.getProject();
            String other$project = other.getProject();
            return !(this$project == null ? other$project != null : !this$project.equals(other$project));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProjectRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $project = this.getProject();
            result = result * 59 + ($project == null ? 43 : $project.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProjectInfoParser.ProjectRequest(project=" + this.getProject() + ")";
        }
    }

    public static class RepeatableBodyRequestWrapper
    extends HttpServletRequestWrapper {
        private final byte[] body;

        public RepeatableBodyRequestWrapper(HttpServletRequest request) throws IOException {
            super(request);
            this.body = IOUtils.toByteArray((InputStream)request.getInputStream());
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
            return new ServletInputStream(){
                private boolean isFinished;

                public boolean isFinished() {
                    return this.isFinished;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() throws IOException {
                    int b = byteArrayInputStream.read();
                    this.isFinished = b == -1;
                    return b;
                }
            };
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), Charset.defaultCharset()));
        }

        @Generated
        public byte[] getBody() {
            return this.body;
        }
    }
}

