/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.interceptor;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.project.NProjectLoader;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.interceptor.ProjectInfoParser;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class RepeatableRequestBodyFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Pair<String, HttpServletRequest> projectInfo = ProjectInfoParser.parseProjectInfo((HttpServletRequest)request);
            String project = (String)projectInfo.getFirst();
            if (StringUtils.isNotEmpty((String)project) && !project.equalsIgnoreCase("_global")) {
                MDC.put((String)"request.project", (String)String.format(Locale.ROOT, "[%s] ", project));
                NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
                ProjectInstance prjInstance = projectManager.getProject(project);
                if (prjInstance != null) {
                    project = prjInstance.getName();
                }
            }
            request = (ServletRequest)projectInfo.getSecond();
            NProjectLoader.updateCache((String)project);
            chain.doFilter(request, response);
        }
        finally {
            MDC.remove((String)"request.project");
            QueryContext.current().close();
            NProjectLoader.removeCache();
        }
    }

    public void destroy() {
    }
}

