/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.interceptor;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.apache.kylin.rest.interceptor.ProjectInfoParser;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=200)
public class ResourceGroupCheckerFilter
implements Filter {
    private static final String ERROR = "error";
    private static final String API_ERROR = "/api/error";
    private static Set<String> notCheckSpecialApiSet = Sets.newHashSet();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ResourceGroupManager manager = ResourceGroupManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        if (!manager.isResourceGroupEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        if (!(request instanceof HttpServletRequest)) {
            return;
        }
        if (this.checkRequestPass((HttpServletRequest)request)) {
            chain.doFilter(request, response);
            return;
        }
        Pair<String, HttpServletRequest> projectInfo = ProjectInfoParser.parseProjectInfo((HttpServletRequest)request);
        String project = (String)projectInfo.getFirst();
        if (!manager.isProjectBindToResourceGroup(project)) {
            Message msg = MsgPicker.getMsg();
            request.setAttribute(ERROR, (Object)new KylinException((ErrorCodeSupplier)ServerErrorCode.PROJECT_WITHOUT_RESOURCE_GROUP, msg.getProjectWithoutResourceGroup()));
            request.getRequestDispatcher(API_ERROR).forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean checkRequestPass(HttpServletRequest request) {
        String uri = StringUtils.stripEnd((String)request.getRequestURI(), (String)"/");
        String method = request.getMethod();
        return "GET".equals(method) || notCheckSpecialApiSet.contains(uri);
    }

    static {
        notCheckSpecialApiSet.add("/kylin/api/error");
    }
}

