/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.monitor;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.metrics.service.MonitorMetric;
import org.apache.kylin.rest.monitor.MonitorReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMonitorCollectTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMonitorCollectTask.class);
    private Set<String> runningServerMode = Sets.newHashSet();

    public AbstractMonitorCollectTask(List<String> runningServerMode) {
        if (CollectionUtils.isNotEmpty(runningServerMode)) {
            this.runningServerMode.addAll(runningServerMode);
        }
    }

    protected abstract MonitorMetric collect();

    @Override
    public void run() {
        try {
            MonitorReporter.getInstance().reportMonitorMetric(this.collect());
        }
        catch (Exception e) {
            logger.error("Failed to run monitor collect task!", (Throwable)e);
        }
    }

    @Generated
    public Set<String> getRunningServerMode() {
        return this.runningServerMode;
    }
}

