/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.monitor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.metrics.service.JobStatusMonitorMetric;
import org.apache.kylin.common.metrics.service.MonitorDao;
import org.apache.kylin.common.metrics.service.MonitorMetric;
import org.apache.kylin.common.metrics.service.QueryMonitorMetric;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.rest.monitor.AbstractMonitorCollectTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorReporter {
    private static final Logger logger = LoggerFactory.getLogger(MonitorReporter.class);
    private final String nodeType;
    private final String serverPort;
    private ScheduledExecutorService dataCollectorExecutor;
    private static final int MAX_SCHEDULED_TASKS = 5;
    private ScheduledExecutorService reportMonitorMetricsExecutor;
    private volatile boolean started = false;
    private static final long REPORT_MONITOR_METRICS_SECONDS = 1L;
    private final Long periodInMilliseconds;
    @VisibleForTesting
    public int reportInitialDelaySeconds = 0;
    private static final int REPORT_QUEUE_CAPACITY = 5000;
    private LinkedBlockingDeque<MonitorMetric> reportQueue = new LinkedBlockingDeque(5000);

    private MonitorReporter() {
        this.dataCollectorExecutor = Executors.newScheduledThreadPool(5, (ThreadFactory)new NamedThreadFactory("data_collector"));
        this.reportMonitorMetricsExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("report_monitor_metrics"));
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        this.periodInMilliseconds = kapConfig.getMonitorInterval();
        this.nodeType = kapConfig.getKylinConfig().getServerMode();
        this.serverPort = kapConfig.getKylinConfig().getServerPort();
    }

    public static MonitorReporter getInstance() {
        return (MonitorReporter)Singletons.getInstance(MonitorReporter.class);
    }

    private static String getLocalIp() {
        return AddressUtil.getLocalHostExactAddress();
    }

    private static String getLocalHost() {
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.warn("Use the InetAddress get local host failed!", (Throwable)e);
        }
        return host;
    }

    private String getLocalPort() {
        return this.serverPort;
    }

    private static String getLocalPid() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getName().split("@")[0];
    }

    private String getNodeType() {
        return this.nodeType;
    }

    private <T extends MonitorMetric> T createMonitorMetric(T monitorMetric) {
        monitorMetric.setIp(MonitorReporter.getLocalIp());
        monitorMetric.setHost(MonitorReporter.getLocalHost());
        monitorMetric.setPort(this.getLocalPort());
        monitorMetric.setPid(MonitorReporter.getLocalPid());
        monitorMetric.setNodeType(this.getNodeType());
        monitorMetric.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        return monitorMetric;
    }

    public QueryMonitorMetric createQueryMonitorMetric() {
        return this.createMonitorMetric(new QueryMonitorMetric());
    }

    public JobStatusMonitorMetric createJobStatusMonitorMetric() {
        return this.createMonitorMetric(new JobStatusMonitorMetric());
    }

    public Integer getQueueSize() {
        return this.reportQueue.size();
    }

    private void reportMonitorMetrics() {
        try {
            int queueSize = this.reportQueue.size();
            for (int i = 0; i < queueSize; ++i) {
                MonitorMetric monitorMetric = this.reportQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (null == monitorMetric) {
                    logger.warn("Found the MonitorMetric poll from reportQueue is null!");
                    continue;
                }
                MonitorDao.getInstance().write2InfluxDB(MonitorDao.getInstance().convert2InfluxDBWriteRequest(monitorMetric));
            }
        }
        catch (Exception e) {
            logger.error("Failed to report monitor metrics to db!", (Throwable)e);
        }
    }

    public void startReporter() {
        this.reportMonitorMetricsExecutor.scheduleWithFixedDelay(this::reportMonitorMetrics, this.reportInitialDelaySeconds, 1L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(this::stopReporter));
        this.started = true;
        logger.info("MonitorReporter started!");
    }

    @VisibleForTesting
    public void stopReporter() {
        ExecutorServiceUtil.forceShutdown((ExecutorService)this.dataCollectorExecutor);
        ExecutorServiceUtil.forceShutdown((ExecutorService)this.reportMonitorMetricsExecutor);
        this.started = false;
        logger.info("MonitorReporter stopped!");
    }

    public void submit(AbstractMonitorCollectTask collectTask) {
        if (!this.started) {
            logger.warn("MonitorReporter is not started!");
            return;
        }
        if (!collectTask.getRunningServerMode().contains(this.getNodeType())) {
            logger.info("This node can not run this collect task, serverMode: {}, task serverMode: {}!", (Object)this.getNodeType(), (Object)StringUtils.join(collectTask.getRunningServerMode(), (String)","));
            return;
        }
        this.dataCollectorExecutor.scheduleWithFixedDelay(collectTask, 0L, this.periodInMilliseconds, TimeUnit.MILLISECONDS);
    }

    public synchronized boolean reportMonitorMetric(MonitorMetric monitorMetric) {
        Preconditions.checkArgument((boolean)this.started, (Object)"MonitorReporter is not started!");
        try {
            this.reportQueue.add(monitorMetric);
        }
        catch (IllegalStateException ie) {
            logger.warn("Monitor metrics report queue is full!", (Throwable)ie);
            return false;
        }
        catch (Exception e) {
            logger.error("Failed to report MonitorMetric!", (Throwable)e);
            return false;
        }
        return true;
    }
}

