/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;

public class LdapAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    private SimpleGrantedAuthority adminRoleAsAuthority;

    public LdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase, String adminRole, SearchControls searchControls) {
        super(contextSource, groupSearchBase);
        this.setConvertToUpperCase(false);
        this.setRolePrefix("");
        this.adminRoleAsAuthority = new SimpleGrantedAuthority(adminRole);
        this.getLdapTemplate().setSearchControls(searchControls);
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
        Set authorities = super.getGroupMembershipRoles(userDn, username);
        HashSet userAuthorities = Sets.newHashSet((Iterable)authorities);
        if (authorities.contains(this.adminRoleAsAuthority)) {
            userAuthorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
        }
        return userAuthorities;
    }
}

