/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import com.google.common.base.Preconditions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.epoch.EpochManager;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.apache.kylin.rest.security.UserLockRuleUtil;
import org.apache.kylin.rest.service.MaintenanceModeSupporter;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.tool.restclient.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class LimitLoginAuthenticationProvider
extends DaoAuthenticationProvider {
    private static final Logger limitLoginLogger = LoggerFactory.getLogger(LimitLoginAuthenticationProvider.class);
    @Autowired
    @Qualifier(value="userService")
    UserService userService;
    @Autowired(required=false)
    @Qualifier(value="maintenanceModeService")
    MaintenanceModeSupporter maintenanceModeService;
    private ConcurrentHashMap<String, RestClient> clientMap = new ConcurrentHashMap();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to init Message Digest ", e);
        }
        md.reset();
        ManagedUser managedUser = null;
        String userName = null;
        try {
            if (authentication instanceof UsernamePasswordAuthenticationToken) {
                userName = (String)authentication.getPrincipal();
            }
            if (userName != null) {
                NKylinUserManager userManager = NKylinUserManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
                managedUser = userManager.get(userName);
                if (managedUser != null) {
                    userName = managedUser.getUsername();
                    authentication = new UsernamePasswordAuthenticationToken((Object)userName, authentication.getCredentials());
                } else {
                    managedUser = (ManagedUser)this.userService.loadUserByUsername(userName);
                }
                Preconditions.checkNotNull((Object)managedUser);
            }
            this.updateUserLockStatus(managedUser, userName);
            Authentication auth = super.authenticate(authentication);
            if (managedUser != null && managedUser.getWrongTime() > 0 && !this.maintenanceModeService.isMaintenanceMode()) {
                managedUser.clearAuthenticateFailedRecord();
                this.updateUser(managedUser);
            }
            SecurityContextHolder.getContext().setAuthentication(auth);
            return auth;
        }
        catch (BadCredentialsException e) {
            this.authenticateFail(managedUser, userName);
            if (managedUser != null && managedUser.isLocked()) {
                if (UserLockRuleUtil.isLockedPermanently((ManagedUser)managedUser)) {
                    this.buildBadCredentialsException(userName, e);
                }
                String msg = MsgPicker.getMsg().getUserBeLocked(UserLockRuleUtil.getLockDurationSeconds((ManagedUser)managedUser));
                limitLoginLogger.error(msg, (Throwable)new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_LOCKED, (Throwable)e));
                throw new BadCredentialsException(msg, (Throwable)new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_LOCKED, (Throwable)e));
            }
            limitLoginLogger.error(ErrorCodeServer.USER_LOGIN_FAILED.getMsg(new Object[0]));
            throw new BadCredentialsException(ErrorCodeServer.USER_LOGIN_FAILED.getMsg(new Object[0]));
        }
        catch (UsernameNotFoundException e) {
            throw new BadCredentialsException(ErrorCodeServer.USER_LOGIN_FAILED.getMsg(new Object[0]), (Throwable)new KylinException((ErrorCodeProducer)ErrorCodeServer.USER_LOGIN_FAILED, new Object[0]));
        }
        catch (IllegalArgumentException e) {
            throw new BadCredentialsException(ErrorCodeServer.USER_LOGIN_FAILED.getMsg(new Object[0]));
        }
    }

    private void buildBadCredentialsException(String userName, BadCredentialsException e) {
        String msg = String.format(Locale.ROOT, MsgPicker.getMsg().getUserInPermanentlyLockedStatus(), userName);
        limitLoginLogger.error(msg, (Throwable)new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_LOCKED, (Throwable)e));
        throw new BadCredentialsException(msg, (Throwable)new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_LOCKED, (Throwable)e));
    }

    private void authenticateFail(ManagedUser managedUser, String userName) {
        if (userName != null && managedUser != null) {
            managedUser.authenticateFail();
            this.updateUser(managedUser);
        }
    }

    private void updateUser(ManagedUser managedUser) {
        boolean isOwner = false;
        EpochManager manager = EpochManager.getInstance();
        try {
            isOwner = manager.checkEpochOwner("_global");
        }
        catch (Exception e) {
            this.logger.error((Object)"Get global epoch owner failed, update locally.", (Throwable)e);
            return;
        }
        if (isOwner) {
            this.userService.updateUser((UserDetails)managedUser);
        } else {
            try {
                String owner = manager.getEpochOwner("_global").split("\\|")[0];
                if (this.clientMap.get(owner) == null) {
                    this.clientMap.clear();
                    this.clientMap.put(owner, new RestClient(owner));
                }
                this.clientMap.get(owner).updateUser((Object)managedUser);
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to update user throw restclient", (Throwable)e);
            }
        }
    }

    private void updateUserLockStatus(ManagedUser managedUser, String userName) {
        if (managedUser != null && managedUser.isLocked()) {
            if (UserLockRuleUtil.isLockedPermanently((ManagedUser)managedUser)) {
                this.buildLockedException(userName);
            }
            long lockedTime = managedUser.getLockedTime();
            long timeDiff = System.currentTimeMillis() - lockedTime;
            if (UserLockRuleUtil.isLockDurationEnded((ManagedUser)managedUser, (long)timeDiff)) {
                managedUser.setLocked(false);
                this.updateUser(managedUser);
            } else {
                long leftSeconds = UserLockRuleUtil.getLockLeftSeconds((ManagedUser)managedUser, (long)timeDiff);
                long nextLockSeconds = UserLockRuleUtil.getLockDurationSeconds((int)(managedUser.getWrongTime() + 1));
                String msg = String.format(Locale.ROOT, MsgPicker.getMsg().getUserInLockedStatus(leftSeconds, nextLockSeconds), userName);
                throw new LockedException(msg);
            }
        }
    }

    private void buildLockedException(String userName) {
        throw new LockedException(String.format(Locale.ROOT, MsgPicker.getMsg().getUserInPermanentlyLockedStatus(), userName));
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

