/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.transaction.AccessBatchGrantEventNotifier;
import org.apache.kylin.common.persistence.transaction.AccessGrantEventNotifier;
import org.apache.kylin.common.persistence.transaction.AccessRevokeEventNotifier;
import org.apache.kylin.common.persistence.transaction.BroadcastEventReadyNotifier;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.request.AccessRequest;
import org.apache.kylin.rest.response.AccessEntryResponse;
import org.apache.kylin.rest.response.AclTCRResponse;
import org.apache.kylin.rest.response.SidPermissionWithAclResponse;
import org.apache.kylin.rest.security.AclEntityFactory;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.AclPermissionFactory;
import org.apache.kylin.rest.security.AclRecord;
import org.apache.kylin.rest.security.CompositeAclPermission;
import org.apache.kylin.rest.security.ExternalAclProvider;
import org.apache.kylin.rest.security.MutableAclRecord;
import org.apache.kylin.rest.security.ObjectIdentityImpl;
import org.apache.kylin.rest.service.AclService;
import org.apache.kylin.rest.service.AclTCRServiceSupporter;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.UserAclService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="accessService")
public class AccessService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(AccessService.class);
    @Autowired
    @Qualifier(value="aclService")
    private AclService aclService;
    @Autowired
    @Qualifier(value="userService")
    protected UserService userService;
    @Autowired(required=false)
    @Qualifier(value="aclTCRService")
    private AclTCRServiceSupporter aclTCRService;
    @Autowired
    @Qualifier(value="userAclService")
    private UserAclService userAclService;

    @Transaction
    public MutableAclRecord init(AclEntity ae, Permission initPermission) {
        MutableAclRecord acl;
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae);
        try {
            acl = (MutableAclRecord)this.aclService.createAcl((ObjectIdentity)objectIdentity);
        }
        catch (AlreadyExistsException e) {
            acl = this.aclService.readAcl((ObjectIdentity)objectIdentity);
        }
        if (null != initPermission) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            PrincipalSid sid = new PrincipalSid(auth);
            acl = this.grant(ae, initPermission, (Sid)sid);
        }
        return acl;
    }

    @Transaction
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public void batchGrant(List<AccessRequest> requests, AclEntity ae) {
        Map<Sid, Permission> sid2perm = requests.stream().map(r -> {
            Sid sid = this.getSid(r.getSid(), r.isPrincipal());
            Permission permission = AclPermissionFactory.getPermission((String)r.getPermission());
            if (Objects.nonNull(sid) && ObjectUtils.isNotEmpty((Object)permission)) {
                return new AbstractMap.SimpleEntry<Sid, Permission>(sid, this.convertToCompositeAclPermission(permission));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.batchGrant(ae, sid2perm);
    }

    private Permission convertToCompositeAclPermission(Permission permission) {
        boolean isDataPermissionDefaultEnabled = KylinConfig.getInstanceFromEnv().isDataPermissionDefaultEnabled();
        return isDataPermissionDefaultEnabled ? new CompositeAclPermission(permission, Collections.singletonList(AclPermission.DATA_QUERY)) : permission;
    }

    @Transaction
    void batchGrant(AclEntity ae, Map<Sid, Permission> sidToPerm) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getAclDomainNotFound());
        }
        if (sidToPerm == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getAclPermissionRequired());
        }
        MutableAclRecord acl = this.aclService.readAcl((ObjectIdentity)new ObjectIdentityImpl(ae));
        if (Objects.isNull(acl)) {
            acl = this.init(ae, null);
        }
        for (Sid sid : sidToPerm.keySet()) {
            this.secureOwner(acl, sid);
        }
        this.aclService.batchUpsertAce(acl, sidToPerm);
    }

    @Transaction
    MutableAclRecord grant(AclEntity ae, Permission permission, Sid sid) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getAclDomainNotFound());
        }
        if (permission == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getAclPermissionRequired());
        }
        if (sid == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_USER_NAME, msg.getSidRequired());
        }
        MutableAclRecord acl = this.aclService.readAcl((ObjectIdentity)new ObjectIdentityImpl(ae));
        if (Objects.isNull(acl)) {
            acl = this.init(ae, null);
        }
        this.secureOwner(acl, sid);
        return this.aclService.upsertAce(acl, sid, this.convertToCompositeAclPermission(permission));
    }

    @Transaction
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public void grant(AclEntity ae, String identifier, Boolean isPrincipal, String permission) {
        Sid sid = this.getSid(identifier, isPrincipal);
        this.grant(ae, AclPermissionFactory.getPermission((String)permission), sid);
    }

    @Transaction
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public MutableAclRecord update(AclEntity ae, int accessEntryIndex, Permission newPermission) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getAclDomainNotFound());
        }
        if (newPermission == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getAclPermissionRequired());
        }
        MutableAclRecord acl = this.aclService.readAcl((ObjectIdentity)new ObjectIdentityImpl(ae));
        Sid sid = acl.getAclRecord().getAccessControlEntryAt(accessEntryIndex).getSid();
        this.secureOwner(acl, sid);
        Permission permission = acl.getAclRecord().getAccessControlEntryAt(accessEntryIndex).getPermission();
        return this.aclService.upsertAce(acl, sid, AclPermissionUtil.modifyBasePermission((Permission)permission, (Permission)newPermission));
    }

    @Transaction
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or (hasPermission(#ae, 'DATA_QUERY') and hasPermission(#ae, 'ADMINISTRATION'))")
    public MutableAclRecord updateExtensionPermission(AclEntity ae, AccessRequest accessRequest) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getAclDomainNotFound());
        }
        if (SecurityContextHolder.getContext().getAuthentication().getAuthorities().contains(new SimpleGrantedAuthority("ROLE_ADMIN")) && !this.userAclService.canAdminUserQuery()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getAclPermissionRequired());
        }
        MutableAclRecord acl = this.aclService.readAcl((ObjectIdentity)new ObjectIdentityImpl(ae));
        Sid sid = this.getSid(accessRequest.getSid(), accessRequest.isPrincipal());
        Permission permission = this.getPermission(accessRequest, acl);
        if (Objects.isNull(permission)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getAclPermissionRequired());
        }
        if (accessRequest.getAccessEntryId() != null) {
            sid = acl.getAclRecord().getAccessControlEntryAt(accessRequest.getAccessEntryId().intValue()).getSid();
        }
        this.secureOwner(acl, sid);
        List extPermissions = AclPermissionFactory.getExtPermissions(accessRequest.getExtPermissions());
        Permission basePermission = AclPermissionUtil.convertToBasePermission((Permission)permission);
        CompositeAclPermission newPermission = new CompositeAclPermission(basePermission, extPermissions);
        return this.aclService.upsertAce(acl, sid, (Permission)newPermission);
    }

    private Permission getPermission(AccessRequest accessRequest, MutableAclRecord acl) {
        Sid sid = this.getSid(accessRequest.getSid(), accessRequest.isPrincipal());
        if (accessRequest.getAccessEntryId() != null) {
            return acl.getAclRecord().getAccessControlEntryAt(accessRequest.getAccessEntryId().intValue()).getPermission();
        }
        Optional<AccessControlEntry> optAce = acl.getEntries().stream().filter(ace -> ace.getSid().equals((Object)sid)).findFirst();
        return optAce.isPresent() ? optAce.get().getPermission() : null;
    }

    @Transaction
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public MutableAclRecord revoke(AclEntity ae, int accessEntryIndex) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getAclDomainNotFound());
        }
        MutableAclRecord acl = this.aclService.readAcl((ObjectIdentity)new ObjectIdentityImpl(ae));
        Sid sid = acl.getAclRecord().getAccessControlEntryAt(accessEntryIndex).getSid();
        this.secureOwner(acl, sid);
        return this.aclService.upsertAce(acl, sid, null);
    }

    @Transaction
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public MutableAclRecord revokeWithSid(AclEntity ae, String name, boolean principal) {
        Message msg = MsgPicker.getMsg();
        if (Objects.isNull(ae)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getAclDomainNotFound());
        }
        MutableAclRecord acl = this.aclService.readAcl((ObjectIdentity)new ObjectIdentityImpl(ae));
        Sid sid = acl.getAclRecord().getAceBySidAndPrincipal(name, principal);
        this.secureOwner(acl, sid);
        return this.aclService.upsertAce(acl, sid, null);
    }

    @Transaction
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public void batchRevoke(AclEntity ae, List<AccessRequest> requests) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getAclDomainNotFound());
        }
        Permission emptyPermission = BasePermission.READ;
        Map<Sid, Permission> sid2perm = requests.stream().map(r -> new AbstractMap.SimpleEntry<Sid, Permission>(this.getSid(r.getSid(), r.isPrincipal()), emptyPermission)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        sid2perm.entrySet().forEach(e -> {
            Permission cfr_ignored_0 = e.setValue(null);
        });
        this.batchGrant(ae, sid2perm);
    }

    void inherit(AclEntity ae, AclEntity parentAe) {
        MutableAclRecord parentAcl;
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getAclDomainNotFound());
        }
        if (parentAe == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getParentAclNotFound());
        }
        MutableAclRecord acl = this.aclService.readAcl((ObjectIdentity)new ObjectIdentityImpl(ae));
        if (Objects.isNull(acl)) {
            acl = this.init(ae, null);
        }
        if (Objects.isNull(parentAcl = this.aclService.readAcl((ObjectIdentity)new ObjectIdentityImpl(parentAe)))) {
            parentAcl = this.init(parentAe, null);
        }
        if (null == acl || null == parentAcl) {
            return;
        }
        this.aclService.inherit(acl, parentAcl);
    }

    @Transaction
    public void revokeProjectPermission(String name, String type) {
        PrincipalSid sid = null;
        if (type.equalsIgnoreCase("user")) {
            sid = new PrincipalSid(name);
        } else if (type.equalsIgnoreCase("group")) {
            sid = new GrantedAuthoritySid(name);
        } else {
            return;
        }
        List projectInstances = this.getManager(NProjectManager.class).listAllProjects();
        for (ProjectInstance pi : projectInstances) {
            Permission perm;
            RootPersistentEntity ae = this.getAclEntity("ProjectInstance", pi.getUuid());
            MutableAclRecord acl = this.getAcl((AclEntity)ae);
            if (Objects.isNull(acl) || (perm = acl.getAclRecord().getPermission((Sid)sid)) == null) continue;
            this.secureOwner(acl, (Sid)sid);
            this.aclService.upsertAce(acl, (Sid)sid, null);
        }
    }

    @Transaction
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public void clean(AclEntity ae, boolean deleteChildren) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getAclDomainNotFound());
        }
        if (ae.getId() == null) {
            return;
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae);
        try {
            this.aclService.deleteAcl((ObjectIdentity)objectIdentity, deleteChildren);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public RootPersistentEntity getAclEntity(String entityType, String uuid) {
        if (null == uuid) {
            return null;
        }
        return AclEntityFactory.createAclEntity((String)entityType, (String)uuid);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION') or hasPermission(#ae, 'MANAGEMENT') or hasPermission(#ae, 'OPERATION') or hasPermission(#ae, 'READ')")
    public MutableAclRecord getAcl(AclEntity ae) {
        if (null == ae) {
            return null;
        }
        return this.aclService.readAcl((ObjectIdentity)new ObjectIdentityImpl(ae));
    }

    public Sid getSid(String sid, boolean isPrincipal) {
        if (isPrincipal) {
            return new PrincipalSid(sid);
        }
        return new GrantedAuthoritySid(sid);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public List<AccessEntryResponse> generateAceResponsesByFuzzMatching(AclEntity ae, String nameSeg, boolean isCaseSensitive) throws IOException {
        List<AccessEntryResponse> resultsAfterFuzzyMatching = this.generateAceResponsesByFuzzMatching((Acl)this.getAcl(ae), nameSeg, isCaseSensitive);
        Map<Boolean, List<AccessEntryResponse>> collect = resultsAfterFuzzyMatching.stream().collect(Collectors.partitioningBy(user -> user.getSid() instanceof GrantedAuthoritySid));
        Stream<AccessEntryResponse> groupAccessEntryResponseStream = collect.get(true).stream().filter(user -> !StringUtils.equalsIgnoreCase((String)((GrantedAuthoritySid)user.getSid()).getGrantedAuthority(), (String)"ROLE_ADMIN"));
        Map userAccessEntryResponse = collect.get(false).stream().collect(Collectors.toMap(user -> ((PrincipalSid)user.getSid()).getPrincipal(), Function.identity(), (p, q) -> p));
        Set<String> normalUsers = this.userService.retainsNormalUser(userAccessEntryResponse.keySet());
        return Stream.concat(groupAccessEntryResponseStream, userAccessEntryResponse.entrySet().stream().filter(entry -> normalUsers.contains(entry.getKey())).map(Map.Entry::getValue)).collect(Collectors.toList());
    }

    private List<AccessEntryResponse> generateAceResponsesByFuzzMatching(Acl acl, String nameSeg, boolean isCaseSensitive) {
        if (Objects.isNull(acl)) {
            return Collections.emptyList();
        }
        ArrayList<AccessEntryResponse> result = new ArrayList<AccessEntryResponse>();
        for (AccessControlEntry ace : acl.getEntries()) {
            if (this.nameSegNotMatch(ace, nameSeg, isCaseSensitive) || this.sidNotExists(ace)) continue;
            result.add(new AccessEntryResponse(ace.getId(), ace.getSid(), ace.getPermission(), ace.isGranting()));
        }
        return result;
    }

    private boolean nameSegNotMatch(AccessControlEntry ace, String nameSeg, boolean isCaseSensitive) {
        return StringUtils.isNotEmpty((String)nameSeg) && !this.needAdd(nameSeg, isCaseSensitive, AccessService.getName(ace.getSid()));
    }

    private boolean sidNotExists(AccessControlEntry ace) {
        return this.isPrincipalSidNotExists(ace.getSid()) || this.isGrantedAuthoritySidNotExists(ace.getSid());
    }

    private boolean needAdd(String nameSeg, boolean isCaseSensitive, String name) {
        return isCaseSensitive && StringUtils.contains((String)name, (String)nameSeg) || !isCaseSensitive && StringUtils.containsIgnoreCase((String)name, (String)nameSeg);
    }

    public static String getName(Sid sid) {
        if (sid instanceof PrincipalSid) {
            return ((PrincipalSid)sid).getPrincipal();
        }
        return ((GrantedAuthoritySid)sid).getGrantedAuthority();
    }

    public boolean isPrincipalSidNotExists(Sid sid) {
        return sid instanceof PrincipalSid && !this.userService.userExists(((PrincipalSid)sid).getPrincipal());
    }

    public boolean isGrantedAuthoritySidNotExists(Sid sid) {
        try {
            return sid instanceof GrantedAuthoritySid && !this.userGroupService.exists(((GrantedAuthoritySid)sid).getGrantedAuthority());
        }
        catch (IOException e) {
            return true;
        }
    }

    public List<AccessEntryResponse> generateAceResponses(Acl acl) {
        return this.generateAceResponsesByFuzzMatching(acl, null, false);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public Map<String, List<String>> getProjectUsersAndGroups(AclEntity ae) throws IOException {
        HashMap result = Maps.newHashMap();
        ArrayList<String> userList = new ArrayList<String>();
        List<String> normalUsers = this.getAllAclSids(ae, "user");
        Set<String> adminUsers = this.userService.getGlobalAdmin();
        normalUsers.removeIf(adminUsers::contains);
        userList.addAll(normalUsers);
        userList.addAll(adminUsers);
        result.put("user", userList);
        ArrayList<String> userGroupList = new ArrayList<String>();
        userGroupList.addAll(this.getAllAclSids(ae, "group"));
        userGroupList.add("ROLE_ADMIN");
        result.put("group", userGroupList);
        return result;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public List<String> getAllAclSids(AclEntity ae, String type) {
        MutableAclRecord acl = this.getAcl(ae);
        if (null == acl) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (AccessControlEntry ace : acl.getEntries()) {
            String name = null;
            boolean notExisted = false;
            if (type.equalsIgnoreCase("user") && ace.getSid() instanceof PrincipalSid) {
                name = ((PrincipalSid)ace.getSid()).getPrincipal();
                notExisted = this.isPrincipalSidNotExists(ace.getSid());
            }
            if (type.equalsIgnoreCase("group") && ace.getSid() instanceof GrantedAuthoritySid) {
                name = ((GrantedAuthoritySid)ace.getSid()).getGrantedAuthority();
                notExisted = this.isGrantedAuthoritySidNotExists(ace.getSid());
            }
            if (StringUtils.isBlank(name) || notExisted) continue;
            result.add(name);
        }
        return result;
    }

    private void secureOwner(MutableAclRecord acl, Sid sid) {
        Message msg = MsgPicker.getMsg();
        AclRecord record = acl.getAclRecord();
        if (!record.getOwner().equals((Object)sid)) {
            return;
        }
        if (BasePermission.ADMINISTRATION.equals(record.getPermission(sid))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getRevokeAdminPermission());
        }
    }

    private String getUserPermissionInProject(String project, String username) throws IOException {
        return (String)this.getUserMaximumPermissionWithSourceInProject(project, username).getFirst();
    }

    private Pair<String, Pair<Boolean, String>> getUserMaximumPermissionWithSourceInProject(String project, String username) throws IOException {
        if (this.isGlobalAdmin(username)) {
            return Pair.newPair((Object)"ADMIN", (Object)Pair.newPair((Object)Boolean.FALSE, null));
        }
        if (this.hasGlobalAdminGroup(username)) {
            return Pair.newPair((Object)"ADMIN", (Object)Pair.newPair((Object)Boolean.TRUE, (Object)"ROLE_ADMIN"));
        }
        Map<Sid, Integer> projectPermissions = this.getProjectPermission(project);
        List<String> groups = this.getGroupsOfUser(username);
        return this.getUserNormalPermission(projectPermissions, groups, username);
    }

    public Pair<String, Pair<Boolean, String>> getUserNormalPermission(String project, UserDetails user) {
        Map<Sid, Integer> projectPermissions = this.getProjectPermission(project);
        List<String> groups = user.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        return this.getUserNormalPermission(projectPermissions, groups, user.getUsername());
    }

    public Pair<String, Pair<Boolean, String>> getUserNormalPermission(String projectUuid, String username) {
        Map<Sid, Integer> projectPermissions = this.getProjectUuidPermission(projectUuid);
        List<String> groups = this.getGroupsOfUser(username);
        return this.getUserNormalPermission(projectPermissions, groups, username);
    }

    public Pair<String, Pair<Boolean, String>> getUserNormalPermission(Map<Sid, Integer> projectPermissions, List<String> groups, String userName) {
        Integer greaterPermissionMask = projectPermissions.get(this.getSid(userName, true));
        String greaterPermissionGroup = null;
        for (String group : groups) {
            if (Objects.nonNull(greaterPermissionMask) && greaterPermissionMask.intValue() == BasePermission.ADMINISTRATION.getMask()) break;
            Integer groupMask = projectPermissions.get(this.getSid(group, false));
            Integer compareResultMask = this.getGreaterPermissionMask(groupMask, greaterPermissionMask);
            if (compareResultMask.equals(greaterPermissionMask)) continue;
            greaterPermissionGroup = group;
            greaterPermissionMask = compareResultMask;
        }
        Pair groupInfo = Pair.newPair((Object)Boolean.FALSE, null);
        if (Objects.nonNull(greaterPermissionGroup)) {
            groupInfo.setKey((Object)Boolean.TRUE);
            groupInfo.setValue(greaterPermissionGroup);
        }
        return Pair.newPair((Object)ExternalAclProvider.convertToExternalPermission((int)greaterPermissionMask), (Object)groupInfo);
    }

    public String getCurrentUserPermissionInProject(String project) throws IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (Objects.nonNull(authentication)) {
            return this.getUserPermissionInProject(project, authentication.getName());
        }
        return null;
    }

    public String getCurrentNormalUserPermissionInProject(String project) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (Objects.nonNull(authentication)) {
            UserDetails userDetails = this.userService.loadUserByUsername(authentication.getName());
            return (String)this.getUserNormalPermission(project, userDetails).getFirst();
        }
        return null;
    }

    private Map<Sid, Set<Integer>> getProjectExtPermissions(String projectUuid) {
        Map<Sid, Set<Integer>> sidWithPermissions = new HashMap<Sid, Set<Integer>>();
        RootPersistentEntity ae = this.getAclEntity("ProjectInstance", projectUuid);
        AclRecord aclRecord = this.getAcl((AclEntity)ae).getAclRecord();
        if (aclRecord != null && aclRecord.getEntries() != null) {
            List aces = aclRecord.getEntries();
            sidWithPermissions = aces.stream().filter(ace -> AclPermissionUtil.hasExtPermission((Permission)ace.getPermission())).collect(Collectors.toMap(AccessControlEntry::getSid, ace -> new HashSet(AclPermissionUtil.convertToCompositePermission((Permission)ace.getPermission()).getExtMasks())));
        }
        return sidWithPermissions;
    }

    public Set<String> getUserNormalExtPermissions(String project) {
        String projectUuid = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).getUuid();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (Objects.nonNull(authentication)) {
            String userName = authentication.getName();
            if (this.userAclService.canAdminUserQuery(userName)) {
                return Collections.singleton("DATA_QUERY");
            }
            if (this.userService.isGlobalAdmin(userName)) {
                boolean hasDataQueryPermission = this.userAclService.hasUserAclPermissionInProject(userName, project);
                return hasDataQueryPermission ? Collections.singleton("DATA_QUERY") : Collections.emptySet();
            }
            return this.getUserNormalExtPermissions(projectUuid, userName).stream().map(ExternalAclProvider::convertToExternalPermission).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    public Set<Integer> getUserNormalExtPermissions(String projectUuid, String username) {
        Map<Sid, Set<Integer>> projectPermissions = this.getProjectExtPermissions(projectUuid);
        return this.getUserNormalExtPermissions(projectPermissions, this.getGroupsOfUser(username), username);
    }

    public Set<Integer> getUserNormalExtPermissions(Map<Sid, Set<Integer>> projectPermissions, List<String> groups, String userName) {
        Set<Integer> allPermissionMasks = projectPermissions.get(this.getSid(userName, true));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(allPermissionMasks)) {
            allPermissionMasks = new HashSet<Integer>();
        }
        for (String group : groups) {
            Set<Integer> groupMasks = projectPermissions.get(this.getSid(group, false));
            if (org.apache.commons.collections.CollectionUtils.isEmpty(groupMasks)) continue;
            allPermissionMasks.addAll(groupMasks);
        }
        return allPermissionMasks;
    }

    private String getGroupPermissionInProject(String project, String groupName) throws IOException {
        this.checkSid(groupName, false);
        if ("ROLE_ADMIN".equals(groupName)) {
            return "ADMIN";
        }
        Map<Sid, Integer> projectPermissions = this.getProjectPermission(project);
        int mask = projectPermissions.get(this.getSid(groupName, false));
        return ExternalAclProvider.convertToExternalPermission((int)mask);
    }

    private Map<Sid, Integer> getProjectPermission(String project) {
        String uuid = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).getUuid();
        return this.getProjectUuidPermission(uuid);
    }

    private Map<Sid, Integer> getProjectUuidPermission(String projectUuid) {
        HashMap<Sid, Integer> sidWithPermission = new HashMap<Sid, Integer>();
        RootPersistentEntity ae = this.getAclEntity("ProjectInstance", projectUuid);
        if (this.getAcl((AclEntity)ae) != null && this.getAcl((AclEntity)ae).getEntries() != null) {
            AclRecord aclRecord = this.getAcl((AclEntity)ae).getAclRecord();
            List aces = aclRecord.getEntries();
            for (AccessControlEntry ace : aces) {
                Sid sid = ace.getSid();
                sidWithPermission.put(sid, AclPermissionUtil.convertToBasePermission((Permission)ace.getPermission()).getMask());
            }
        }
        return sidWithPermission;
    }

    public boolean hasProjectPermission(String project, String sid, boolean isPrincipal) {
        Map<Sid, Integer> projectPermissionMap = this.getProjectPermission(project);
        return projectPermissionMap.containsKey(this.getSid(sid, isPrincipal));
    }

    public List<String> getGrantedProjectsOfUser(String user) throws IOException {
        return this.getGrantedProjectsOfUserOrGroup(user, true);
    }

    public List<String> getGrantedProjectsOfUserOrGroup(String name, boolean principal) throws IOException {
        boolean adminGroup;
        this.checkSid(name, principal);
        List projects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
        boolean userWithGlobalAdminPermission = principal && (this.isGlobalAdmin(name) || this.hasGlobalAdminGroup(name));
        boolean bl = adminGroup = !principal && "ROLE_ADMIN".equals(name);
        if (userWithGlobalAdminPermission || adminGroup) {
            return projects.stream().map(ProjectInstance::getName).collect(Collectors.toList());
        }
        List groupsOfUser = principal ? this.getGroupsOfUser(name) : Collections.emptyList();
        HashSet<String> grantedProjects = new HashSet<String>();
        for (ProjectInstance project : projects) {
            Map<Sid, Integer> projectPermissionMap = this.getProjectPermission(project.getName());
            if (projectPermissionMap.containsKey(this.getSid(name, principal))) {
                grantedProjects.add(project.getName());
                continue;
            }
            boolean userGroupGranted = groupsOfUser.stream().anyMatch(group -> projectPermissionMap.containsKey(this.getSid((String)group, false)));
            if (!userGroupGranted) continue;
            grantedProjects.add(project.getName());
        }
        return Lists.newArrayList(grantedProjects);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<SidPermissionWithAclResponse> getUserOrGroupAclPermissions(List<String> projects, String userOrGroupName, boolean principal) throws IOException {
        this.checkSid(userOrGroupName, principal);
        ArrayList<SidPermissionWithAclResponse> sidPermissionWithAclResponse = new ArrayList<SidPermissionWithAclResponse>();
        for (String project : projects) {
            SidPermissionWithAclResponse permissionWithAclResponse = principal ? this.getUserPermissionWithAclResponse(project, userOrGroupName) : this.getGroupPermissionWithAclResponse(project, userOrGroupName);
            sidPermissionWithAclResponse.add(permissionWithAclResponse);
        }
        return sidPermissionWithAclResponse;
    }

    private SidPermissionWithAclResponse getUserPermissionWithAclResponse(String project, String username) throws IOException {
        Pair<String, Pair<Boolean, String>> permissionInfo = this.getUserMaximumPermissionWithSourceInProject(project, username);
        if (Boolean.FALSE.equals(((Pair)permissionInfo.getSecond()).getFirst())) {
            List<AclTCRResponse> aclTCRResponses = this.aclTCRService.getAclTCRResponse(project, username, true, false);
            return new SidPermissionWithAclResponse(project, (String)permissionInfo.getFirst(), aclTCRResponses);
        }
        return this.getGroupPermissionWithAclResponse(project, (String)((Pair)permissionInfo.getSecond()).getSecond());
    }

    private SidPermissionWithAclResponse getGroupPermissionWithAclResponse(String project, String groupName) throws IOException {
        String permission = this.getGroupPermissionInProject(project, groupName);
        List<AclTCRResponse> aclTCRResponses = this.aclTCRService.getAclTCRResponse(project, groupName, false, false);
        return new SidPermissionWithAclResponse(project, permission, aclTCRResponses);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Set<String> getProjectAdminUsers(String project) throws IOException {
        MutableAclRecord acl = AclPermissionUtil.getProjectAcl((String)project);
        Set groupsInProject = AclPermissionUtil.filterGroupsInProject((MutableAclRecord)acl);
        return this.userService.listUsers().parallelStream().filter(user -> {
            Set userGroupsInProject = user.getAuthorities().stream().map(SimpleGrantedAuthority::getAuthority).filter(groupsInProject::contains).collect(Collectors.toSet());
            return user.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch("ROLE_ADMIN"::equals) || AclPermissionUtil.isSpecificPermissionInProject((String)user.getUsername(), userGroupsInProject, (Permission)BasePermission.ADMINISTRATION, (MutableAclRecord)acl);
        }).map(ManagedUser::getUsername).collect(Collectors.toSet());
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    public Set<String> getProjectManagementUsers(String project) throws IOException {
        MutableAclRecord acl = AclPermissionUtil.getProjectAcl((String)project);
        Set groupsInProject = AclPermissionUtil.filterGroupsInProject((MutableAclRecord)acl);
        AclPermissionUtil.filterGroupsInProject((MutableAclRecord)acl);
        return this.userService.listUsers().parallelStream().filter(user -> {
            Set userGroupsInProject = user.getAuthorities().stream().map(SimpleGrantedAuthority::getAuthority).filter(groupsInProject::contains).collect(Collectors.toSet());
            return user.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch("ROLE_ADMIN"::equals) || AclPermissionUtil.isSpecificPermissionInProject((String)user.getUsername(), userGroupsInProject, (Permission)BasePermission.ADMINISTRATION, (MutableAclRecord)acl) || AclPermissionUtil.isSpecificPermissionInProject((String)user.getUsername(), userGroupsInProject, (Permission)AclPermission.MANAGEMENT, (MutableAclRecord)acl);
        }).map(ManagedUser::getUsername).collect(Collectors.toSet());
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public boolean remoteGrantAccess(AclEntity ae, String identifier, Boolean isPrincipal, String permission) {
        AccessGrantEventNotifier notifier = new AccessGrantEventNotifier("_global", ae.getId(), identifier, isPrincipal, permission);
        return this.remoteRequest((BroadcastEventReadyNotifier)notifier, null);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public boolean remoteBatchGrantAccess(List<AccessRequest> requests, AclEntity ae) throws JsonProcessingException {
        AccessBatchGrantEventNotifier notifier = new AccessBatchGrantEventNotifier("_global", ae.getId(), JsonUtil.writeValueAsString(requests));
        return this.remoteRequest((BroadcastEventReadyNotifier)notifier, null);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public boolean remoteRevokeAccess(AclEntity ae, String name, boolean principal) {
        AccessRevokeEventNotifier notifier = new AccessRevokeEventNotifier("_global", ae.getId(), name, principal);
        return this.remoteRequest((BroadcastEventReadyNotifier)notifier, null);
    }

    @Transaction
    public void updateAccessFromRemote(AccessGrantEventNotifier grantNotifier, AccessBatchGrantEventNotifier batchGrantNotifier, AccessRevokeEventNotifier revokeNotifier) throws IOException {
        RootPersistentEntity ae;
        if (grantNotifier != null) {
            ae = this.getAclEntity("ProjectInstance", grantNotifier.getEntityId());
            this.grant((AclEntity)ae, grantNotifier.getIdentifier(), grantNotifier.getIsPrincipal(), grantNotifier.getPermission());
        }
        if (batchGrantNotifier != null) {
            ae = this.getAclEntity("ProjectInstance", batchGrantNotifier.getEntityId());
            List accessRequest = (List)JsonUtil.readValue((String)batchGrantNotifier.getRawAclTCRRequests(), (TypeReference)new TypeReference<List<AccessRequest>>(){});
            this.batchGrant(accessRequest, (AclEntity)ae);
        }
        if (revokeNotifier != null) {
            ae = this.getAclEntity("ProjectInstance", revokeNotifier.getEntityId());
            this.revokeWithSid((AclEntity)ae, revokeNotifier.getName(), revokeNotifier.isPrincipal());
        }
    }

    public List<String> getGroupsOfCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (Objects.nonNull(authentication)) {
            return this.getGroupsOfUser(authentication.getName());
        }
        return Lists.newArrayList();
    }

    public Set<String> getGroupsOfExecuteUser(String user) {
        if (Objects.nonNull(user)) {
            return new HashSet<String>(this.getGroupsOfUser(user));
        }
        return Sets.newHashSet();
    }

    private List<String> getGroupsOfUser(String username) {
        ManagedUser user = this.getManagedUser(username);
        if (Objects.isNull(user)) {
            Message msg = MsgPicker.getMsg();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_NOT_EXIST, String.format(Locale.ROOT, msg.getUserNotFound(), username));
        }
        List authorities = user.getAuthorities();
        return authorities.stream().map(SimpleGrantedAuthority::getAuthority).collect(Collectors.toList());
    }

    private ManagedUser getManagedUser(String username) {
        UserDetails details = this.userService.loadUserByUsername(username);
        if (details == null) {
            return null;
        }
        return (ManagedUser)details;
    }

    private Integer getGreaterPermissionMask(Integer mask1, Integer mask2) {
        if (mask1 == null && mask2 == null) {
            return 0;
        }
        if (mask1 != null && mask2 == null) {
            return mask1;
        }
        if (mask1 == null && mask2 != null) {
            return mask2;
        }
        if (mask1 == 16 || mask2 == 16) {
            return 16;
        }
        if (mask1 == 32 || mask2 == 32) {
            return 32;
        }
        if (mask1 == 64 || mask2 == 64) {
            return 64;
        }
        if (mask1 == 1 || mask2 == 1) {
            return 1;
        }
        return 0;
    }

    public void checkGlobalAdmin(String username) throws IOException {
        this.checkGlobalAdmin(Collections.singletonList(username));
    }

    public void checkGlobalAdmin(List<String> usernames) throws IOException {
        if (this.userService.containsGlobalAdmin(new HashSet<String>(usernames))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getChangeGlobaladmin());
        }
    }

    public void checkDefaultAdmin(String username, boolean isDefaultAdminHasRight) {
        List<String> superAdminUsers = this.userService.listSuperAdminUsers();
        if (!CollectionUtils.isEmpty(superAdminUsers) && superAdminUsers.stream().filter(u -> u.equalsIgnoreCase(username)).collect(Collectors.toList()).size() > 0) {
            String currentUser = AclPermissionUtil.getCurrentUsername();
            if (!isDefaultAdminHasRight || !superAdminUsers.stream().anyMatch(u -> u.equalsIgnoreCase(currentUser))) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getChangeDefaultadmin());
            }
        }
    }

    public void checkAccessRequestList(List<AccessRequest> requests) throws IOException {
        this.checkSid(requests);
        List<String> users = requests.stream().filter(AccessRequest::isPrincipal).map(AccessRequest::getSid).collect(Collectors.toList());
        this.checkGlobalAdmin(users);
    }

    public void checkSid(List<AccessRequest> requests) throws IOException {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(requests)) {
            return;
        }
        List<String> allGroups = this.userGroupService.getAllUserGroups();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(allGroups)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_USERGROUP_NAME, MsgPicker.getMsg().getEmptySid());
        }
        HashSet groupSet = Sets.newHashSet(allGroups);
        for (AccessRequest r : requests) {
            this.batchCheckSid(r.getSid(), r.isPrincipal(), groupSet);
        }
    }

    public void checkSidNotEmpty(String sid, boolean principal) {
        if (StringUtils.isEmpty((String)sid)) {
            if (principal) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_USER_NAME, MsgPicker.getMsg().getEmptySid());
            }
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_USERGROUP_NAME, MsgPicker.getMsg().getEmptySid());
        }
    }

    private void checkUserValid(String user) {
        if (StringUtils.isEmpty((String)user)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_USER_NAME, MsgPicker.getMsg().getEmptySid());
        }
        if (!this.userService.userExists(user)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, String.format(Locale.ROOT, MsgPicker.getMsg().getOperationFailedByUserNotExist(), user));
        }
    }

    private void checkGroupValid(String group, Collection<String> allGroups) {
        if (StringUtils.isEmpty((String)group) || org.apache.commons.collections.CollectionUtils.isEmpty(allGroups)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_USERGROUP_NAME, MsgPicker.getMsg().getEmptySid());
        }
        if (!allGroups.contains(group)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.USER_GROUP_NOT_EXIST, new Object[]{group});
        }
    }

    public void batchCheckSid(String sid, boolean principal, Collection<String> groups) {
        if (principal) {
            this.checkUserValid(sid);
        } else {
            this.checkGroupValid(sid, groups);
        }
    }

    public void checkSid(String sid, boolean principal) throws IOException {
        this.checkSidNotEmpty(sid, principal);
        if (principal && !this.userService.userExists(sid)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, String.format(Locale.ROOT, MsgPicker.getMsg().getOperationFailedByUserNotExist(), sid));
        }
        if (!principal && !this.userGroupService.exists(sid)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.USER_GROUP_NOT_EXIST, new Object[]{sid});
        }
    }

    public boolean isGlobalAdmin(String username) throws IOException {
        Set<String> adminUsers = this.userService.getGlobalAdmin();
        return adminUsers.contains(username);
    }

    public boolean hasGlobalAdminGroup(String username) {
        List<String> groups = this.getGroupsOfUser(username);
        return groups.contains("ROLE_ADMIN");
    }
}

