/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.CaseFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.BroadcastEventReadyNotifier;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.epoch.EpochManager;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.streaming.DataParserManager;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.rest.util.NullsLastPropertyComparator;
import org.apache.kylin.tool.restclient.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicService.class);
    @Autowired
    @Qualifier(value="normalRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    @Qualifier(value="userGroupService")
    protected IUserGroupService userGroupService;

    public KylinConfig getConfig() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (kylinConfig == null) {
            throw new IllegalArgumentException("Failed to load kylin config instance");
        }
        return kylinConfig;
    }

    public <T> T getManager(Class<T> clz) {
        return (T)this.getConfig().getManager(clz);
    }

    public <T> T getManager(Class<T> clz, String project) {
        return (T)this.getConfig().getManager(project, clz);
    }

    protected static String getUsername() {
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        if (StringUtils.isEmpty((String)username)) {
            username = "";
        }
        return username;
    }

    protected static <T> Comparator<T> propertyComparator(String property, boolean ascending) {
        return new PropertyComparator(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, property), false, ascending);
    }

    protected static <T> Comparator<T> nullsLastPropertyComparator(String property, boolean ascending) {
        return new NullsLastPropertyComparator(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, property), false, ascending);
    }

    public <T> EnvelopeResponse<T> generateTaskForRemoteHost(HttpServletRequest request, String url) throws Exception {
        ResponseEntity<byte[]> response = this.getHttpResponse(request, url);
        return (EnvelopeResponse)JsonUtil.readValue((byte[])((byte[])response.getBody()), EnvelopeResponse.class);
    }

    private ResponseEntity<byte[]> getHttpResponse(HttpServletRequest request, String url) throws IOException {
        byte[] body = IOUtils.toByteArray((InputStream)request.getInputStream());
        HttpHeaders headers = new HttpHeaders();
        Collections.list(request.getHeaderNames()).forEach(k -> headers.put(k, Collections.list(request.getHeaders(k))));
        headers.remove((Object)"Accept-Encoding");
        return this.restTemplate.exchange(url, HttpMethod.valueOf((String)request.getMethod()), new HttpEntity((Object)body, (MultiValueMap)headers), byte[].class, new Object[0]);
    }

    public Set<String> getCurrentUserGroups() {
        return this.userGroupService.listUserGroups(AclPermissionUtil.getCurrentUsername());
    }

    public boolean remoteRequest(BroadcastEventReadyNotifier notifier, String projectId) {
        try {
            String projectName = notifier.getProject();
            EpochManager epochManager = EpochManager.getInstance();
            if (StringUtils.isNotBlank((String)projectId)) {
                projectName = this.getManager(NProjectManager.class).getProjectById(projectId).getName();
            }
            String owner = epochManager.getEpochOwner(projectName).split("\\|")[0];
            new RestClient(owner).notify(notifier);
        }
        catch (Exception e) {
            log.error("Failed to using rest client request.", (Throwable)e);
            return false;
        }
        return true;
    }

    public Pair<String, String> checkDatabaseAndTable(String table) {
        if (table == null) {
            table = "";
        }
        String database = null;
        if (table.contains(".")) {
            database = table.split("\\.", 2)[0].trim();
            table = table.split("\\.", 2)[1].trim();
        }
        return Pair.newPair(database, (Object)table);
    }

    protected void initDefaultParser(String project) {
        if (this.getManager(DataParserManager.class, project).isInitialized()) {
            return;
        }
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.getManager(DataParserManager.class, project).initDefault();
            return null;
        }, (String)project);
    }
}

