/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.rest.service.NUserGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class CaseInsensitiveUserGroupService
extends NUserGroupService {
    public static final Logger logger = LoggerFactory.getLogger(CaseInsensitiveUserGroupService.class);

    @Override
    public Set<String> listUserGroups(String username) {
        try {
            UserDetails user = this.userService.loadUserByUsername(username);
            return user.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        }
        catch (Exception e) {
            logger.warn("Cat not load user by username {}", (Object)username, (Object)e);
            return Sets.newHashSet();
        }
    }
}

