/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.metadata.epoch.EpochManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="epochService")
public class EpochService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(EpochService.class);
    @Autowired(required=false)
    public AclEvaluate aclEvaluate;

    public void updateEpoch(List<String> projects, boolean force, boolean client) {
        if (!client) {
            this.aclEvaluate.checkIsGlobalAdmin();
        }
        EpochManager epochMgr = EpochManager.getInstance();
        NProjectManager projectMgr = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        if (projects.isEmpty()) {
            projects.add("_global");
            projects.addAll(projectMgr.listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList()));
        }
        ResourceGroupManager rgManager = ResourceGroupManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        for (String project : projects) {
            if (!rgManager.instanceHasPermissionToOwnEpochTarget(project, AddressUtil.getLocalInstance())) continue;
            logger.info("update epoch {}", (Object)project);
            epochMgr.updateEpochWithNotifier(project, force);
        }
    }

    public void updateAllEpochs(boolean force, boolean client) {
        if (!client) {
            this.aclEvaluate.checkIsGlobalAdmin();
        }
        NProjectManager projectMgr = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        List<String> prjs = projectMgr.listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        prjs.add("_global");
        this.updateEpoch(prjs, force, client);
    }

    public boolean isMaintenanceMode() {
        EpochManager epochMgr = EpochManager.getInstance();
        return epochMgr.isMaintenanceMode();
    }
}

