/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.usergroup.UserGroup;
import org.apache.kylin.rest.response.UserGroupResponseKI;
import org.apache.kylin.rest.security.AdminUserSyncEventNotifier;
import org.apache.kylin.rest.service.LdapUserService;
import org.apache.kylin.rest.service.NUserGroupService;
import org.apache.kylin.tool.util.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.support.SingleContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

public class LdapUserGroupService
extends NUserGroupService {
    private static final Logger logger = LoggerFactory.getLogger(LdapUserGroupService.class);
    private static final String LDAP_GROUPS = "ldap_groups";
    private static final String SKIPPED_LDAP = "skipped-ldap";
    private static final Cache<String, Set<String>> ldapGroupsCache = CacheBuilder.newBuilder().maximumSize((long)KylinConfig.getInstanceFromEnv().getServerUserCacheMaxEntries()).expireAfterWrite((long)KylinConfig.getInstanceFromEnv().getServerUserCacheExpireSeconds(), TimeUnit.SECONDS).build();
    private static final Cache<String, List<ManagedUser>> ldapGroupsMembersCache = CacheBuilder.newBuilder().maximumSize((long)KylinConfig.getInstanceFromEnv().getServerUserCacheMaxEntries()).expireAfterWrite((long)KylinConfig.getInstanceFromEnv().getServerUserCacheExpireSeconds(), TimeUnit.SECONDS).build();
    private static final Cache<String, List<String>> ldapGroupsAndMembersCache = CacheBuilder.newBuilder().maximumSize((long)KylinConfig.getInstanceFromEnv().getServerUserCacheMaxEntries()).expireAfterWrite((long)KylinConfig.getInstanceFromEnv().getServerUserCacheExpireSeconds(), TimeUnit.SECONDS).build();
    @Autowired
    @Qualifier(value="ldapTemplate")
    private SpringSecurityLdapTemplate ldapTemplate;
    @Autowired
    @Qualifier(value="userService")
    private LdapUserService ldapUserService;
    @Autowired
    private SearchControls searchControls;

    @Override
    public void addGroup(String name) {
        throw new UnsupportedOperationException(MsgPicker.getMsg().getGroupEditNotAllowed());
    }

    @Override
    public void deleteGroup(String name) {
        throw new UnsupportedOperationException(MsgPicker.getMsg().getGroupEditNotAllowed());
    }

    @Override
    public void modifyGroupUsers(String groupName, List<String> users) {
        throw new UnsupportedOperationException(MsgPicker.getMsg().getGroupEditNotAllowed());
    }

    @Override
    public List<String> getAllUserGroups() {
        Set allGroups = (Set)ldapGroupsCache.getIfPresent((Object)LDAP_GROUPS);
        if (allGroups == null || allGroups.isEmpty()) {
            logger.info("Can not get groups from cache, ask ldap instead.");
            String ldapGroupSearchBase = KylinConfig.getInstanceFromEnv().getLDAPGroupSearchBase();
            String ldapGroupSearchFilter = KapConfig.getInstanceFromEnv().getLDAPGroupSearchFilter();
            String ldapGroupIDAttr = KapConfig.getInstanceFromEnv().getLDAPGroupIDAttr();
            Integer maxPageSize = KapConfig.getInstanceFromEnv().getLDAPMaxPageSize();
            logger.info("ldap group search config, base: {}, filter: {}, identifier attribute: {}, member search filter: {}, member identifier: {}, maxPageSize: {}", new Object[]{ldapGroupSearchBase, ldapGroupSearchFilter, ldapGroupIDAttr, KapConfig.getInstanceFromEnv().getLDAPGroupMemberSearchFilter(), KapConfig.getInstanceFromEnv().getLDAPGroupMemberAttr(), maxPageSize});
            PagedResultsDirContextProcessor processor = new PagedResultsDirContextProcessor(maxPageSize.intValue());
            ContextMapper contextMapper = ctx -> {
                DirContextAdapter adapter = (DirContextAdapter)ctx;
                return adapter.getAttributes().get(ldapGroupIDAttr).get().toString();
            };
            allGroups = (Set)SingleContextSource.doWithSingleContext((ContextSource)this.ldapTemplate.getContextSource(), operations -> {
                HashSet set = new HashSet();
                do {
                    set.addAll(operations.search(ldapGroupSearchBase, ldapGroupSearchFilter, this.searchControls, contextMapper, (DirContextProcessor)processor));
                } while (processor.hasMore());
                return set;
            });
            ldapGroupsCache.put((Object)LDAP_GROUPS, (Object)allGroups);
        }
        logger.info("Get all groups size: {}", (Object)allGroups.size());
        return Collections.unmodifiableList(Lists.newArrayList((Iterable)allGroups));
    }

    @Override
    public List<UserGroup> listUserGroups() {
        return this.getUserGroupSpecialUuid();
    }

    @Override
    public Map<String, List<String>> getUserAndUserGroup() {
        HashMap result = Maps.newHashMap();
        for (String group : this.getAllUserGroups()) {
            result.put(group, this.getGroupUsernameList(group));
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public List<UserGroup> getUserGroupsFilterByGroupName(String userGroupName) {
        this.aclEvaluate.checkIsGlobalAdmin();
        return this.listUserGroups().stream().filter(userGroup -> StringUtils.isEmpty((CharSequence)userGroupName) || userGroup.getGroupName().toUpperCase(Locale.ROOT).contains(userGroupName.toUpperCase(Locale.ROOT))).collect(Collectors.toList());
    }

    @Override
    public List<ManagedUser> getGroupMembersByName(String name) {
        ArrayList<ManagedUser> members = (ArrayList<ManagedUser>)ldapGroupsMembersCache.getIfPresent((Object)name);
        if (null == members) {
            logger.info("Can not get the group {}'s all members from cache, ask ldap instead.", (Object)name);
            members = new ArrayList<ManagedUser>();
            List<String> usernameList = this.getGroupUsernameList(name);
            for (String username : usernameList) {
                boolean userExists = this.userService.userExists(username);
                if (!userExists) continue;
                ManagedUser ldapUser = new ManagedUser(username, SKIPPED_LDAP, Boolean.valueOf(false), (Collection)Lists.newArrayList());
                this.ldapUserService.completeUserInfoInternal(ldapUser);
                members.add(ldapUser);
            }
            ldapGroupsMembersCache.put((Object)name, Collections.unmodifiableList(members));
        }
        return members;
    }

    @Override
    public List<UserGroupResponseKI> getUserGroupResponse(List<UserGroup> userGroups) throws IOException {
        ArrayList<UserGroupResponseKI> result = new ArrayList<UserGroupResponseKI>();
        for (UserGroup group : userGroups) {
            TreeSet<String> groupMembers = new TreeSet<String>(this.getGroupUsernameList(group.getGroupName()));
            result.add(new UserGroupResponseKI(group.getUuid(), group.getGroupName(), groupMembers));
        }
        return result;
    }

    private List<String> getGroupUsernameList(String name) {
        ArrayList users = (ArrayList)ldapGroupsAndMembersCache.getIfPresent((Object)name);
        if (null == users) {
            users = new ArrayList();
            Set ldapUserDNs = LdapUtils.getAllGroupMembers(this.ldapTemplate, name).stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            Map<String, String> dnMapperMap = this.ldapUserService.getDnMapperMap();
            for (String u : ldapUserDNs) {
                Optional.ofNullable(dnMapperMap.get(u)).ifPresent(users::add);
            }
            List<String> userList = Collections.unmodifiableList(users);
            this.syncAdminUser(name, userList);
            ldapGroupsAndMembersCache.put((Object)name, userList);
        }
        return users;
    }

    private void syncAdminUser(String groupName, List<String> userList) {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        if (conf.getLDAPAdminRole().equalsIgnoreCase(groupName)) {
            EventBusFactory.getInstance().postSync((Object)new AdminUserSyncEventNotifier(userList, true));
        }
    }

    @Override
    public String getGroupNameByUuid(String uuid) {
        return uuid;
    }

    @Override
    public String getUuidByGroupName(String groupName) {
        return groupName;
    }

    @Override
    public boolean exists(String name) {
        return this.getAllUserGroups().contains(name);
    }

    @Override
    public Set<String> listUserGroups(String username) {
        return this.getAllUserGroups().stream().filter(group -> this.getGroupMembersByName((String)group).stream().anyMatch(user -> StringUtils.equalsIgnoreCase((CharSequence)username, (CharSequence)user.getUsername()))).collect(Collectors.toSet());
    }
}

