/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.CaseInsensitiveStringMap;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.service.LdapUserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.tool.util.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.userdetails.LdapUserDetailsService;
import org.springframework.util.CollectionUtils;

public class LdapUserService
implements UserService {
    private static final Logger logger = LoggerFactory.getLogger(LdapUserService.class);
    private static final String LDAP_USERS = "ldap_users";
    private static final String SKIPPED_LDAP = "skipped-ldap";
    private static final String LDAP_VALID_DN_MAP_KEY = "ldap_valid_dn_map_key";
    private static final AtomicBoolean LOAD_TASK_STATUS = new AtomicBoolean(Boolean.FALSE);
    private static final ThreadPoolExecutor LOAD_TASK_POOL = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), Executors.defaultThreadFactory(), (r, e) -> {});
    private static final Cache<String, Map<String, ManagedUser>> ldapUsersCache = CacheBuilder.newBuilder().maximumSize((long)KylinConfig.getInstanceFromEnv().getServerUserCacheMaxEntries()).expireAfterWrite((long)KylinConfig.getInstanceFromEnv().getServerUserCacheExpireSeconds(), TimeUnit.SECONDS).build();
    private static final Cache<String, Map<String, String>> LDAP_VALID_DN_MAP_CACHE = CacheBuilder.newBuilder().maximumSize((long)KylinConfig.getInstanceFromEnv().getServerUserCacheMaxEntries()).expireAfterWrite((long)KylinConfig.getInstanceFromEnv().getServerUserCacheExpireSeconds(), TimeUnit.SECONDS).build();
    @Autowired
    @Qualifier(value="ldapTemplate")
    private SpringSecurityLdapTemplate ldapTemplate;
    @Autowired
    @Qualifier(value="ldapUserDetailsService")
    private LdapUserDetailsService ldapUserDetailsService;
    @Autowired
    @Qualifier(value="userGroupService")
    private LdapUserGroupService userGroupService;
    @Autowired
    private SearchControls searchControls;

    public void createUser(UserDetails userDetails) {
        throw new UnsupportedOperationException(MsgPicker.getMsg().getUserEditNotAllowed());
    }

    public void updateUser(UserDetails userDetails) {
        throw new UnsupportedOperationException(MsgPicker.getMsg().getUserEditNotAllowed());
    }

    public void deleteUser(String s) {
        throw new UnsupportedOperationException(MsgPicker.getMsg().getUserEditNotAllowed());
    }

    public void changePassword(String s, String s1) {
        throw new UnsupportedOperationException(MsgPicker.getMsg().getUserEditNotAllowed());
    }

    public boolean userExists(String username) {
        Map<String, ManagedUser> managedUserMap = this.getLDAPUsersCache();
        if (Objects.nonNull(managedUserMap)) {
            return managedUserMap.containsKey(username);
        }
        UserDetails ldapUser = this.ldapUserDetailsService.loadUserByUsername(username);
        this.asyncLoadCacheData();
        return Objects.nonNull(ldapUser);
    }

    public UserDetails loadUserByUsername(String username) {
        Map<String, ManagedUser> managedUserMap = this.getLDAPUsersCache();
        if (Objects.nonNull(managedUserMap)) {
            for (Map.Entry<String, ManagedUser> entry : managedUserMap.entrySet()) {
                if (!StringUtils.equalsIgnoreCase((String)username, (String)entry.getKey())) continue;
                return (UserDetails)entry.getValue();
            }
            throw new UsernameNotFoundException(String.format(Locale.ROOT, MsgPicker.getMsg().getUserNotFound(), username));
        }
        UserDetails ldapUser = this.ldapUserDetailsService.loadUserByUsername(username);
        this.asyncLoadCacheData();
        if (Objects.isNull(ldapUser)) {
            String msg = String.format(Locale.ROOT, MsgPicker.getMsg().getUserNotFound(), username);
            throw new UsernameNotFoundException(msg);
        }
        return new ManagedUser(ldapUser.getUsername(), SKIPPED_LDAP, Boolean.valueOf(false), ldapUser.getAuthorities());
    }

    @Override
    public List<ManagedUser> listUsers() {
        Map allUsers = (Map)ldapUsersCache.getIfPresent((Object)LDAP_USERS);
        if (CollectionUtils.isEmpty((Map)allUsers)) {
            logger.info("Failed to read users from cache, reload from ldap server.");
            allUsers = new CaseInsensitiveStringMap();
            Set<String> ldapUsers = this.getAllUsers();
            for (String user : ldapUsers) {
                ManagedUser ldapUser = new ManagedUser(user, SKIPPED_LDAP, Boolean.valueOf(false), (Collection)Lists.newArrayList());
                try {
                    this.completeUserInfoInternal(ldapUser);
                    allUsers.put(user, ldapUser);
                }
                catch (IncorrectResultSizeDataAccessException e) {
                    logger.warn("Complete user {} info exception", (Object)ldapUser.getUsername(), (Object)e);
                }
            }
            ldapUsersCache.put((Object)LDAP_USERS, Preconditions.checkNotNull((Object)allUsers, (Object)"Failed to load users from ldap server, something went wrong."));
            logger.info("Get all users size: {}", (Object)allUsers.size());
        }
        return Collections.unmodifiableList(new ArrayList(allUsers.values()));
    }

    @Override
    public List<String> listAdminUsers() throws IOException {
        ArrayList<String> adminUsers = new ArrayList<String>();
        for (ManagedUser user : this.userGroupService.getGroupMembersByName(KylinConfig.getInstanceFromEnv().getLDAPAdminRole())) {
            adminUsers.add(user.getUsername());
        }
        return Collections.unmodifiableList(adminUsers);
    }

    @Override
    public void completeUserInfo(ManagedUser user) {
    }

    public void completeUserInfoInternal(ManagedUser user) {
        Map<String, List<String>> userAndUserGroup = this.userGroupService.getUserAndUserGroup();
        for (Map.Entry<String, List<String>> entry : userAndUserGroup.entrySet()) {
            String groupName = entry.getKey();
            HashSet userSet = new HashSet(entry.getValue());
            if (!userSet.contains(user.getUsername())) continue;
            if (groupName.equals(KylinConfig.getInstanceFromEnv().getLDAPAdminRole())) {
                user.addAuthorities(groupName);
                user.addAuthorities("ROLE_ADMIN");
                continue;
            }
            user.addAuthorities(groupName);
        }
    }

    public void onUserAuthenticated(String username) {
        if (!this.userExists(username)) {
            logger.info("User {} not exists, invalidate cache {}.", (Object)username, (Object)LDAP_USERS);
            ldapUsersCache.invalidate((Object)LDAP_USERS);
        }
    }

    private Set<String> getAllUsers() {
        Map<String, String> userDnMap = LdapUtils.getAllValidUserDnMap(this.ldapTemplate, this.searchControls);
        LDAP_VALID_DN_MAP_CACHE.put((Object)LDAP_VALID_DN_MAP_KEY, (Object)ImmutableMap.copyOf(userDnMap));
        return new HashSet<String>(userDnMap.values());
    }

    public Map<String, String> getDnMapperMap() {
        Map map = (Map)LDAP_VALID_DN_MAP_CACHE.getIfPresent((Object)LDAP_VALID_DN_MAP_KEY);
        if (null == map) {
            map = ImmutableMap.copyOf(LdapUtils.getAllValidUserDnMap(this.ldapTemplate, this.searchControls));
            LDAP_VALID_DN_MAP_CACHE.put((Object)LDAP_VALID_DN_MAP_KEY, (Object)map);
        }
        return map;
    }

    private Map<String, ManagedUser> getLDAPUsersCache() {
        return Optional.ofNullable(ldapUsersCache.getIfPresent((Object)LDAP_USERS)).map(Collections::unmodifiableMap).orElse(null);
    }

    private void asyncLoadCacheData() {
        if (null != this.getLDAPUsersCache() || LOAD_TASK_STATUS.get()) {
            return;
        }
        Runnable runnable = () -> {
            if (null != this.getLDAPUsersCache()) {
                return;
            }
            if (!LOAD_TASK_STATUS.compareAndSet(Boolean.FALSE, Boolean.TRUE)) {
                return;
            }
            try {
                this.listUsers();
            }
            catch (Exception e) {
                logger.error("Failed to refresh cache asynchronously", (Throwable)e);
            }
            finally {
                LOAD_TASK_STATUS.set(Boolean.FALSE);
            }
        };
        try {
            LOAD_TASK_POOL.execute(runnable);
        }
        catch (Exception e) {
            logger.error("load user cache task error", (Throwable)e);
        }
    }
}

