/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeSystem;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.epoch.EpochManager;
import org.apache.kylin.rest.response.MaintenanceModeResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.MaintenanceModeSupporter;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="maintenanceModeService")
public class MaintenanceModeService
extends BasicService
implements MaintenanceModeSupporter {
    @Autowired
    private AclEvaluate aclEvaluate;
    private static final Logger logger = LoggerFactory.getLogger(MaintenanceModeService.class);

    public void setMaintenanceMode(String reason) {
        this.aclEvaluate.checkIsGlobalAdmin();
        EpochManager epochMgr = EpochManager.getInstance();
        if (Boolean.FALSE.equals(epochMgr.setMaintenanceMode(reason))) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeSystem.MAINTENANCE_MODE_ENTER_FAILED, new Object[0]);
        }
        logger.info("System enter maintenance mode.");
    }

    public void unsetMaintenanceMode(String reason) {
        this.aclEvaluate.checkIsGlobalAdmin();
        EpochManager epochMgr = EpochManager.getInstance();
        if (Boolean.FALSE.equals(epochMgr.unsetMaintenanceMode(reason))) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeSystem.MAINTENANCE_MODE_LEAVE_FAILED, new Object[0]);
        }
        logger.info("System leave maintenance mode.");
    }

    public MaintenanceModeResponse getMaintenanceMode() {
        EpochManager epochMgr = EpochManager.getInstance();
        Pair maintenanceModeDetail = epochMgr.getMaintenanceModeDetail();
        return new MaintenanceModeResponse((Boolean)maintenanceModeDetail.getFirst(), (String)maintenanceModeDetail.getSecond());
    }

    @Override
    public boolean isMaintenanceMode() {
        return this.getMaintenanceMode().isMaintenanceMode();
    }
}

