/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.annotation.ThirdPartyDependencies;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.usergroup.UserGroup;
import org.apache.kylin.rest.service.NUserGroupService;

@ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticUserGroupService", "StaticUserService"})})
public abstract class OpenUserGroupService
extends NUserGroupService {
    @Override
    public abstract List<ManagedUser> getGroupMembersByName(String var1);

    @Override
    public abstract List<String> getAllUserGroups();

    @Override
    public List<UserGroup> listUserGroups() {
        return this.getUserGroupSpecialUuid();
    }

    @Override
    public void addGroup(String name) {
        throw new UnsupportedOperationException(String.format(Locale.ROOT, MsgPicker.getMsg().getGroupEditNotAllowedForCustom(), "addGroup"));
    }

    @Override
    public void deleteGroup(String name) {
        throw new UnsupportedOperationException(String.format(Locale.ROOT, MsgPicker.getMsg().getGroupEditNotAllowedForCustom(), "deleteGroup"));
    }

    @Override
    public void modifyGroupUsers(String groupName, List<String> users) {
        throw new UnsupportedOperationException(String.format(Locale.ROOT, MsgPicker.getMsg().getGroupEditNotAllowedForCustom(), "modifyGroupUsers"));
    }

    @Override
    public String getGroupNameByUuid(String uuid) {
        return uuid;
    }

    @Override
    public String getUuidByGroupName(String groupName) {
        return groupName;
    }

    @Override
    public List<UserGroup> getUserGroupsFilterByGroupName(String userGroupName) {
        this.aclEvaluate.checkIsGlobalAdmin();
        return StringUtils.isEmpty((String)userGroupName) ? this.getUserGroupSpecialUuid() : this.getUserGroupSpecialUuid().stream().filter(userGroup -> userGroup.getGroupName().toUpperCase(Locale.ROOT).contains(userGroupName.toUpperCase(Locale.ROOT))).collect(Collectors.toList());
    }

    @Override
    public boolean exists(String name) {
        return this.getAllUserGroups().contains(name);
    }

    @Override
    public Set<String> listUserGroups(String username) {
        return this.getAllUserGroups().stream().filter(group -> this.getGroupMembersByName((String)group).stream().anyMatch(user -> StringUtils.equalsIgnoreCase((String)username, (String)user.getUsername()))).collect(Collectors.toSet());
    }
}

