/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.transaction.MessageSynchronization;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.BufferedLogger;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.helper.MetadataToolHelper;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.NExecutableManager;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.request.BackupRequest;
import org.apache.kylin.rest.request.DiagProgressRequest;
import org.apache.kylin.rest.response.DiagStatusResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.tool.constant.DiagTypeEnum;
import org.apache.kylin.tool.constant.StageEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service(value="systemService")
public class SystemService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(SystemService.class);
    private final MetadataToolHelper helper = new MetadataToolHelper();
    @Autowired
    private AclEvaluate aclEvaluate;
    private static final String MODEL_CONFIG_BLOCK_LIST = "kylin.index.rule-scheduler-data";
    private final Cache<String, DiagInfo> diagMap = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    private final Cache<String, DiagStatusResponse> exceptionMap = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#backupRequest.getProject(), 'ADMINISTRATION')")
    public void backup(BackupRequest backupRequest) throws Exception {
        String project = StringUtils.isNotBlank((String)backupRequest.getProject()) ? backupRequest.getProject() : null;
        String path = StringUtils.isNotBlank((String)backupRequest.getBackupPath()) ? backupRequest.getBackupPath() : null;
        boolean compress = backupRequest.isCompress();
        this.helper.backup(this.getConfig(), project, path, null, compress, false);
    }

    public String dumpLocalDiagPackage(String startTime, String endTime, String jobId, String queryId, String project) {
        DiagTypeEnum diagPackageType;
        String[] arguments;
        File exportFile = KylinConfigBase.getDiagFileName();
        String uuid = exportFile.getName();
        FileUtils.deleteQuietly((File)exportFile);
        exportFile.mkdirs();
        CliCommandExecutor commandExecutor = new CliCommandExecutor();
        BufferedLogger patternedLogger = new BufferedLogger(logger);
        if (StringUtils.isEmpty((String)jobId) && StringUtils.isEmpty((String)queryId)) {
            if (startTime == null && endTime == null) {
                startTime = Long.toString(System.currentTimeMillis() - 259200000L);
                endTime = Long.toString(System.currentTimeMillis());
            }
            arguments = new String[]{"-destDir", exportFile.getAbsolutePath(), "-startTime", startTime, "-endTime", endTime, "-diagId", uuid};
            diagPackageType = DiagTypeEnum.FULL;
        } else if (StringUtils.isEmpty((String)queryId)) {
            String jobOpt = "-job";
            if (StringUtils.endsWithAny((String)jobId, (String[])new String[]{"_build", "_merge"})) {
                jobOpt = "-streamingJob";
            }
            arguments = new String[]{jobOpt, jobId, "-destDir", exportFile.getAbsolutePath(), "-diagId", uuid};
            diagPackageType = DiagTypeEnum.JOB;
        } else {
            arguments = new String[]{"-project", project, "-query", queryId, "-destDir", exportFile.getAbsolutePath(), "-diagId", uuid};
            diagPackageType = DiagTypeEnum.QUERY;
        }
        Future<?> task = this.executorService.submit(() -> {
            try {
                this.exceptionMap.invalidate((Object)uuid);
                String finalCommand = String.format(Locale.ROOT, "%s/bin/diag.sh %s", KylinConfig.getKylinHome(), StringUtils.join((Object[])arguments, (String)" "));
                commandExecutor.execute(finalCommand, (org.apache.kylin.common.util.Logger)patternedLogger, uuid);
                DiagInfo diagInfo = (DiagInfo)this.diagMap.getIfPresent((Object)uuid);
                if (Objects.isNull(diagInfo) || !"DONE".equals(diagInfo.getStage())) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DIAG_FAILED, MsgPicker.getMsg().getDiagFailed());
                }
            }
            catch (Exception ex) {
                this.handleDiagException(uuid, ex);
            }
        });
        this.diagMap.put((Object)uuid, (Object)new DiagInfo(exportFile, task, diagPackageType));
        return uuid;
    }

    public String dumpLocalQueryDiagPackage(String queryId, String project) {
        this.aclEvaluate.checkProjectQueryPermission(project);
        return this.dumpLocalDiagPackage(null, null, null, queryId, project);
    }

    public String dumpLocalDiagPackage(String startTime, String endTime, String jobId, String project) {
        if (StringUtils.isEmpty((String)jobId)) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            if (StringUtils.isEmpty((String)project)) {
                project = this.getProjectByJobId(jobId);
            }
            this.checkDiagPermission(project);
        }
        return this.dumpLocalDiagPackage(startTime, endTime, jobId, null, null);
    }

    private String getProjectByJobId(String jobId) {
        List projects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        for (String project : projects) {
            AbstractExecutable job = NExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getJob(jobId);
            if (job == null) continue;
            return project;
        }
        return null;
    }

    private void handleDiagException(String uuid, @NotNull Exception ex) {
        Throwable cause;
        logger.warn("Diagnostic kit error", (Throwable)ex);
        for (cause = ex; cause != null && cause.getCause() != null; cause = cause.getCause()) {
        }
        DiagStatusResponse response = new DiagStatusResponse();
        if (cause instanceof KylinTimeoutException) {
            response.setStatus("001");
        } else if (cause instanceof IOException || cause instanceof AccessDeniedException) {
            response.setStatus("002");
        } else {
            response.setStatus("999");
        }
        response.setError(cause == null ? ex.getMessage() : cause.getMessage());
        DiagInfo diagInfo = (DiagInfo)this.diagMap.getIfPresent((Object)uuid);
        if (diagInfo != null) {
            response.setDuration(System.currentTimeMillis() - diagInfo.getStartTime());
        }
        this.exceptionMap.put((Object)uuid, (Object)response);
        FileUtils.deleteQuietly((File)(diagInfo == null ? null : diagInfo.getExportFile()));
        this.diagMap.invalidate((Object)uuid);
    }

    public String getDiagPackagePath(String uuid, String project) {
        String zipFilePath;
        File exportFile;
        DiagStatusResponse exception = (DiagStatusResponse)this.exceptionMap.getIfPresent((Object)uuid);
        if (exception != null) {
            throw new RuntimeException(exception.getError());
        }
        DiagInfo diagInfo = (DiagInfo)this.diagMap.getIfPresent((Object)uuid);
        if (diagInfo != null && !"DONE".equals(diagInfo.getStage())) {
            throw new RuntimeException("Diagnostic task is running now , can not download yet");
        }
        File file = exportFile = diagInfo == null ? null : diagInfo.getExportFile();
        if (exportFile == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DIAG_UUID_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidId(), uuid));
        }
        if (DiagTypeEnum.QUERY != diagInfo.getDiagType() || !KylinConfig.getInstanceFromEnv().isAllowedNonAdminGenerateQueryDiagPackage()) {
            this.checkDiagPermission(project);
        }
        if ((zipFilePath = this.findZipFile(exportFile)) == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILE_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getDiagPackageNotAvailable(), exportFile.getAbsoluteFile()));
        }
        return zipFilePath;
    }

    private String findZipFile(File rootDir) {
        if (rootDir == null) {
            return null;
        }
        File[] files = rootDir.listFiles();
        if (files == null) {
            return null;
        }
        for (File subFile : files) {
            if (subFile.isDirectory()) {
                String zipFilePath = this.findZipFile(subFile);
                if (zipFilePath == null) continue;
                return zipFilePath;
            }
            if (!subFile.getName().endsWith(".zip")) continue;
            return subFile.getAbsolutePath();
        }
        return null;
    }

    public EnvelopeResponse<DiagStatusResponse> getExtractorStatus(String uuid, String project) {
        DiagStatusResponse exception = (DiagStatusResponse)this.exceptionMap.getIfPresent((Object)uuid);
        if (exception != null) {
            exception.setUuid(uuid);
            return new EnvelopeResponse("000", (Object)exception, "");
        }
        DiagInfo diagInfo = (DiagInfo)this.diagMap.getIfPresent((Object)uuid);
        if (Objects.isNull(diagInfo)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DIAG_UUID_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidId(), uuid));
        }
        if (DiagTypeEnum.QUERY != diagInfo.getDiagType() || !KylinConfig.getInstanceFromEnv().isAllowedNonAdminGenerateQueryDiagPackage()) {
            this.checkDiagPermission(project);
        }
        DiagStatusResponse response = new DiagStatusResponse();
        response.setUuid(uuid);
        response.setStatus("000");
        response.setStage(diagInfo.getStage());
        response.setProgress(Float.valueOf(diagInfo.getProgress()));
        long endTime = System.currentTimeMillis();
        if (StageEnum.DONE.toString().equals(diagInfo.getStage())) {
            endTime = diagInfo.getUpdateTime();
        }
        response.setDuration(endTime - diagInfo.startTime);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    private void checkDiagPermission(String project) {
        if (StringUtils.isEmpty((String)project)) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectAdminPermission(project);
        }
    }

    public void updateDiagProgress(DiagProgressRequest diagProgressRequest) {
        DiagInfo diagInfo = (DiagInfo)this.diagMap.getIfPresent((Object)diagProgressRequest.getDiagId());
        if (Objects.isNull(diagInfo)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DIAG_UUID_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidId(), diagProgressRequest.getDiagId()));
        }
        diagInfo.setStage(diagProgressRequest.getStage());
        diagInfo.setProgress(diagProgressRequest.getProgress());
        diagInfo.setUpdateTime(diagProgressRequest.getUpdateTime());
    }

    public void stopDiagTask(String uuid) {
        logger.debug("Stop diagnostic package task {}", (Object)uuid);
        DiagInfo diagInfo = (DiagInfo)this.diagMap.getIfPresent((Object)uuid);
        if (diagInfo == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DIAG_UUID_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidId(), uuid));
        }
        if (DiagTypeEnum.QUERY != diagInfo.getDiagType() || !KylinConfig.getInstanceFromEnv().isAllowedNonAdminGenerateQueryDiagPackage()) {
            this.aclEvaluate.checkIsGlobalAdmin();
        }
        EventBusFactory.getInstance().postSync((Object)new CliCommandExecutor.JobKilled(uuid));
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void reloadMetadata() throws IOException {
        MessageSynchronization messageSynchronization = MessageSynchronization.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        messageSynchronization.replayAllMetadata(true);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Map<String, String> getReadOnlyConfig(String projectName, String modelAlias) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (StringUtils.isBlank((String)projectName)) {
            if (StringUtils.isNotBlank((String)modelAlias)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.CONFIG_NONEXIST_MODEL, String.format(Locale.ROOT, MsgPicker.getMsg().getLackProject(), projectName), false);
            }
            result.putAll(this.getConfig().getReadonlyProperties());
        } else if (StringUtils.isBlank((String)modelAlias)) {
            ProjectInstance project = this.getManager(NProjectManager.class).getProject(projectName);
            if (project == null) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.CONFIG_NONEXIST_MODEL, String.format(Locale.ROOT, MsgPicker.getMsg().getNonExistProject(), projectName), false);
            }
            result.putAll(project.getConfig().getReadonlyProperties());
        } else {
            NDataModel model = this.getManager(NDataModelManager.class, projectName).getDataModelDescByAlias(modelAlias);
            if (model == null) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.CONFIG_NONEXIST_MODEL, String.format(Locale.ROOT, MsgPicker.getMsg().getNonExistedModel(), modelAlias), false);
            }
            IndexPlan indexPlan = this.getManager(NIndexPlanManager.class, projectName).getIndexPlan(model.getId());
            if (indexPlan != null) {
                result.putAll(indexPlan.getOverrideProps());
                result.remove(MODEL_CONFIG_BLOCK_LIST);
            }
        }
        return result;
    }

    public static class DiagInfo {
        private final long startTime = System.currentTimeMillis();
        private String stage = StageEnum.PREPARE.toString();
        private float progress = 0.0f;
        private File exportFile;
        private Future task;
        private DiagTypeEnum diagType;
        private long updateTime;

        public DiagInfo(File exportFile, Future task, DiagTypeEnum diagType) {
            this.exportFile = exportFile;
            this.task = task;
            this.diagType = diagType;
        }

        @Generated
        public long getStartTime() {
            return this.startTime;
        }

        @Generated
        public String getStage() {
            return this.stage;
        }

        @Generated
        public float getProgress() {
            return this.progress;
        }

        @Generated
        public File getExportFile() {
            return this.exportFile;
        }

        @Generated
        public Future getTask() {
            return this.task;
        }

        @Generated
        public DiagTypeEnum getDiagType() {
            return this.diagType;
        }

        @Generated
        public long getUpdateTime() {
            return this.updateTime;
        }

        @Generated
        public void setStage(String stage) {
            this.stage = stage;
        }

        @Generated
        public void setProgress(float progress) {
            this.progress = progress;
        }

        @Generated
        public void setExportFile(File exportFile) {
            this.exportFile = exportFile;
        }

        @Generated
        public void setTask(Future task) {
            this.task = task;
        }

        @Generated
        public void setDiagType(DiagTypeEnum diagType) {
            this.diagType = diagType;
        }

        @Generated
        public void setUpdateTime(long updateTime) {
            this.updateTime = updateTime;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiagInfo)) {
                return false;
            }
            DiagInfo other = (DiagInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            String this$stage = this.getStage();
            String other$stage = other.getStage();
            if (this$stage == null ? other$stage != null : !this$stage.equals(other$stage)) {
                return false;
            }
            if (Float.compare(this.getProgress(), other.getProgress()) != 0) {
                return false;
            }
            File this$exportFile = this.getExportFile();
            File other$exportFile = other.getExportFile();
            if (this$exportFile == null ? other$exportFile != null : !((Object)this$exportFile).equals(other$exportFile)) {
                return false;
            }
            Future this$task = this.getTask();
            Future other$task = other.getTask();
            if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
                return false;
            }
            DiagTypeEnum this$diagType = this.getDiagType();
            DiagTypeEnum other$diagType = other.getDiagType();
            if (this$diagType == null ? other$diagType != null : !((Object)((Object)this$diagType)).equals((Object)other$diagType)) {
                return false;
            }
            return this.getUpdateTime() == other.getUpdateTime();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DiagInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            String $stage = this.getStage();
            result = result * 59 + ($stage == null ? 43 : $stage.hashCode());
            result = result * 59 + Float.floatToIntBits(this.getProgress());
            File $exportFile = this.getExportFile();
            result = result * 59 + ($exportFile == null ? 43 : ((Object)$exportFile).hashCode());
            Future $task = this.getTask();
            result = result * 59 + ($task == null ? 43 : $task.hashCode());
            DiagTypeEnum $diagType = this.getDiagType();
            result = result * 59 + ($diagType == null ? 43 : ((Object)((Object)$diagType)).hashCode());
            long $updateTime = this.getUpdateTime();
            result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
            return result;
        }

        @Generated
        public String toString() {
            return "SystemService.DiagInfo(startTime=" + this.getStartTime() + ", stage=" + this.getStage() + ", progress=" + this.getProgress() + ", exportFile=" + this.getExportFile() + ", task=" + this.getTask() + ", diagType=" + (Object)((Object)this.getDiagType()) + ", updateTime=" + this.getUpdateTime() + ")";
        }

        @Generated
        public DiagInfo() {
        }
    }
}

