/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.util.PasswordEncodeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.RequestBody;

public class CreateAdminUserUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateAdminUserUtils.class);
    private static PasswordEncoder passwordEncoder = PasswordEncodeFactory.newUserPasswordEncoder();
    private static final SimpleGrantedAuthority ALL_USERS_AUTH = new SimpleGrantedAuthority("ALL_USERS");
    private static final Pattern bcryptPattern = Pattern.compile("\\A\\$2a?\\$\\d\\d\\$[./0-9A-Za-z]{53}");
    public static final String PROFILE_DEFAULT = "testing";
    private static final String PROFILE_CUSTOM = "custom";

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public static EnvelopeResponse<String> createAdminUser(@RequestBody ManagedUser user, UserService userService, Environment env) {
        CreateAdminUserUtils.checkProfile(env);
        user.setUuid(RandomUtil.randomUUIDStr());
        user.setPassword(CreateAdminUserUtils.pwdEncode(user.getPassword()));
        log.info("Creating user: {}", (Object)user);
        CreateAdminUserUtils.completeAuthorities(user);
        userService.createUser((UserDetails)user);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    public static String pwdEncode(String pwd) {
        if (bcryptPattern.matcher(pwd).matches()) {
            return pwd;
        }
        return passwordEncoder.encode((CharSequence)pwd);
    }

    public static void checkProfile(Environment env) {
        Message msg = MsgPicker.getMsg();
        if (!env.acceptsProfiles(new String[]{PROFILE_DEFAULT, PROFILE_CUSTOM})) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_USER, msg.getUserEditNotAllowed());
        }
    }

    public static void completeAuthorities(ManagedUser managedUser) {
        ArrayList detailRoles = Lists.newArrayList((Iterable)managedUser.getAuthorities());
        if (!detailRoles.contains(ALL_USERS_AUTH)) {
            detailRoles.add(ALL_USERS_AUTH);
        }
        managedUser.setGrantedAuthorities((Collection)detailRoles);
    }

    public static void createAllAdmins(UserService userService, Environment env) throws IOException {
        List<ManagedUser> all = userService.listUsers();
        log.info("All {} users", (Object)all.size());
        if (all.isEmpty() && env.acceptsProfiles(new String[]{PROFILE_DEFAULT})) {
            CreateAdminUserUtils.createAdminUser(new ManagedUser("ADMIN", "KYLIN", Boolean.valueOf(true), new String[]{"ROLE_ADMIN", "ALL_USERS"}), userService, env);
        }
    }
}

