/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.File;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.util.TimestampedRollingFileOutputDir;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JStackDumpTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JStackDumpTask.class);
    private final File outputDir;

    public JStackDumpTask() {
        this.outputDir = new File(KylinConfig.getKylinHome(), "logs");
    }

    public JStackDumpTask(File path) {
        this.outputDir = path;
    }

    @Override
    public void run() {
        log.trace("start dump stack");
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        TimestampedRollingFileOutputDir rollingFileOutputDir = new TimestampedRollingFileOutputDir(this.outputDir, "jstack.timed.log", kylinConfig.getJStackDumpTaskLogsMaxNum());
        try {
            ToolUtil.dumpKylinJStack(rollingFileOutputDir.newOutputFile());
            log.trace("dump jstack successful");
        }
        catch (Exception e) {
            log.error("Error dump jstack info", (Throwable)e);
        }
    }
}

