/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.daemon.checker;

import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.tool.daemon.CheckResult;
import org.apache.kylin.tool.daemon.CheckStateEnum;
import org.apache.kylin.tool.daemon.checker.AbstractHealthChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullGCDurationChecker
extends AbstractHealthChecker {
    private static final Logger logger = LoggerFactory.getLogger(FullGCDurationChecker.class);
    private AtomicLong accumulator = new AtomicLong(0L);
    private FullGCRecord[] ringBuffer;
    private int factor;
    private long guardianCheckInterval;
    private boolean restartEnabled;
    private double ratioThreshold;
    private boolean busyEnabled;
    private double lowWatermark;
    private double highWatermark;

    public FullGCDurationChecker() {
        this.setPriority(10000);
        this.factor = FullGCDurationChecker.getKylinConfig().getGuardianFullGCCheckFactor();
        this.guardianCheckInterval = FullGCDurationChecker.getKylinConfig().getGuardianCheckInterval();
        this.restartEnabled = FullGCDurationChecker.getKylinConfig().isFullGCRatioBeyondRestartEnabled();
        this.ratioThreshold = FullGCDurationChecker.getKylinConfig().getGuardianFullGCRatioThreshold();
        this.busyEnabled = FullGCDurationChecker.getKylinConfig().isDowngradeOnFullGCBusyEnable();
        this.lowWatermark = FullGCDurationChecker.getKylinConfig().getGuardianFullGCLowWatermark();
        this.highWatermark = FullGCDurationChecker.getKylinConfig().getGuardianFullGCHighWatermark();
        this.lowWatermark = Double.min(this.highWatermark, this.lowWatermark);
        this.ringBuffer = new FullGCRecord[this.factor];
    }

    @Override
    CheckResult doCheck() {
        CheckResult result = new CheckResult(CheckStateEnum.NORMAL);
        try {
            double fgcTime = this.getGCTime();
            long now = this.getNowTime();
            double fullGCRatio = 0.0;
            int index = (int)(this.accumulator.get() % (long)this.ringBuffer.length);
            if (null != this.ringBuffer[index]) {
                FullGCRecord oldRecord = this.ringBuffer[index];
                long duration = (now - oldRecord.checkTime) / 1000L;
                fullGCRatio = (fgcTime - oldRecord.fgcTime) / (double)duration * 100.0;
                if (this.restartEnabled && fullGCRatio >= this.ratioThreshold) {
                    result = new CheckResult(CheckStateEnum.RESTART, String.format(Locale.ROOT, "Full gc time duration ratio in %d seconds is more than %.2f%%", (long)this.factor * this.guardianCheckInterval, this.ratioThreshold));
                } else if (this.busyEnabled) {
                    if (fullGCRatio >= this.highWatermark) {
                        result = new CheckResult(CheckStateEnum.QUERY_DOWNGRADE, String.format(Locale.ROOT, "Full gc time duration ratio in %d seconds is more than %.2f%%", (long)this.factor * this.guardianCheckInterval, this.highWatermark));
                    } else if (fullGCRatio < this.lowWatermark) {
                        result = new CheckResult(CheckStateEnum.QUERY_UPGRADE, String.format(Locale.ROOT, "Full gc time duration ratio in %d seconds is less than %.2f%%", (long)this.factor * this.guardianCheckInterval, this.lowWatermark));
                    }
                }
            }
            logger.info("Full gc time duration ratio in {} seconds is {}%, full gc time: {}", new Object[]{(long)this.factor * this.guardianCheckInterval, fullGCRatio, fgcTime});
            this.ringBuffer[index] = new FullGCRecord(now, fgcTime);
            this.accumulator.incrementAndGet();
        }
        catch (Exception e) {
            logger.error("Guardian Process: check full gc time failed!", (Throwable)e);
            result = new CheckResult(CheckStateEnum.WARN, e.getMessage());
        }
        return result;
    }

    @VisibleForTesting
    public long getNowTime() {
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    public double getGCTime() throws ShellException {
        String cmd = "sh " + FullGCDurationChecker.getKylinHome() + "/sbin/guardian-get-fgc-time.sh";
        CliCommandExecutor.CliCmdExecResult result = FullGCDurationChecker.getCommandExecutor().execute(cmd, null);
        return Double.parseDouble(result.getCmd().substring(0, result.getCmd().lastIndexOf(10)));
    }

    private static class FullGCRecord {
        private long checkTime;
        private double fgcTime;

        @Generated
        public long getCheckTime() {
            return this.checkTime;
        }

        @Generated
        public double getFgcTime() {
            return this.fgcTime;
        }

        @Generated
        public void setCheckTime(long checkTime) {
            this.checkTime = checkTime;
        }

        @Generated
        public void setFgcTime(double fgcTime) {
            this.fgcTime = fgcTime;
        }

        @Generated
        public FullGCRecord(long checkTime, double fgcTime) {
            this.checkTime = checkTime;
            this.fgcTime = fgcTime;
        }
    }
}

