/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.daemon.checker;

import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.tool.daemon.CheckResult;
import org.apache.kylin.tool.daemon.CheckStateEnum;
import org.apache.kylin.tool.daemon.checker.AbstractHealthChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KEProcessChecker
extends AbstractHealthChecker {
    private static final Logger logger = LoggerFactory.getLogger(KEProcessChecker.class);

    public KEProcessChecker() {
        this.setPriority(0);
    }

    public String getProcessStatusCmd() {
        return "sh " + KEProcessChecker.getKylinHome() + "/sbin/guardian-get-process-status.sh";
    }

    @Override
    CheckResult doCheck() {
        String cmd = this.getProcessStatusCmd();
        try {
            CliCommandExecutor.CliCmdExecResult result = KEProcessChecker.getCommandExecutor().execute(cmd, null);
            int status = Integer.parseInt(result.getCmd().substring(0, result.getCmd().lastIndexOf(10)));
            switch (status) {
                case 0: {
                    return new CheckResult(CheckStateEnum.NORMAL);
                }
                case 1: {
                    return new CheckResult(CheckStateEnum.SUICIDE, "KE instance is normally stopped");
                }
                case -1: {
                    return new CheckResult(CheckStateEnum.RESTART, "KE Instance is crashed");
                }
            }
            return new CheckResult(CheckStateEnum.WARN, "Unknown ke process status");
        }
        catch (Exception e) {
            logger.error("Check KE process failed, cmd: {}", (Object)cmd, (Object)e);
            return new CheckResult(CheckStateEnum.WARN, "Execute shell guardian-get-process-status.sh failed. " + e.getMessage());
        }
    }
}

