/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.daemon.checker;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Locale;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.util.SecretKeyUtil;
import org.apache.kylin.tool.daemon.CheckResult;
import org.apache.kylin.tool.daemon.CheckStateEnum;
import org.apache.kylin.tool.daemon.checker.AbstractHealthChecker;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KEStatusChecker
extends AbstractHealthChecker {
    public static final String PERMISSION_DENIED = "Check permission failed!";
    private static final Logger logger = LoggerFactory.getLogger(KEStatusChecker.class);
    private int failCount = 0;

    public KEStatusChecker() {
        this.setPriority(100000);
    }

    private byte[] getEncryptedTokenForKAPHealth() throws Exception {
        try {
            if (null == KEStatusChecker.getKgSecretKey()) {
                this.setKgSecretKey(SecretKeyUtil.readKGSecretKeyFromFile());
            }
            if (null == KEStatusChecker.getKePid()) {
                this.setKEPid(ToolUtil.getKylinPid());
            }
            return SecretKeyUtil.generateEncryptedTokenWithPid((SecretKey)KEStatusChecker.getKgSecretKey(), (String)KEStatusChecker.getKePid());
        }
        catch (Exception e) {
            logger.error("Read KG secret key from file failed.");
            throw e;
        }
    }

    @VisibleForTesting
    public EnvelopeResponse<Status> getHealthStatus() throws Exception {
        TypeReference<EnvelopeResponse<Status>> typeRef = new TypeReference<EnvelopeResponse<Status>>(){};
        byte[] encryptedToken = this.getEncryptedTokenForKAPHealth();
        return (EnvelopeResponse)KEStatusChecker.getRestClient().getKapHealthStatus((TypeReference)typeRef, encryptedToken);
    }

    @Override
    CheckResult doCheck() {
        try {
            List<CanceledSlowQueryStatus> slowQueryStatusList;
            EnvelopeResponse<Status> response = this.getHealthStatus();
            if (!"000".equals(response.code)) {
                if (PERMISSION_DENIED.equals(response.getMsg())) {
                    this.setKgSecretKey(null);
                }
                throw new IllegalStateException("Get KE health status failed: " + response.msg);
            }
            Status status = response.getData();
            StringBuilder sb = new StringBuilder();
            boolean sparkRestart = false;
            boolean slowQueryRestart = false;
            SparkStatus sparkStatus = status.getSparkStatus();
            if (KEStatusChecker.getKylinConfig().isSparkFailRestartKeEnabled() && sparkStatus.getFailureTimes() >= KEStatusChecker.getKylinConfig().getGuardianSparkFailThreshold()) {
                sparkRestart = true;
                sb.append(String.format(Locale.ROOT, "Spark restart failure reach %s times, last restart failure time %s. ", KEStatusChecker.getKylinConfig().getGuardianSparkFailThreshold(), sparkStatus.getLastFailureTime()));
            }
            if (CollectionUtils.isNotEmpty(slowQueryStatusList = status.getCanceledSlowQueryStatus())) {
                long failedKillQueries = slowQueryStatusList.stream().filter(slowQueryStatus -> slowQueryStatus.getCanceledTimes() >= KEStatusChecker.getKylinConfig().getGuardianSlowQueryKillFailedThreshold()).count();
                if (KEStatusChecker.getKylinConfig().isSlowQueryKillFailedRestartKeEnabled() && failedKillQueries > 0L) {
                    slowQueryRestart = true;
                    sb.append(String.format(Locale.ROOT, "Have slowQuery be canceled reach %s times. ", KEStatusChecker.getKylinConfig().getGuardianSparkFailThreshold()));
                }
            }
            if (sparkRestart || slowQueryRestart) {
                return new CheckResult(CheckStateEnum.RESTART, sb.toString());
            }
            this.failCount = 0;
            return new CheckResult(CheckStateEnum.NORMAL);
        }
        catch (Exception e) {
            logger.info("Check KE status failed! ", (Throwable)e);
            if (++this.failCount >= KEStatusChecker.getKylinConfig().getGuardianApiFailThreshold()) {
                return new CheckResult(CheckStateEnum.RESTART, String.format(Locale.ROOT, "Instance is in inaccessible status, API failed count reach %d", this.failCount));
            }
            return new CheckResult(CheckStateEnum.WARN, e.getMessage());
        }
    }

    public static class CanceledSlowQueryStatus {
        @JsonProperty(value="query_id")
        private String queryId;
        @JsonProperty(value="canceled_times")
        private int canceledTimes;
        @JsonProperty(value="last_canceled_time")
        private long lastCanceledTime;
        @JsonProperty(value="duration_time")
        private float queryDurationTime;

        @Generated
        public String getQueryId() {
            return this.queryId;
        }

        @Generated
        public int getCanceledTimes() {
            return this.canceledTimes;
        }

        @Generated
        public long getLastCanceledTime() {
            return this.lastCanceledTime;
        }

        @Generated
        public float getQueryDurationTime() {
            return this.queryDurationTime;
        }

        @Generated
        public void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Generated
        public void setCanceledTimes(int canceledTimes) {
            this.canceledTimes = canceledTimes;
        }

        @Generated
        public void setLastCanceledTime(long lastCanceledTime) {
            this.lastCanceledTime = lastCanceledTime;
        }

        @Generated
        public void setQueryDurationTime(float queryDurationTime) {
            this.queryDurationTime = queryDurationTime;
        }

        @Generated
        public CanceledSlowQueryStatus(String queryId, int canceledTimes, long lastCanceledTime, float queryDurationTime) {
            this.queryId = queryId;
            this.canceledTimes = canceledTimes;
            this.lastCanceledTime = lastCanceledTime;
            this.queryDurationTime = queryDurationTime;
        }

        @Generated
        public CanceledSlowQueryStatus() {
        }
    }

    public static class SparkStatus {
        @JsonProperty(value="restart_failure_times")
        private int failureTimes;
        @JsonProperty(value="last_restart_failure_time")
        private long lastFailureTime;

        @Generated
        public int getFailureTimes() {
            return this.failureTimes;
        }

        @Generated
        public long getLastFailureTime() {
            return this.lastFailureTime;
        }

        @Generated
        public void setFailureTimes(int failureTimes) {
            this.failureTimes = failureTimes;
        }

        @Generated
        public void setLastFailureTime(long lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
        }

        @Generated
        public SparkStatus(int failureTimes, long lastFailureTime) {
            this.failureTimes = failureTimes;
            this.lastFailureTime = lastFailureTime;
        }

        @Generated
        public SparkStatus() {
        }
    }

    public static class Status {
        @JsonProperty(value="spark_status")
        private SparkStatus sparkStatus;
        @JsonProperty(value="slow_queries_status")
        private List<CanceledSlowQueryStatus> canceledSlowQueryStatus;

        @Generated
        public SparkStatus getSparkStatus() {
            return this.sparkStatus;
        }

        @Generated
        public List<CanceledSlowQueryStatus> getCanceledSlowQueryStatus() {
            return this.canceledSlowQueryStatus;
        }

        @Generated
        public void setSparkStatus(SparkStatus sparkStatus) {
            this.sparkStatus = sparkStatus;
        }

        @Generated
        public void setCanceledSlowQueryStatus(List<CanceledSlowQueryStatus> canceledSlowQueryStatus) {
            this.canceledSlowQueryStatus = canceledSlowQueryStatus;
        }

        @Generated
        public Status(SparkStatus sparkStatus, List<CanceledSlowQueryStatus> canceledSlowQueryStatus) {
            this.sparkStatus = sparkStatus;
            this.canceledSlowQueryStatus = canceledSlowQueryStatus;
        }

        @Generated
        public Status() {
        }
    }

    public static class EnvelopeResponse<T> {
        protected String code;
        protected T data;
        protected String msg;

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public T getData() {
            return this.data;
        }

        @Generated
        public String getMsg() {
            return this.msg;
        }

        @Generated
        public void setCode(String code) {
            this.code = code;
        }

        @Generated
        public void setData(T data) {
            this.data = data;
        }

        @Generated
        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Generated
        public EnvelopeResponse(String code, T data, String msg) {
            this.code = code;
            this.data = data;
            this.msg = msg;
        }

        @Generated
        public EnvelopeResponse() {
        }
    }
}

