/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.NExecutableManager;
import org.apache.kylin.tool.garbage.MetadataCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableCleaner
extends MetadataCleaner {
    private static final Logger logger = LoggerFactory.getLogger(ExecutableCleaner.class);

    public ExecutableCleaner(String project) {
        super(project);
    }

    @Override
    public void cleanup() {
        logger.info("Start to clean executable in project {}", (Object)this.project);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        long expirationTime = config.getExecutableSurvivalTimeThreshold();
        NExecutableManager executableManager = NExecutableManager.getInstance((KylinConfig)config, (String)this.project);
        List executables = executableManager.getAllExecutables();
        List filteredExecutables = executables.stream().filter(job -> {
            if (System.currentTimeMillis() - job.getCreateTime() < expirationTime) {
                return false;
            }
            ExecutableState state = job.getStatus();
            return state.isFinalState();
        }).collect(Collectors.toList());
        for (AbstractExecutable executable : filteredExecutables) {
            executableManager.deleteJob(executable.getId());
        }
        logger.info("Clean executable in project {} finished", (Object)this.project);
    }
}

