/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.util.Arrays;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.scheduler.SourceUsageUpdateNotifier;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.garbage.ExecutableCleaner;
import org.apache.kylin.tool.garbage.IndexCleaner;
import org.apache.kylin.tool.garbage.MetadataCleaner;
import org.apache.kylin.tool.garbage.SnapshotCleaner;

public class GarbageCleaner {
    private GarbageCleaner() {
    }

    public static void cleanMetadata(String project) {
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project);
        if (projectInstance == null) {
            return;
        }
        List<MetadataCleaner> cleaners = GarbageCleaner.initCleaners(project);
        cleaners.forEach(MetadataCleaner::prepare);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            cleaners.forEach(MetadataCleaner::cleanup);
            return 0;
        }, (String)project);
        EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new SourceUsageUpdateNotifier());
        MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_CLEAN, (MetricsCategory)MetricsCategory.PROJECT, (String)project);
    }

    private static List<MetadataCleaner> initCleaners(String project) {
        return Arrays.asList(new SnapshotCleaner(project), new IndexCleaner(project), new ExecutableCleaner(project));
    }
}

