/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.optimization.IndexOptimizerFactory;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.recommendation.ref.OptRecManagerV2;
import org.apache.kylin.metadata.recommendation.ref.OptRecV2;
import org.apache.kylin.tool.garbage.MetadataCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class IndexCleaner
extends MetadataCleaner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexCleaner.class);
    List<String> needUpdateModels = Lists.newArrayList();

    public IndexCleaner(String project) {
        super(project);
    }

    @Override
    public void prepare() {
        log.info("Start to clean index in project {}", (Object)this.project);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)config, (String)this.project);
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)config).getProject(this.project);
        if (projectInstance.isExpertMode()) {
            log.info("not semiautomode, can't run index clean");
            return;
        }
        OptRecManagerV2 recManagerV2 = OptRecManagerV2.getInstance((String)this.project);
        for (NDataModel model : dataflowManager.listUnderliningDataModels()) {
            boolean hasNewRecItem;
            NDataflow dataflow = dataflowManager.getDataflow(model.getId()).copy();
            Map garbageLayouts = IndexOptimizerFactory.getOptimizer((NDataflow)dataflow, (boolean)true).getGarbageLayoutMap(dataflow);
            if (MapUtils.isEmpty((Map)garbageLayouts) || !(hasNewRecItem = recManagerV2.genRecItemsFromIndexOptimizer(this.project, model.getUuid(), garbageLayouts))) continue;
            this.needUpdateModels.add(model.getId());
        }
        log.info("Clean index in project {} finished", (Object)this.project);
    }

    @Override
    public void cleanup() {
        if (this.needUpdateModels.isEmpty()) {
            return;
        }
        NDataModelManager mgr = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        this.needUpdateModels.forEach(modelId -> {
            NDataModel dataModel = mgr.getDataModelDesc(modelId);
            if (dataModel != null && !dataModel.isBroken()) {
                OptRecV2 optRecV2 = OptRecManagerV2.getInstance((String)this.project).loadOptRecV2(modelId);
                int newSize = optRecV2.getAdditionalLayoutRefs().size() + optRecV2.getRemovalLayoutRefs().size();
                if (dataModel.getRecommendationsCount() != newSize) {
                    mgr.updateDataModel(modelId, copyForWrite -> copyForWrite.setRecommendationsCount(newSize));
                }
            }
        });
    }
}

