/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.sourceusage.SourceUsageManager;
import org.apache.kylin.metadata.sourceusage.SourceUsageRecord;

public class SourceUsageCleaner {
    public void cleanup() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        long expirationTime = config.getSourceUsageSurvivalTimeThreshold();
        SourceUsageManager sourceUsageManager = SourceUsageManager.getInstance((KylinConfig)config);
        List allRecords = sourceUsageManager.getAllRecordsWithoutInit();
        int totalSize = allRecords.size();
        if (totalSize <= 1) {
            return;
        }
        List collect = allRecords.stream().filter(sourceUsageRecord -> System.currentTimeMillis() - sourceUsageRecord.getCreateTime() >= expirationTime).sorted(Comparator.comparingLong(RootPersistentEntity::getCreateTime)).collect(Collectors.toList());
        if (collect.size() == totalSize) {
            collect.remove(totalSize - 1);
        }
        for (SourceUsageRecord record : collect) {
            sourceUsageManager.delSourceUsage(record.resourceName());
        }
    }
}

