/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.kyligence.kap.guava20.shaded.common.io.ByteSource;
import io.kyligence.kap.guava20.shaded.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.TrashRecord;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.NExecutableManager;
import org.apache.kylin.metadata.cube.model.LayoutPartition;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegDetails;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.util.ProjectTemporaryTableCleanerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCleaner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageCleaner.class);
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_RESET = "\u001b[0m";
    private final boolean cleanup;
    private final boolean timeMachineEnabled;
    private final Collection<String> projectNames;
    private final KylinConfig kylinConfig;
    private static final RateLimiter rateLimiter = RateLimiter.create((double)2.147483647E9);
    private final Map<String, String> trashRecord;
    private final ResourceStore resourceStore;
    private Set<StorageItem> outdatedItems = Sets.newHashSet();
    private Set<StorageItem> allFileSystems = Sets.newHashSet();

    public StorageCleaner() throws Exception {
        this(true);
    }

    public StorageCleaner(boolean cleanup) throws Exception {
        this(cleanup, Collections.emptyList());
    }

    public StorageCleaner(boolean cleanup, Collection<String> projects) throws Exception {
        this.cleanup = cleanup;
        this.projectNames = projects;
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.timeMachineEnabled = this.kylinConfig.getTimeMachineEnabled();
        this.resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        RawResource trashRecordResource = this.resourceStore.getResource("/_global/trash_record");
        this.trashRecord = trashRecordResource == null ? Maps.newHashMap() : ((TrashRecord)JsonUtil.readValue((byte[])trashRecordResource.getByteSource().read(), TrashRecord.class)).getTrashRecord();
    }

    public StorageCleaner(boolean cleanup, Collection<String> projects, double requestFSRate, int tRetryTimes) throws Exception {
        this(cleanup, projects);
        if (requestFSRate > 0.0) {
            rateLimiter.setRate(requestFSRate);
        }
        if (tRetryTimes > 0) {
            FileSystemDecorator.retryTimes = tRetryTimes;
        }
    }

    public void execute() throws Exception {
        long start = System.currentTimeMillis();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        long startTime = System.currentTimeMillis();
        List projects = NProjectManager.getInstance((KylinConfig)config).listAllProjects().stream().filter(projectInstance -> this.projectNames.isEmpty() || this.projectNames.contains(projectInstance.getName())).collect(Collectors.toList());
        projects.stream().map(project -> NDataflowManager.getInstance((KylinConfig)config, (String)project.getName()).listAllDataflows()).flatMap(Collection::stream).map(dataflow -> KapConfig.wrap((KylinConfig)dataflow.getConfig())).map(KapConfig::getMetadataWorkingDirectory).forEach(hdfsWorkingDir -> {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            this.allFileSystems.add(new StorageItem(FileSystemDecorator.getInstance(fs), (String)hdfsWorkingDir));
        });
        this.allFileSystems.add(new StorageItem(FileSystemDecorator.getInstance(HadoopUtil.getWorkingFileSystem()), config.getHdfsWorkingDirectory()));
        if (this.kylinConfig.isBuildFilesSeparationEnabled()) {
            this.allFileSystems.add(new StorageItem(FileSystemDecorator.getInstance(HadoopUtil.getWritingClusterFileSystem()), config.getWritingClusterWorkingDir("")));
        }
        log.info("all file systems are {}", this.allFileSystems);
        for (StorageItem allFileSystem : this.allFileSystems) {
            log.debug("start to collect HDFS from {}", (Object)allFileSystem.getPath());
            this.collectFromHDFS(allFileSystem);
            log.debug("folder {} is collected\uff0cdetailed -> {}", (Object)allFileSystem.getPath(), this.allFileSystems);
        }
        UnitOfWork.doInTransactionWithRetry(() -> {
            this.collectDeletedProject();
            for (ProjectInstance project : projects) {
                this.collect(project.getName());
            }
            return null;
        }, (String)"_global");
        long configSurvivalTimeThreshold = this.timeMachineEnabled ? this.kylinConfig.getStorageResourceSurvivalTimeThreshold().longValue() : config.getCuboidLayoutSurvivalTimeThreshold();
        long protectionTime = startTime - configSurvivalTimeThreshold;
        for (StorageItem item : this.allFileSystems) {
            for (FileTreeNode node : item.getAllNodes()) {
                Path path = new Path(item.getPath(), node.getRelativePath());
                if (this.timeMachineEnabled && this.trashRecord.get(path.toString()) == null) {
                    this.trashRecord.put(path.toString(), String.valueOf(startTime));
                    continue;
                }
                try {
                    log.debug("start to add item {}", (Object)path);
                    this.addItem(item.getFileSystemDecorator(), path, protectionTime);
                }
                catch (FileNotFoundException e) {
                    log.warn("{} not found", (Object)path);
                }
            }
        }
        boolean allSuccess = this.cleanup();
        this.printConsole(allSuccess, System.currentTimeMillis() - start);
    }

    public void printConsole(boolean success, long duration) {
        System.out.println("\u001b[34mKylin 5.0 garbage report: (cleanup=" + this.cleanup + ")" + ANSI_RESET);
        for (StorageItem item : this.outdatedItems) {
            System.out.println("  Storage File: " + item.getPath());
        }
        String jobName = "Storage GC cleanup job ";
        if (!this.cleanup) {
            System.out.println("\u001b[34mDry run mode, no data is deleted.\u001b[0m");
            jobName = "Storage GC check job ";
        }
        if (!success) {
            System.out.println(ANSI_RED + jobName + "FAILED." + ANSI_RESET);
            System.out.println(ANSI_RED + jobName + "finished in " + duration + " ms." + ANSI_RESET);
        } else {
            System.out.println(ANSI_GREEN + jobName + "SUCCEED." + ANSI_RESET);
            System.out.println(ANSI_GREEN + jobName + "finished in " + duration + " ms." + ANSI_RESET);
        }
    }

    public void collectDeletedProject() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        Set projects = NProjectManager.getInstance((KylinConfig)config).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toSet());
        for (StorageItem item : this.allFileSystems) {
            item.getProjectNodes().removeIf(node -> projects.contains(node.getName()));
            log.info(String.valueOf(item.projectNodes.size()));
        }
    }

    public void collect(String project) {
        log.info("collect garbage for project: {}", (Object)project);
        new ProjectStorageCleaner(project).execute();
        log.info("clean temporary table for project: {}", (Object)project);
        new ProjectTemporaryTableCleaner(project).execute();
    }

    public boolean cleanup() throws Exception {
        boolean success = true;
        if (this.cleanup) {
            Stats stats = new Stats(){

                @Override
                public void heartBeat() {
                    double percent = 100.0 * (double)(this.successItems.size() + this.errorItems.size()) / (double)this.allItems.size();
                    String logInfo = String.format(Locale.ROOT, "Progress: %2.1f%%, %d resource, %d error", percent, this.allItems.size(), this.errorItems.size());
                    System.out.println(logInfo);
                }
            };
            stats.onAllStart(this.outdatedItems);
            for (StorageItem item : this.outdatedItems) {
                log.debug("try to delete {}", (Object)item.getPath());
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                try {
                    stats.onItemStart(item);
                    item.getFileSystemDecorator().delete(new Path(item.getPath()), true);
                    if (this.timeMachineEnabled) {
                        this.trashRecord.remove(item.getPath());
                    }
                    stats.onItemSuccess(item);
                }
                catch (IOException e) {
                    log.error("delete file " + item.getPath() + " failed", (Throwable)e);
                    stats.onItemError(item);
                    success = false;
                }
            }
            if (this.timeMachineEnabled) {
                EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                    ResourceStore threadViewRS = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
                    RawResource raw = this.resourceStore.getResource("/_global/trash_record");
                    long mvcc = raw == null ? -1L : raw.getMvcc();
                    threadViewRS.checkAndPutResource("/_global/trash_record", ByteSource.wrap((byte[])JsonUtil.writeValueAsBytes((Object)new TrashRecord(this.trashRecord))), mvcc);
                    return 0;
                }, (String)"_global", (int)1);
            }
        }
        return success;
    }

    private String getDataflowBaseDir(String project) {
        return project + "/parquet" + "/";
    }

    private String getDataflowDir(String project, String dataflowId) {
        return this.getDataflowBaseDir(project) + dataflowId;
    }

    private String getDfFlatTableDir(String project, String dataFlowId) {
        return project + "/flat_table" + "/" + dataFlowId;
    }

    private void addItem(FileSystemDecorator fs, Path itemPath, long protectionTime) throws IOException {
        FileStatus status = fs.getFileStatus(itemPath);
        if (status.getPath().getName().startsWith(".")) {
            return;
        }
        if (this.timeMachineEnabled && Long.parseLong(this.trashRecord.get(itemPath.toString())) > protectionTime) {
            return;
        }
        if (!this.timeMachineEnabled && status.getModificationTime() > protectionTime) {
            return;
        }
        this.outdatedItems.add(new StorageItem(fs, status.getPath().toString()));
    }

    private String getDictDir(String project) {
        return project + "/dict/global_dict";
    }

    private String getSegmentFlatTableDir(String project, NDataSegment segment) {
        return this.getDfFlatTableDir(project, segment.getDataflow().getId()) + "/" + segment.getId();
    }

    private String getDataLayoutDir(NDataLayout dataLayout) {
        NDataSegDetails segDetails = dataLayout.getSegDetails();
        return this.getDataflowDir(segDetails.getProject(), segDetails.getDataSegment().getDataflow().getId()) + "/" + segDetails.getUuid() + "/" + dataLayout.getLayoutId();
    }

    private String getDataPartitionDir(NDataLayout dataLayout, LayoutPartition dataPartition) {
        return this.getDataLayoutDir(dataLayout) + "/" + dataPartition.getBucketId();
    }

    private void collectFromHDFS(StorageItem item) throws Exception {
        FileStatus[] projectFolders;
        for (FileStatus projectFolder : projectFolders = item.getFileSystemDecorator().listStatus(new Path(item.getPath()), path -> !path.getName().startsWith("_") && (this.projectNames.isEmpty() || this.projectNames.contains(path.getName())))) {
            ArrayList tableSnapshotParents = Lists.newArrayList();
            ProjectFileTreeNode projectNode = new ProjectFileTreeNode(projectFolder.getPath().getName());
            for (Pair pair : Arrays.asList(Pair.newPair((Object)"/job_tmp".substring(1), projectNode.getJobTmps()), Pair.newPair((Object)"/dict/global_dict".substring(1), projectNode.getGlobalDictTables()), Pair.newPair((Object)"/parquet".substring(1), projectNode.getDataflows()), Pair.newPair((Object)"/table_exd".substring(1), projectNode.getTableExds()), Pair.newPair((Object)"/table_snapshot".substring(1), (Object)tableSnapshotParents), Pair.newPair((Object)"/flat_table".substring(1), projectNode.getDfFlatTables()))) {
                FileTreeNode treeNode = new FileTreeNode((String)pair.getFirst(), projectNode);
                try {
                    log.debug("collect files from {}", pair.getFirst());
                    Stream.of(item.getFileSystemDecorator().listStatus(new Path(item.getPath(), treeNode.getRelativePath()))).forEach(x -> ((List)pair.getSecond()).add(new FileTreeNode(x.getPath().getName(), treeNode)));
                }
                catch (FileNotFoundException e) {
                    log.info("folder {} not found", (Object)new Path(item.getPath(), treeNode.getRelativePath()));
                }
            }
            item.getProjectNodes().add(projectNode);
            item.getProjects().put(projectNode.getName(), projectNode);
            for (Pair pair : Arrays.asList(Pair.newPair((Object)tableSnapshotParents, projectNode.getSnapshots()), Pair.newPair(projectNode.getGlobalDictTables(), projectNode.getGlobalDictColumns()), Pair.newPair(projectNode.getDataflows(), projectNode.getSegments()), Pair.newPair(projectNode.getSegments(), projectNode.getLayouts()), Pair.newPair(projectNode.getDfFlatTables(), projectNode.getSegmentFlatTables()))) {
                List slot = (List)pair.getSecond();
                for (FileTreeNode node : (List)pair.getFirst()) {
                    log.debug("collect from {} -> {}", (Object)node.getName(), (Object)node);
                    Stream.of(item.getFileSystemDecorator().listStatus(new Path(item.getPath(), node.getRelativePath()))).forEach(x -> slot.add(new FileTreeNode(x.getPath().getName(), node)));
                }
            }
            projectNode.getBuckets().addAll(this.collectMultiPartitions(item, projectNode.getName(), projectNode.getLayouts()));
        }
    }

    private List<FileTreeNode> collectMultiPartitions(StorageItem item, String project, List<FileTreeNode> layouts) throws IOException {
        NDataflowManager manager = NDataflowManager.getInstance((KylinConfig)this.kylinConfig, (String)project);
        FileSystemDecorator fileSystemDecorator = item.getFileSystemDecorator();
        String itemPath = item.getPath();
        ArrayList result = Lists.newArrayList();
        HashSet cached = Sets.newHashSet();
        for (FileTreeNode node : layouts) {
            String dataflowId = node.getParent().getParent().getName();
            if (cached.contains(dataflowId)) continue;
            NDataflow dataflow = manager.getDataflow(dataflowId);
            if (Objects.nonNull(dataflow) && Objects.nonNull(dataflow.getModel()) && dataflow.getModel().isMultiPartitionModel()) {
                cached.add(dataflowId);
                result.addAll(Stream.of(fileSystemDecorator.listStatus(new Path(itemPath, node.getRelativePath()))).filter(FileStatus::isDirectory).map(x -> new FileTreeNode(x.getPath().getName(), node)).collect(Collectors.toList()));
                continue;
            }
            cached.add(dataflowId);
        }
        return result;
    }

    @Generated
    public Map<String, String> getTrashRecord() {
        return this.trashRecord;
    }

    @Generated
    public Set<StorageItem> getOutdatedItems() {
        return this.outdatedItems;
    }

    public static class Stats {
        public final Set<StorageItem> allItems = Collections.synchronizedSet(new HashSet());
        public final Set<StorageItem> startItem = Collections.synchronizedSet(new HashSet());
        public final Set<StorageItem> successItems = Collections.synchronizedSet(new HashSet());
        public final Set<StorageItem> errorItems = Collections.synchronizedSet(new HashSet());

        private void reset() {
            this.allItems.clear();
            this.startItem.clear();
            this.successItems.clear();
            this.errorItems.clear();
        }

        void onAllStart(Set<StorageItem> outDatedItems) {
            this.reset();
            log.debug("{} items to cleanup", (Object)outDatedItems.size());
            this.allItems.addAll(outDatedItems);
        }

        void onItemStart(StorageItem item) {
            this.heartBeat();
            this.startItem.add(item);
        }

        void onItemError(StorageItem item) {
            this.errorItems.add(item);
        }

        void onItemSuccess(StorageItem item) {
            this.successItems.add(item);
        }

        public void onRetry() {
        }

        public void heartBeat() {
        }

        public boolean hasError() {
            return !this.errorItems.isEmpty();
        }
    }

    public static class ProjectFileTreeNode
    extends FileTreeNode {
        List<FileTreeNode> jobTmps = Lists.newLinkedList();
        List<FileTreeNode> tableExds = Lists.newLinkedList();
        List<FileTreeNode> globalDictTables = Lists.newLinkedList();
        List<FileTreeNode> globalDictColumns = Lists.newLinkedList();
        List<FileTreeNode> snapshotTables = Lists.newLinkedList();
        List<FileTreeNode> snapshots = Lists.newLinkedList();
        List<FileTreeNode> dataflows = Lists.newLinkedList();
        List<FileTreeNode> segments = Lists.newLinkedList();
        List<FileTreeNode> layouts = Lists.newLinkedList();
        List<FileTreeNode> buckets = Lists.newLinkedList();
        List<FileTreeNode> dfFlatTables = Lists.newArrayList();
        List<FileTreeNode> segmentFlatTables = Lists.newArrayList();

        public ProjectFileTreeNode(String name) {
            super(name);
        }

        Collection<List<FileTreeNode>> getAllCandidates() {
            return Arrays.asList(this.jobTmps, this.tableExds, this.globalDictTables, this.globalDictColumns, this.snapshotTables, this.snapshots, this.dataflows, this.segments, this.layouts, this.buckets, this.dfFlatTables, this.segmentFlatTables);
        }

        @Generated
        public List<FileTreeNode> getJobTmps() {
            return this.jobTmps;
        }

        @Generated
        public List<FileTreeNode> getTableExds() {
            return this.tableExds;
        }

        @Generated
        public List<FileTreeNode> getGlobalDictTables() {
            return this.globalDictTables;
        }

        @Generated
        public List<FileTreeNode> getGlobalDictColumns() {
            return this.globalDictColumns;
        }

        @Generated
        public List<FileTreeNode> getSnapshotTables() {
            return this.snapshotTables;
        }

        @Generated
        public List<FileTreeNode> getSnapshots() {
            return this.snapshots;
        }

        @Generated
        public List<FileTreeNode> getDataflows() {
            return this.dataflows;
        }

        @Generated
        public List<FileTreeNode> getSegments() {
            return this.segments;
        }

        @Generated
        public List<FileTreeNode> getLayouts() {
            return this.layouts;
        }

        @Generated
        public List<FileTreeNode> getBuckets() {
            return this.buckets;
        }

        @Generated
        public List<FileTreeNode> getDfFlatTables() {
            return this.dfFlatTables;
        }

        @Generated
        public List<FileTreeNode> getSegmentFlatTables() {
            return this.segmentFlatTables;
        }

        @Generated
        public void setJobTmps(List<FileTreeNode> jobTmps) {
            this.jobTmps = jobTmps;
        }

        @Generated
        public void setTableExds(List<FileTreeNode> tableExds) {
            this.tableExds = tableExds;
        }

        @Generated
        public void setGlobalDictTables(List<FileTreeNode> globalDictTables) {
            this.globalDictTables = globalDictTables;
        }

        @Generated
        public void setGlobalDictColumns(List<FileTreeNode> globalDictColumns) {
            this.globalDictColumns = globalDictColumns;
        }

        @Generated
        public void setSnapshotTables(List<FileTreeNode> snapshotTables) {
            this.snapshotTables = snapshotTables;
        }

        @Generated
        public void setSnapshots(List<FileTreeNode> snapshots) {
            this.snapshots = snapshots;
        }

        @Generated
        public void setDataflows(List<FileTreeNode> dataflows) {
            this.dataflows = dataflows;
        }

        @Generated
        public void setSegments(List<FileTreeNode> segments) {
            this.segments = segments;
        }

        @Generated
        public void setLayouts(List<FileTreeNode> layouts) {
            this.layouts = layouts;
        }

        @Generated
        public void setBuckets(List<FileTreeNode> buckets) {
            this.buckets = buckets;
        }

        @Generated
        public void setDfFlatTables(List<FileTreeNode> dfFlatTables) {
            this.dfFlatTables = dfFlatTables;
        }

        @Generated
        public void setSegmentFlatTables(List<FileTreeNode> segmentFlatTables) {
            this.segmentFlatTables = segmentFlatTables;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectFileTreeNode)) {
                return false;
            }
            ProjectFileTreeNode other = (ProjectFileTreeNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<FileTreeNode> this$jobTmps = this.getJobTmps();
            List<FileTreeNode> other$jobTmps = other.getJobTmps();
            if (this$jobTmps == null ? other$jobTmps != null : !((Object)this$jobTmps).equals(other$jobTmps)) {
                return false;
            }
            List<FileTreeNode> this$tableExds = this.getTableExds();
            List<FileTreeNode> other$tableExds = other.getTableExds();
            if (this$tableExds == null ? other$tableExds != null : !((Object)this$tableExds).equals(other$tableExds)) {
                return false;
            }
            List<FileTreeNode> this$globalDictTables = this.getGlobalDictTables();
            List<FileTreeNode> other$globalDictTables = other.getGlobalDictTables();
            if (this$globalDictTables == null ? other$globalDictTables != null : !((Object)this$globalDictTables).equals(other$globalDictTables)) {
                return false;
            }
            List<FileTreeNode> this$globalDictColumns = this.getGlobalDictColumns();
            List<FileTreeNode> other$globalDictColumns = other.getGlobalDictColumns();
            if (this$globalDictColumns == null ? other$globalDictColumns != null : !((Object)this$globalDictColumns).equals(other$globalDictColumns)) {
                return false;
            }
            List<FileTreeNode> this$snapshotTables = this.getSnapshotTables();
            List<FileTreeNode> other$snapshotTables = other.getSnapshotTables();
            if (this$snapshotTables == null ? other$snapshotTables != null : !((Object)this$snapshotTables).equals(other$snapshotTables)) {
                return false;
            }
            List<FileTreeNode> this$snapshots = this.getSnapshots();
            List<FileTreeNode> other$snapshots = other.getSnapshots();
            if (this$snapshots == null ? other$snapshots != null : !((Object)this$snapshots).equals(other$snapshots)) {
                return false;
            }
            List<FileTreeNode> this$dataflows = this.getDataflows();
            List<FileTreeNode> other$dataflows = other.getDataflows();
            if (this$dataflows == null ? other$dataflows != null : !((Object)this$dataflows).equals(other$dataflows)) {
                return false;
            }
            List<FileTreeNode> this$segments = this.getSegments();
            List<FileTreeNode> other$segments = other.getSegments();
            if (this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments)) {
                return false;
            }
            List<FileTreeNode> this$layouts = this.getLayouts();
            List<FileTreeNode> other$layouts = other.getLayouts();
            if (this$layouts == null ? other$layouts != null : !((Object)this$layouts).equals(other$layouts)) {
                return false;
            }
            List<FileTreeNode> this$buckets = this.getBuckets();
            List<FileTreeNode> other$buckets = other.getBuckets();
            if (this$buckets == null ? other$buckets != null : !((Object)this$buckets).equals(other$buckets)) {
                return false;
            }
            List<FileTreeNode> this$dfFlatTables = this.getDfFlatTables();
            List<FileTreeNode> other$dfFlatTables = other.getDfFlatTables();
            if (this$dfFlatTables == null ? other$dfFlatTables != null : !((Object)this$dfFlatTables).equals(other$dfFlatTables)) {
                return false;
            }
            List<FileTreeNode> this$segmentFlatTables = this.getSegmentFlatTables();
            List<FileTreeNode> other$segmentFlatTables = other.getSegmentFlatTables();
            return !(this$segmentFlatTables == null ? other$segmentFlatTables != null : !((Object)this$segmentFlatTables).equals(other$segmentFlatTables));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProjectFileTreeNode;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<FileTreeNode> $jobTmps = this.getJobTmps();
            result = result * 59 + ($jobTmps == null ? 43 : ((Object)$jobTmps).hashCode());
            List<FileTreeNode> $tableExds = this.getTableExds();
            result = result * 59 + ($tableExds == null ? 43 : ((Object)$tableExds).hashCode());
            List<FileTreeNode> $globalDictTables = this.getGlobalDictTables();
            result = result * 59 + ($globalDictTables == null ? 43 : ((Object)$globalDictTables).hashCode());
            List<FileTreeNode> $globalDictColumns = this.getGlobalDictColumns();
            result = result * 59 + ($globalDictColumns == null ? 43 : ((Object)$globalDictColumns).hashCode());
            List<FileTreeNode> $snapshotTables = this.getSnapshotTables();
            result = result * 59 + ($snapshotTables == null ? 43 : ((Object)$snapshotTables).hashCode());
            List<FileTreeNode> $snapshots = this.getSnapshots();
            result = result * 59 + ($snapshots == null ? 43 : ((Object)$snapshots).hashCode());
            List<FileTreeNode> $dataflows = this.getDataflows();
            result = result * 59 + ($dataflows == null ? 43 : ((Object)$dataflows).hashCode());
            List<FileTreeNode> $segments = this.getSegments();
            result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
            List<FileTreeNode> $layouts = this.getLayouts();
            result = result * 59 + ($layouts == null ? 43 : ((Object)$layouts).hashCode());
            List<FileTreeNode> $buckets = this.getBuckets();
            result = result * 59 + ($buckets == null ? 43 : ((Object)$buckets).hashCode());
            List<FileTreeNode> $dfFlatTables = this.getDfFlatTables();
            result = result * 59 + ($dfFlatTables == null ? 43 : ((Object)$dfFlatTables).hashCode());
            List<FileTreeNode> $segmentFlatTables = this.getSegmentFlatTables();
            result = result * 59 + ($segmentFlatTables == null ? 43 : ((Object)$segmentFlatTables).hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "StorageCleaner.ProjectFileTreeNode(super=" + super.toString() + ")";
        }
    }

    public static class FileTreeNode {
        @NonNull
        String name;
        FileTreeNode parent;

        public String getRelativePath() {
            if (this.parent == null) {
                return this.name;
            }
            return this.parent.getRelativePath() + "/" + this.name;
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public FileTreeNode getParent() {
            return this.parent;
        }

        @Generated
        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.name = name;
        }

        @Generated
        public void setParent(FileTreeNode parent) {
            this.parent = parent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileTreeNode)) {
                return false;
            }
            FileTreeNode other = (FileTreeNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            FileTreeNode this$parent = this.getParent();
            FileTreeNode other$parent = other.getParent();
            return !(this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FileTreeNode;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            FileTreeNode $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StorageCleaner.FileTreeNode(name=" + this.getName() + ", parent=" + this.getParent() + ")";
        }

        @Generated
        public FileTreeNode() {
        }

        @Generated
        public FileTreeNode(@NonNull String name, FileTreeNode parent) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.name = name;
            this.parent = parent;
        }

        @Generated
        public FileTreeNode(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.name = name;
        }
    }

    public static class StorageItem {
        @NonNull
        private FileSystemDecorator fileSystemDecorator;
        @NonNull
        private String path;
        List<FileTreeNode> projectNodes = Lists.newArrayList();
        Map<String, ProjectFileTreeNode> projects = Maps.newHashMap();

        List<FileTreeNode> getAllNodes() {
            List<FileTreeNode> allNodes = this.projects.values().stream().flatMap(p -> p.getAllCandidates().stream()).flatMap(Collection::stream).collect(Collectors.toList());
            allNodes.addAll(this.projectNodes);
            return allNodes;
        }

        ProjectFileTreeNode getProject(String name) {
            return this.projects.getOrDefault(name, new ProjectFileTreeNode(name));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StorageItem that = (StorageItem)o;
            return Objects.equals(this.fileSystemDecorator.fs, that.fileSystemDecorator.fs) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.fileSystemDecorator.fs, this.path);
        }

        @NonNull
        @Generated
        public FileSystemDecorator getFileSystemDecorator() {
            return this.fileSystemDecorator;
        }

        @NonNull
        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public List<FileTreeNode> getProjectNodes() {
            return this.projectNodes;
        }

        @Generated
        public Map<String, ProjectFileTreeNode> getProjects() {
            return this.projects;
        }

        @Generated
        public void setFileSystemDecorator(@NonNull FileSystemDecorator fileSystemDecorator) {
            if (fileSystemDecorator == null) {
                throw new NullPointerException("fileSystemDecorator is marked @NonNull but is null");
            }
            this.fileSystemDecorator = fileSystemDecorator;
        }

        @Generated
        public void setPath(@NonNull String path) {
            if (path == null) {
                throw new NullPointerException("path is marked @NonNull but is null");
            }
            this.path = path;
        }

        @Generated
        public void setProjectNodes(List<FileTreeNode> projectNodes) {
            this.projectNodes = projectNodes;
        }

        @Generated
        public void setProjects(Map<String, ProjectFileTreeNode> projects) {
            this.projects = projects;
        }

        @Generated
        public String toString() {
            return "StorageCleaner.StorageItem(fileSystemDecorator=" + this.getFileSystemDecorator() + ", path=" + this.getPath() + ", projectNodes=" + this.getProjectNodes() + ", projects=" + this.getProjects() + ")";
        }

        @Generated
        public StorageItem(@NonNull FileSystemDecorator fileSystemDecorator, @NonNull String path) {
            if (fileSystemDecorator == null) {
                throw new NullPointerException("fileSystemDecorator is marked @NonNull but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked @NonNull but is null");
            }
            this.fileSystemDecorator = fileSystemDecorator;
            this.path = path;
        }

        @Generated
        public StorageItem(@NonNull FileSystemDecorator fileSystemDecorator, @NonNull String path, List<FileTreeNode> projectNodes, Map<String, ProjectFileTreeNode> projects) {
            if (fileSystemDecorator == null) {
                throw new NullPointerException("fileSystemDecorator is marked @NonNull but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked @NonNull but is null");
            }
            this.fileSystemDecorator = fileSystemDecorator;
            this.path = path;
            this.projectNodes = projectNodes;
            this.projects = projects;
        }
    }

    public static class FileSystemDecorator {
        @NonNull
        private FileSystem fs;
        private static int retryTimes = 3;

        private <E> E sleepAndRetry(Action<E> action) throws IOException {
            rateLimiter.acquire();
            for (int i = 0; i < retryTimes - 1; ++i) {
                try {
                    return action.run();
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error("Failed to use fs api!", (Throwable)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        log.error("Failed to sleep!", (Throwable)ie);
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
            }
            return action.run();
        }

        public static FileSystemDecorator getInstance(FileSystem fs) {
            return new FileSystemDecorator(fs);
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return this.sleepAndRetry(() -> this.fs.listStatus(f));
        }

        public FileStatus[] listStatus(Path f, PathFilter filter) throws IOException {
            return this.sleepAndRetry(() -> this.fs.listStatus(f, filter));
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            return this.sleepAndRetry(() -> this.fs.getFileStatus(f));
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            return this.sleepAndRetry(() -> this.fs.delete(f, recursive));
        }

        @Generated
        public FileSystemDecorator(@NonNull FileSystem fs) {
            if (fs == null) {
                throw new NullPointerException("fs is marked @NonNull but is null");
            }
            this.fs = fs;
        }

        static interface Action<T> {
            public T run() throws IOException;
        }
    }

    class ProjectTemporaryTableCleaner {
        private final String project;
        private CliCommandExecutor cliCommandExecutor;
        private ProjectTemporaryTableCleanerHelper tableCleanerHelper;

        ProjectTemporaryTableCleaner(String project) {
            this.project = project;
            this.cliCommandExecutor = new CliCommandExecutor();
            this.tableCleanerHelper = new ProjectTemporaryTableCleanerHelper();
        }

        public void execute() {
            List<FileTreeNode> jobTemps = ((StorageItem)StorageCleaner.this.allFileSystems.iterator().next()).getProject(this.project).getJobTmps();
            this.doExecuteCmd(this.collectDropTemporaryTransactionTable(jobTemps));
        }

        private void doExecuteCmd(String cmd) {
            try {
                CliCommandExecutor.CliCmdExecResult executeResult = this.cliCommandExecutor.execute(cmd, null);
                if (executeResult.getCode() != 0) {
                    log.error("execute drop intermediate table return fail, cmd : " + cmd);
                } else {
                    log.info("execute drop intermediate table succeeded, cmd: " + cmd);
                }
            }
            catch (ShellException e) {
                log.error("execute drop intermediate table error, cmd : " + cmd, (Throwable)e);
            }
        }

        public String collectDropTemporaryTransactionTable(List<FileTreeNode> jobTemps) {
            String result = "";
            try {
                KylinConfig config = KylinConfig.getInstanceFromEnv();
                Set<String> jobTempTables = jobTemps.stream().map(node -> this.tableCleanerHelper.getJobTransactionalTable(this.project, node.getName())).flatMap(Collection::stream).collect(Collectors.toSet());
                Set discardTempTables = NExecutableManager.getInstance((KylinConfig)config, (String)this.project).getExecutablesByStatus(ExecutableState.DISCARDED).stream().map(e -> this.tableCleanerHelper.getJobTransactionalTable(this.project, e.getId())).flatMap(Collection::stream).collect(Collectors.toSet());
                jobTempTables.addAll(discardTempTables);
                if (CollectionUtils.isNotEmpty(jobTempTables) && config.isReadTransactionalTableEnabled()) {
                    result = this.tableCleanerHelper.getDropTmpTableCmd(this.project, jobTempTables);
                }
            }
            catch (Exception exception) {
                log.error("Failed to delete temporary tables.", (Throwable)exception);
            }
            log.info("collectDropTemporaryTransactionTable end.");
            return result;
        }
    }

    class ProjectStorageCleaner {
        private final String project;
        private final Set<String> dependentFiles = Sets.newTreeSet();

        ProjectStorageCleaner(String project) {
            this.project = project;
        }

        public void execute() {
            this.collectJobTmp(this.project);
            this.collectDataflow(this.project);
            this.collectTable(this.project);
            for (StorageItem item : StorageCleaner.this.allFileSystems) {
                for (List<FileTreeNode> nodes : item.getProject(this.project).getAllCandidates()) {
                    for (FileTreeNode node : nodes) {
                        log.debug("find candidate /{}", (Object)node.getRelativePath());
                    }
                }
            }
            for (String dependentFile : this.dependentFiles) {
                log.debug("remove candidate {}", (Object)dependentFile);
            }
            this.removeDependentFiles();
        }

        private void removeDependentFiles() {
            for (StorageItem item : StorageCleaner.this.allFileSystems) {
                for (List<FileTreeNode> nodes : item.getProject(this.project).getAllCandidates()) {
                    nodes.removeIf(node -> this.dependentFiles.stream().anyMatch(df -> ("/" + node.getRelativePath()).startsWith((String)df) || df.startsWith("/" + node.getRelativePath())));
                }
            }
        }

        private void collectJobTmp(String project) {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            NExecutableManager executableManager = NExecutableManager.getInstance((KylinConfig)config, (String)project);
            Set activeJobs = executableManager.getAllExecutables().stream().map(e -> project + "/job_tmp" + "/" + e.getId()).collect(Collectors.toSet());
            for (StorageItem item : StorageCleaner.this.allFileSystems) {
                item.getProject(project).getJobTmps().removeIf(node -> activeJobs.contains(node.getRelativePath()));
            }
        }

        private void collectDataflow(String project) {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            HashSet activeIndexDataPath = Sets.newHashSet();
            HashSet activeBucketDataPath = Sets.newHashSet();
            HashSet activeFastBitmapIndexDataPath = Sets.newHashSet();
            HashSet activeSegmentFlatTableDataPath = Sets.newHashSet();
            Set dataflows = NDataflowManager.getInstance((KylinConfig)config, (String)project).listAllDataflows().stream().map(RootPersistentEntity::getId).collect(Collectors.toSet());
            dataflowManager.listAllDataflows().forEach(df -> df.getSegments().stream().map(segment -> StorageCleaner.this.getSegmentFlatTableDir(project, segment)).forEach(activeSegmentFlatTableDataPath::add));
            dataflowManager.listAllDataflows().forEach(dataflow -> dataflow.getSegments().stream().flatMap(segment -> segment.getLayoutsMap().values().stream()).forEach(layout -> {
                activeIndexDataPath.add(StorageCleaner.this.getDataLayoutDir(layout));
                layout.getMultiPartition().forEach(partition -> activeBucketDataPath.add(StorageCleaner.this.getDataPartitionDir(layout, partition)));
            }));
            activeIndexDataPath.forEach(path -> activeFastBitmapIndexDataPath.add(path + "_fast_bitmap"));
            Set activeSegmentPath = activeIndexDataPath.stream().map(s -> new File((String)s).getParent()).collect(Collectors.toSet());
            for (StorageItem item : StorageCleaner.this.allFileSystems) {
                item.getProject(project).getDataflows().removeIf(node -> dataflows.contains(node.getName()));
                item.getProject(project).getSegments().removeIf(node -> activeSegmentPath.contains(node.getRelativePath()));
                item.getProject(project).getLayouts().removeIf(node -> activeIndexDataPath.contains(node.getRelativePath()) || activeFastBitmapIndexDataPath.contains(node.getRelativePath()));
                item.getProject(project).getBuckets().removeIf(node -> activeBucketDataPath.contains(node.getRelativePath()));
                item.getProject(project).getDfFlatTables().removeIf(node -> dataflows.contains(node.getName()));
                item.getProject(project).getSegmentFlatTables().removeIf(node -> activeSegmentFlatTableDataPath.contains(node.getRelativePath()));
            }
        }

        private void collectTable(String project) {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)project);
            HashSet activeDictDir = Sets.newHashSet();
            HashSet activeTableExdDir = Sets.newHashSet();
            HashSet activeDictTableDir = Sets.newHashSet();
            HashSet activeSnapshotTableDir = Sets.newHashSet();
            HashSet activeSnapshotDir = Sets.newHashSet();
            tableManager.listAllTables().forEach(table -> {
                Arrays.stream(table.getColumns()).map(column -> StorageCleaner.this.getDictDir(project) + "/" + table.getIdentity() + "/" + column.getName()).forEach(activeDictDir::add);
                activeTableExdDir.add(project + "/table_exd" + "/" + table.getIdentity());
                activeSnapshotTableDir.add(project + "/table_snapshot" + "/" + table.getIdentity());
                if (table.getLastSnapshotPath() != null) {
                    activeSnapshotDir.add(table.getLastSnapshotPath());
                }
                activeDictTableDir.add(StorageCleaner.this.getDictDir(project) + "/" + table.getIdentity());
            });
            for (StorageItem item : StorageCleaner.this.allFileSystems) {
                item.getProject(project).getGlobalDictTables().removeIf(node -> activeDictTableDir.contains(node.getRelativePath()));
                item.getProject(project).getGlobalDictColumns().removeIf(node -> activeDictDir.contains(node.getRelativePath()));
                item.getProject(project).getSnapshots().removeIf(node -> activeSnapshotDir.contains(node.getRelativePath()));
                item.getProject(project).getSnapshotTables().removeIf(node -> activeSnapshotTableDir.contains(node.getRelativePath()));
                item.getProject(project).getTableExds().removeIf(node -> activeTableExdDir.contains(node.getRelativePath()));
            }
        }
    }
}

