/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.query.util.ExtractFactory;
import org.apache.kylin.query.util.ILogExtractor;
import org.apache.spark.sql.SparderEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ToolUtil.class);

    private ToolUtil() {
    }

    public static void dumpKylinJStack(File outputFile) throws IOException, ShellException {
        String jstackDumpCmd = String.format(Locale.ROOT, "jstack -l %s", ToolUtil.getKylinPid());
        CliCommandExecutor.CliCmdExecResult result = new CliCommandExecutor().execute(jstackDumpCmd, null);
        FileUtils.writeStringToFile((File)outputFile, (String)result.getCmd(), (Charset)Charset.defaultCharset());
    }

    public static String getKylinPid() {
        File pidFile = new File(ToolUtil.getKylinHome(), "pid");
        if (pidFile.exists()) {
            try {
                return FileUtils.readFileToString((File)pidFile, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new IllegalStateException("Error reading KYLIN PID file.", e);
            }
        }
        throw new IllegalStateException("Cannot find KYLIN PID file.");
    }

    public static String getKylinHome() {
        String path = System.getProperty("KYLIN_CONF");
        if (StringUtils.isNotEmpty((String)path)) {
            return path;
        }
        path = KylinConfig.getKylinHome();
        if (StringUtils.isNotEmpty((String)path)) {
            return path;
        }
        throw new IllegalStateException("Cannot find KYLIN_HOME.");
    }

    public static String getBinFolder() {
        String BIN = "bin";
        return ToolUtil.getKylinHome() + File.separator + "bin";
    }

    public static String getLogFolder() {
        String LOG = "logs";
        return ToolUtil.getKylinHome() + File.separator + "logs";
    }

    public static String getConfFolder() {
        String CONF = "conf";
        return ToolUtil.getKylinHome() + File.separator + "conf";
    }

    public static String getHadoopConfFolder() {
        String HADOOP_CONF = "hadoop_conf";
        return ToolUtil.getKylinHome() + File.separator + "hadoop_conf";
    }

    public static String getMetaStoreId() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig);
        return store.getMetaStoreUUID();
    }

    public static String getHostName() {
        String hostname = System.getenv("COMPUTERNAME");
        if (StringUtils.isEmpty((String)hostname)) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                hostname = address.getHostName();
                if (StringUtils.isEmpty((String)hostname)) {
                    hostname = AddressUtil.getLocalHostExactAddress();
                }
            }
            catch (UnknownHostException uhe) {
                int colon;
                String host = uhe.getMessage();
                if (host != null && (colon = host.indexOf(58)) > 0) {
                    return host.substring(0, colon);
                }
                hostname = "Unknown";
            }
        }
        return hostname;
    }

    private static String getHdfsPrefix() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        return kylinConfig.getHdfsWorkingDirectory();
    }

    public static String getSparderLogsDir() {
        String SPARDER_LOG = "_sparder_logs";
        return ToolUtil.getHdfsPrefix() + File.separator + "_sparder_logs";
    }

    public static String getSparkLogsDir(String project) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)project) ? 1 : 0) != 0);
        String SPARK_LOG = "spark_logs";
        return ToolUtil.getHdfsPrefix() + File.separator + project + File.separator + "spark_logs";
    }

    public static String getJobTmpDir(String project, String jobId) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)project) && !StringUtils.isBlank((String)jobId) ? 1 : 0) != 0);
        String JOB_TMP = "job_tmp";
        return ToolUtil.getHdfsPrefix() + File.separator + project + File.separator + "job_tmp" + File.separator + jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForSparderRollUp() {
        ILogExtractor extractor = ExtractFactory.create();
        String check = SparderEnv.rollUpEventLog();
        if (StringUtils.isBlank((String)check)) {
            log.info("Failed to roll up eventLog because the spader is closed.");
            return false;
        }
        String logDir = extractor.getSparderEvenLogDir();
        ExecutorService es = Executors.newSingleThreadExecutor();
        FileSystem fs = HadoopUtil.getFileSystem((String)logDir);
        try {
            Future<Boolean> task = es.submit(() -> {
                while (!fs.exists(new Path(logDir, check))) {
                    Thread.sleep(1000L);
                }
                return true;
            });
            if (Boolean.TRUE.equals(task.get(10L, TimeUnit.SECONDS))) {
                fs.delete(new Path(logDir, check), false);
                boolean bl = true;
                return bl;
            }
        }
        catch (InterruptedException e) {
            log.warn("Sparder eventLog rollUp failed.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.warn("Sparder eventLog rollUp failed.", (Throwable)e);
        }
        finally {
            es.shutdown();
        }
        return false;
    }

    public static boolean isPortAvailable(String ip, int port) {
        boolean isAvailable;
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(ip, port), 1000);
            isAvailable = socket.isConnected();
        }
        catch (Exception e) {
            log.warn("Connect failed", (Throwable)e);
            isAvailable = false;
        }
        return isAvailable;
    }

    public static String getHdfsJobTmpDir(String project) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)project) ? 1 : 0) != 0);
        String JOB_TMP = "job_tmp";
        return ToolUtil.getHdfsPrefix() + File.separator + project + File.separator + "job_tmp";
    }
}

