/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.controller.BaseController;
import org.apache.kylin.rest.request.RefreshSegmentsRequest;
import org.apache.kylin.rest.request.SamplingRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.ModelBuildSupporter;
import org.apache.kylin.rest.service.TableSamplingService;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.util.DataRangeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/tables"}, produces={"application/vnd.apache.kylin-v4+json"})
public class SampleController
extends BaseController {
    private static final String TABLE = "table";
    @Autowired
    @Qualifier(value="tableService")
    private TableService tableService;
    @Autowired
    @Qualifier(value="modelBuildService")
    private ModelBuildSupporter modelBuildService;
    @Autowired
    @Qualifier(value="tableSamplingService")
    private TableSamplingService tableSamplingService;

    @ApiOperation(value="refreshSegments", tags={"AI"}, notes="Update Body: refresh_start, refresh_end, affected_start, affected_end")
    @PutMapping(value={"/data_range"})
    @ResponseBody
    public EnvelopeResponse<String> refreshSegments(@RequestBody RefreshSegmentsRequest request) throws IOException {
        this.checkProjectName(request.getProject());
        this.checkRequiredArg(TABLE, request.getTable());
        this.checkRequiredArg("refresh start", request.getRefreshStart());
        this.checkRequiredArg("refresh end", request.getRefreshEnd());
        this.checkRequiredArg("affected start", request.getAffectedStart());
        this.checkRequiredArg("affected end", request.getAffectedEnd());
        DataRangeUtils.validateRange((String)request.getRefreshStart(), (String)request.getRefreshEnd());
        this.modelBuildService.refreshSegments(request.getProject(), request.getTable(), request.getRefreshStart(), request.getRefreshEnd(), request.getAffectedStart(), request.getAffectedEnd());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="partitionColumnFormat", tags={"AI"})
    @GetMapping(value={"/partition_column_format"})
    @ResponseBody
    public EnvelopeResponse<String> getPartitionColumnFormat(@RequestParam(value="project") String project, @RequestParam(value="table") String table, @RequestParam(value="partition_column") String partitionColumn) throws Exception {
        this.checkProjectName(project);
        this.checkRequiredArg(TABLE, table);
        this.checkRequiredArg("partitionColumn", partitionColumn);
        return new EnvelopeResponse("000", (Object)this.tableService.getPartitionColumnFormat(project, table, partitionColumn), "");
    }

    @ApiOperation(value="samplingJobs", tags={"AI"})
    @PostMapping(value={"/sampling_jobs"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> submitSampling(@RequestBody SamplingRequest request) {
        this.checkProjectName(request.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(request.getProject());
        this.checkParamLength("tag", request.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        TableSamplingService.checkSamplingRows((int)request.getRows());
        TableSamplingService.checkSamplingTable((String)request.getQualifiedTableName());
        this.validatePriority(request.getPriority());
        this.tableSamplingService.sampling((Set)Sets.newHashSet((Object[])new String[]{request.getQualifiedTableName()}), request.getProject(), request.getRows(), request.getPriority(), request.getYarnQueue(), request.getTag());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="hasSamplingJob", tags={"AI"}, notes="Update Param: qualified_table_name")
    @GetMapping(value={"/sampling_check_result"})
    @ResponseBody
    public EnvelopeResponse<Boolean> hasSamplingJob(@RequestParam(value="project") String project, @RequestParam(value="qualified_table_name") String qualifiedTableName) {
        this.checkProjectName(project);
        TableSamplingService.checkSamplingTable((String)qualifiedTableName);
        boolean hasSamplingJob = this.tableSamplingService.hasSamplingJob(project, qualifiedTableName);
        return new EnvelopeResponse("000", (Object)hasSamplingJob, "");
    }
}

