/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.base.CaseFormat;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.constant.SnapshotStatus;
import org.apache.kylin.rest.controller.BaseController;
import org.apache.kylin.rest.request.SnapshotRequest;
import org.apache.kylin.rest.request.SnapshotTableConfigRequest;
import org.apache.kylin.rest.request.TablePartitionsRequest;
import org.apache.kylin.rest.request.TableReloadPartitionColRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.JobInfoResponse;
import org.apache.kylin.rest.response.NInitTablesResponse;
import org.apache.kylin.rest.response.SnapshotCheckResponse;
import org.apache.kylin.rest.response.SnapshotColResponse;
import org.apache.kylin.rest.response.SnapshotInfoResponse;
import org.apache.kylin.rest.response.TableNameResponse;
import org.apache.kylin.rest.service.SnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/snapshots"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class SnapshotController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotController.class);
    @Autowired
    @Qualifier(value="snapshotService")
    private SnapshotService snapshotService;

    @ApiOperation(value="config partition col for snapshot Tables", tags={"AI"}, notes="config partition col")
    @PostMapping(value={"/config"})
    @ResponseBody
    public EnvelopeResponse<String> configSnapshotPartitionCol(@RequestBody SnapshotTableConfigRequest configRequest) {
        this.checkProjectName(configRequest.getProject());
        this.snapshotService.configSnapshotPartitionCol(configRequest.getProject(), configRequest.getTablePartitionCol());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="get col info of snapshot table", tags={"AI"}, notes="get col info")
    @GetMapping(value={"/config"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<SnapshotColResponse>>> getSnapshotCols(@RequestParam(value="project") String project, @RequestParam(value="tables", required=false, defaultValue="") Set<String> tables, @RequestParam(value="databases", required=false, defaultValue="") Set<String> databases, @RequestParam(value="table_pattern", required=false, defaultValue="") String tablePattern, @RequestParam(value="include_exist", required=false, defaultValue="true") boolean includeExistSnapshot, @RequestParam(value="exclude_broken", required=false, defaultValue="true") boolean excludeBroken, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) {
        project = this.checkProjectName(project);
        this.checkNonNegativeIntegerArg("page_offset", offset);
        this.checkNonNegativeIntegerArg("page_size", limit);
        List responses = this.snapshotService.getSnapshotCol(project, tables, databases, tablePattern, includeExistSnapshot, excludeBroken);
        return new EnvelopeResponse("000", (Object)DataResult.get((List)responses, (int)offset, (int)limit), "");
    }

    @ApiOperation(value="reload partition col of table", tags={"AI"}, notes="reload partition col")
    @PostMapping(value={"/reload_partition_col"})
    @ResponseBody
    public EnvelopeResponse<SnapshotColResponse> getSnapshotCols(@RequestBody TableReloadPartitionColRequest request) throws Exception {
        try {
            this.checkProjectName(request.getProject());
            SnapshotColResponse responses = this.snapshotService.reloadPartitionCol(request.getProject(), request.getTable());
            return new EnvelopeResponse("000", (Object)responses, "");
        }
        catch (Exception e) {
            logger.error("reload partition column failed...", (Throwable)e);
            Throwable root = ExceptionUtils.getRootCause((Throwable)e) == null ? e : ExceptionUtils.getRootCause((Throwable)e);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SNAPSHOT_RELOAD_PARTITION_FAILED, root.getMessage());
        }
    }

    @ApiOperation(value="partitions of table", tags={"AI"}, notes="get partition value")
    @PostMapping(value={"/partitions"})
    @ResponseBody
    public EnvelopeResponse getSnapshotPartitionValues(@RequestBody TablePartitionsRequest tablePartitionsRequest) {
        this.checkProjectName(tablePartitionsRequest.getProject());
        Map response = this.snapshotService.getPartitions(tablePartitionsRequest.getProject(), tablePartitionsRequest.getTableCols());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="buildSnapshotsManually", tags={"AI"}, notes="build snapshots")
    @PostMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> buildSnapshotsManually(@RequestBody SnapshotRequest snapshotsRequest) {
        this.checkProjectName(snapshotsRequest.getProject());
        this.validatePriority(snapshotsRequest.getPriority());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(snapshotsRequest.getProject());
        this.checkParamLength("tag", snapshotsRequest.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        if (snapshotsRequest.getTables().isEmpty() && snapshotsRequest.getDatabases().isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "You should select at least one table or database to load!!");
        }
        JobInfoResponse response = this.snapshotService.buildSnapshots(snapshotsRequest, false);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="refreshSnapshotsManually", tags={"AI"}, notes="refresh snapshots")
    @PutMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> refreshSnapshotsManually(@RequestBody SnapshotRequest snapshotsRequest) throws Exception {
        this.checkProjectName(snapshotsRequest.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(snapshotsRequest.getProject());
        this.checkParamLength("tag", snapshotsRequest.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        this.validatePriority(snapshotsRequest.getPriority());
        if (snapshotsRequest.getTables().isEmpty() && snapshotsRequest.getDatabases().isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "You should select at least one table or database to load!!");
        }
        JobInfoResponse response = this.snapshotService.buildSnapshots(snapshotsRequest, true);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="refreshSnapshotsManually", tags={"AI"}, notes="refresh snapshots")
    @PutMapping(value={"auto_refresh"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> autoRefreshSnapshots(@RequestBody SnapshotRequest snapshotsRequest) {
        logger.info("refreshSnapshotsAutomatic request: {}", (Object)snapshotsRequest);
        this.checkProjectName(snapshotsRequest.getProject());
        JobInfoResponse response = this.snapshotService.autoRefreshSnapshots(snapshotsRequest, true);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="checkBeforeDelete", tags={"AI"}, notes="check before delete snapshots")
    @PostMapping(value={"/check_before_delete"})
    @ResponseBody
    public EnvelopeResponse<SnapshotCheckResponse> checkBeforeDelete(@RequestBody SnapshotRequest snapshotsRequest) {
        this.checkProjectName(snapshotsRequest.getProject());
        SnapshotCheckResponse response = this.snapshotService.checkBeforeDeleteSnapshots(snapshotsRequest.getProject(), snapshotsRequest.getTables());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="deleteSnapshots", tags={"AI"}, notes="delete snapshots")
    @DeleteMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<SnapshotCheckResponse> deleteSnapshots(@RequestParam(value="project") String project, @RequestParam(value="tables") Set<String> tables) {
        project = this.checkProjectName(project);
        this.checkCollectionRequiredArg("tables", tables);
        SnapshotCheckResponse response = this.snapshotService.deleteSnapshots(project, tables);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="getSnapshots", tags={"AI"}, notes="get snapshots")
    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<SnapshotInfoResponse>>> getSnapshots(@RequestParam(value="project") String project, @RequestParam(value="table", required=false, defaultValue="") String table, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="status", required=false, defaultValue="") Set<SnapshotStatus> statusFilter, @RequestParam(value="partition", required=false, defaultValue="") Set<Boolean> partitionFilter, @RequestParam(value="sort_by", required=false, defaultValue="last_modified_time") String sortBy, @RequestParam(value="reverse", required=false, defaultValue="true") boolean isReversed) {
        project = this.checkProjectName(project);
        this.checkNonNegativeIntegerArg("page_offset", offset);
        this.checkNonNegativeIntegerArg("page_size", limit);
        this.checkBooleanArg("reverse", isReversed);
        try {
            SnapshotInfoResponse.class.getDeclaredField(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, sortBy));
        }
        catch (NoSuchFieldException e) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SORT_BY_FIELD_NOT_EXIST, new Object[]{sortBy});
        }
        Pair snapshotsAndSize = this.snapshotService.getProjectSnapshots(project, table, statusFilter, partitionFilter, sortBy, isReversed, Pair.newPair((Object)offset, (Object)limit));
        return new EnvelopeResponse("000", (Object)new DataResult((Collection)snapshotsAndSize.getFirst(), ((Integer)snapshotsAndSize.getSecond()).intValue(), offset.intValue(), limit.intValue()), "");
    }

    @ApiOperation(value="getTables", tags={"AI"}, notes="get all tables with or without snapshot")
    @GetMapping(value={"/tables"})
    @ResponseBody
    public EnvelopeResponse<NInitTablesResponse> getTables(@RequestParam(value="project") String project, @RequestParam(value="table", required=false, defaultValue="") String table, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) {
        project = this.checkProjectName(project);
        this.checkNonNegativeIntegerArg("page_offset", offset);
        this.checkNonNegativeIntegerArg("page_size", limit);
        NInitTablesResponse res = this.snapshotService.getTables(project, table, offset.intValue(), limit.intValue());
        return new EnvelopeResponse("000", (Object)res, "");
    }

    @ApiOperation(value="loadMoreTables", tags={"AI"}, notes="load more table pages")
    @GetMapping(value={"/tables/more"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<TableNameResponse>>> loadMoreTables(@RequestParam(value="project") String project, @RequestParam(value="table", required=false, defaultValue="") String table, @RequestParam(value="database") String database, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) {
        project = this.checkProjectName(project);
        this.checkRequiredArg("database", database);
        this.checkNonNegativeIntegerArg("page_offset", offset);
        this.checkNonNegativeIntegerArg("page_size", limit);
        List tables = this.snapshotService.getTableNameResponses(project, database, table);
        return new EnvelopeResponse("000", (Object)DataResult.get((List)tables, (int)offset, (int)limit), "");
    }
}

