/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import com.google.common.annotations.VisibleForTesting;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.rest.controller.BaseController;
import org.apache.kylin.rest.controller.SampleController;
import org.apache.kylin.rest.request.RefreshSegmentsRequest;
import org.apache.kylin.rest.request.SamplingRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.OpenPartitionColumnFormatResponse;
import org.apache.kylin.rest.service.TableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/tables"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenSampleController
extends BaseController {
    private static final String TABLE = "table";
    @Autowired
    private SampleController sampleController;
    @Autowired
    private TableService tableService;

    @ApiOperation(value="refreshSegments", tags={"DW"})
    @PutMapping(value={"/data_range"})
    @ResponseBody
    public EnvelopeResponse<String> refreshSegments(@RequestBody RefreshSegmentsRequest request) throws IOException {
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        this.checkRequiredArg("tableName", request.getTable());
        this.getTable(request.getProject(), request.getTable());
        return this.sampleController.refreshSegments(request);
    }

    @ApiOperation(value="samplingJobs", tags={"AI"})
    @PostMapping(value={"/sampling_jobs"})
    @ResponseBody
    public EnvelopeResponse<String> submitSampling(@RequestBody SamplingRequest request) {
        this.checkProjectName(request.getProject());
        request.setQualifiedTableName(StringUtils.upperCase((String)request.getQualifiedTableName(), (Locale)Locale.ROOT));
        this.checkStreamingOperation(request.getProject(), request.getQualifiedTableName());
        return this.sampleController.submitSampling(request);
    }

    @ApiOperation(value="getPartitionColumnFormat", tags={"DW"})
    @GetMapping(value={"/column_format"})
    @ResponseBody
    public EnvelopeResponse<OpenPartitionColumnFormatResponse> getPartitionColumnFormat(@RequestParam(value="project") String project, @RequestParam(value="table") String table, @RequestParam(value="column_name") String columnName) throws Exception {
        String projectName = this.checkProjectName(project);
        this.checkRequiredArg(TABLE, table);
        this.checkRequiredArg("column_name", columnName);
        String columnFormat = this.tableService.getPartitionColumnFormat(projectName, StringUtils.upperCase((String)table, (Locale)Locale.ROOT), columnName);
        OpenPartitionColumnFormatResponse columnFormatResponse = new OpenPartitionColumnFormatResponse();
        columnFormatResponse.setColumnName(columnName);
        columnFormatResponse.setColumnFormat(columnFormat);
        return new EnvelopeResponse("000", (Object)columnFormatResponse, "");
    }

    @VisibleForTesting
    protected TableDesc getTable(String project, String tableName) {
        TableDesc table = ((NTableMetadataManager)this.tableService.getManager(NTableMetadataManager.class, project)).getTableDesc(tableName);
        if (null == table) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), tableName));
        }
        return table;
    }
}

