/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.controller.BaseController;
import org.apache.kylin.rest.controller.SegmentController;
import org.apache.kylin.rest.request.BuildIndexRequest;
import org.apache.kylin.rest.request.BuildSegmentsRequest;
import org.apache.kylin.rest.request.CheckSegmentRequest;
import org.apache.kylin.rest.request.IndexesToSegmentsRequest;
import org.apache.kylin.rest.request.PartitionsBuildRequest;
import org.apache.kylin.rest.request.PartitionsRefreshRequest;
import org.apache.kylin.rest.request.SegmentsRequest;
import org.apache.kylin.rest.response.BuildIndexResponse;
import org.apache.kylin.rest.response.CheckSegmentResponse;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.JobInfoResponse;
import org.apache.kylin.rest.response.JobInfoResponseWithFailure;
import org.apache.kylin.rest.response.NDataSegmentResponse;
import org.apache.kylin.rest.response.SegmentPartitionResponse;
import org.apache.kylin.rest.service.FusionModelService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.util.DataRangeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/models"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenSegmentController
extends BaseController {
    @Autowired
    private SegmentController segmentController;
    @Autowired
    private ModelService modelService;
    @Autowired
    private FusionModelService fusionModelService;
    @Autowired
    private AclEvaluate aclEvaluate;

    @VisibleForTesting
    public NDataModel getModel(String modelAlias, String project) {
        NDataModel model = ((NDataModelManager)this.modelService.getManager(NDataModelManager.class, project)).listAllModels().stream().filter(dataModel -> dataModel.getUuid().equals(modelAlias) || dataModel.getAlias().equalsIgnoreCase(modelAlias)).findFirst().orElse(null);
        if (model == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAlias});
        }
        if (model.isBroken()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_BROKEN, String.format(Locale.ROOT, MsgPicker.getMsg().getBrokenModelOperationDenied(), modelAlias));
        }
        return model;
    }

    @ApiOperation(value="getSegments", tags={"AI"})
    @GetMapping(value={"/{model_name:.+}/segments"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<NDataSegmentResponse>>> getSegments(@PathVariable(value="model_name") String modelAlias, @RequestParam(value="project") String project, @RequestParam(value="status", required=false) String status, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="start", required=false, defaultValue="1") String start, @RequestParam(value="end", required=false, defaultValue="9223372036854775806") String end, @RequestParam(value="sort_by", required=false, defaultValue="last_modified_time") String sortBy, @RequestParam(value="reverse", required=false, defaultValue="false") Boolean reverse, @RequestParam(value="statuses", required=false, defaultValue="") List<String> statuses, @RequestParam(value="statuses_second_storage", required=false, defaultValue="") List<String> statusesSecondStorage) {
        this.checkNonNegativeIntegerArg("page_offset", offset);
        this.checkNonNegativeIntegerArg("page_size", limit);
        String projectName = this.checkProjectName(project);
        String modelId = this.getModel(modelAlias, projectName).getUuid();
        return this.segmentController.getSegments(modelId, projectName, status, offset, limit, start, end, null, null, false, sortBy, reverse, statuses, statusesSecondStorage);
    }

    @ApiOperation(value="getMultiPartitions", tags={"DW"})
    @GetMapping(value={"/{model_name:.+}/segments/multi_partition"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<SegmentPartitionResponse>>> getMultiPartitions(@PathVariable(value="model_name") String modelAlias, @RequestParam(value="project") String project, @RequestParam(value="segment_id") String segId, @RequestParam(value="status", required=false) List<String> status, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="sort_by", required=false, defaultValue="last_modify_time") String sortBy, @RequestParam(value="reverse", required=false, defaultValue="true") Boolean reverse) {
        this.checkNonNegativeIntegerArg("page_offset", pageOffset);
        this.checkNonNegativeIntegerArg("page_size", pageSize);
        String projectName = this.checkProjectName(project);
        String modelId = this.getModel(modelAlias, project).getId();
        return this.segmentController.getMultiPartition(modelId, projectName, segId, status, pageOffset, pageSize, sortBy, reverse);
    }

    @ApiOperation(value="buildSegmentsManually", tags={"DW"})
    @PostMapping(value={"/{model_name:.+}/segments"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> buildSegmentsManually(@PathVariable(value="model_name") String modelAlias, @RequestBody BuildSegmentsRequest buildSegmentsRequest) throws Exception {
        String projectName = this.checkProjectName(buildSegmentsRequest.getProject());
        buildSegmentsRequest.setProject(projectName);
        this.validatePriority(buildSegmentsRequest.getPriority());
        String modelId = this.getModel(modelAlias, buildSegmentsRequest.getProject()).getUuid();
        return this.segmentController.buildSegmentsManually(modelId, buildSegmentsRequest);
    }

    @ApiOperation(value="refreshOrMergeSegments", tags={"DW"})
    @PutMapping(value={"/{model_name:.+}/segments"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> refreshOrMergeSegments(@PathVariable(value="model_name") String modelAlias, @RequestBody SegmentsRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        this.validatePriority(request.getPriority());
        String modelId = this.getModel(modelAlias, request.getProject()).getUuid();
        return this.segmentController.refreshOrMergeSegments(modelId, request);
    }

    @ApiOperation(value="deleteSegments", tags={"DW"})
    @DeleteMapping(value={"/{model_name:.+}/segments"})
    @ResponseBody
    public EnvelopeResponse<String> deleteSegments(@PathVariable(value="model_name") String modelAlias, @RequestParam(value="project") String project, @RequestParam(value="purge") Boolean purge, @RequestParam(value="force", required=false, defaultValue="false") boolean force, @RequestParam(value="ids", required=false) String[] ids, @RequestParam(value="names", required=false) String[] names) {
        String projectName = this.checkProjectName(project);
        if (purge.booleanValue()) {
            ids = new String[]{};
        }
        String modelId = this.getModel(modelAlias, projectName).getUuid();
        return this.segmentController.deleteSegments(modelId, projectName, purge, force, ids, names);
    }

    @ApiOperation(value="completeSegments", tags={"DW"})
    @PostMapping(value={"/{model_name}/segments/completion"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponseWithFailure> completeSegments(@PathVariable(value="model_name") String modelAlias, @RequestParam(value="project") String project, @RequestParam(value="parallel", required=false, defaultValue="false") boolean parallel, @RequestParam(value="ids", required=false) String[] ids, @RequestParam(value="names", required=false) String[] names, @RequestParam(value="batch_index_ids", required=false) List<Long> batchIndexIds, @RequestParam(value="partial_build", required=false, defaultValue="false") boolean partialBuild, @RequestParam(value="priority", required=false, defaultValue="3") Integer priority, @RequestParam(value="yarn_queue", required=false) String yarnQueue, @RequestParam(value="tag", required=false) Object tag) {
        String projectName = this.checkProjectName(project);
        this.checkSegmentParams(ids, names);
        String modelId = this.getModel(modelAlias, projectName).getUuid();
        Pair pair = this.fusionModelService.convertSegmentIdWithName(modelId, projectName, ids, names);
        IndexesToSegmentsRequest req = new IndexesToSegmentsRequest();
        req.setProject(projectName);
        req.setParallelBuildBySegment(parallel);
        req.setSegmentIds((List)Lists.newArrayList((Object[])((Object[])pair.getSecond())));
        req.setPartialBuild(partialBuild);
        req.setIndexIds(batchIndexIds);
        req.setPriority(priority.intValue());
        req.setYarnQueue(yarnQueue);
        req.setTag(tag);
        return this.segmentController.addIndexesToSegments((String)pair.getFirst(), req);
    }

    @ApiOperation(value="buildIndicesManually", tags={"AI"})
    @PostMapping(value={"/{model_name:.+}/indexes"})
    @ResponseBody
    public EnvelopeResponse<BuildIndexResponse> buildIndicesManually(@PathVariable(value="model_name") String modelAlias, @RequestBody BuildIndexRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        this.validatePriority(request.getPriority());
        String modelId = this.getModel(modelAlias, request.getProject()).getId();
        return this.segmentController.buildIndicesManually(modelId, request);
    }

    @ApiOperation(value="checkSegments", tags={"DW"})
    @PostMapping(value={"/{model:.+}/segments/check"})
    @ResponseBody
    public EnvelopeResponse<CheckSegmentResponse> checkSegments(@PathVariable(value="model") String modelAlias, @RequestBody CheckSegmentRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        this.aclEvaluate.checkProjectOperationPermission(request.getProject());
        this.checkRequiredArg("start", request.getStart());
        this.checkRequiredArg("end", request.getEnd());
        DataRangeUtils.validateDataRange((String)request.getStart(), (String)request.getEnd());
        NDataModel model = this.getModel(modelAlias, projectName);
        return new EnvelopeResponse("000", (Object)this.modelService.checkSegments(request.getProject(), model.getAlias(), request.getStart(), request.getEnd()), "");
    }

    @ApiOperation(value="build multi_partition", tags={"DW"})
    @PostMapping(value={"/{model_name:.+}/segments/multi_partition"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> buildMultiPartition(@PathVariable(value="model_name") String modelAlias, @RequestBody PartitionsBuildRequest param) {
        String projectName = this.checkProjectName(param.getProject());
        this.checkProjectMLP(projectName);
        param.setProject(projectName);
        String modelId = this.getModel(modelAlias, param.getProject()).getId();
        return this.segmentController.buildMultiPartition(modelId, param);
    }

    @ApiOperation(value="refresh multi_partition", tags={"DW"})
    @PutMapping(value={"/{model_name:.+}/segments/multi_partition"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> refreshMultiPartition(@PathVariable(value="model_name") String modelAlias, @RequestBody PartitionsRefreshRequest param) {
        String projectName = this.checkProjectName(param.getProject());
        this.checkProjectMLP(projectName);
        param.setProject(projectName);
        String modelId = this.getModel(modelAlias, param.getProject()).getId();
        return this.segmentController.refreshMultiPartition(modelId, param);
    }

    @ApiOperation(value="delete multi_partition", tags={"DW"})
    @DeleteMapping(value={"/segments/multi_partition"})
    @ResponseBody
    public EnvelopeResponse<String> deleteMultiPartition(@RequestParam(value="model") String modelAlias, @RequestParam(value="project") String project, @RequestParam(value="segment_id") String segmentId, @RequestParam(value="sub_partition_values") List<String[]> subPartitionValues) {
        String projectName = this.checkProjectName(project);
        this.checkProjectMLP(projectName);
        this.checkRequiredArg("sub_partition_values", subPartitionValues);
        OpenSegmentController.checkMLP("sub_partition_values", subPartitionValues);
        NDataModel model = this.getModel(modelAlias, projectName);
        this.modelService.deletePartitionsByValues(project, segmentId, model.getId(), subPartitionValues);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    private void checkProjectMLP(String project) {
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project);
        if (!projectInstance.getConfig().isMultiPartitionEnabled()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_MULTI_PARTITION_DISABLE, new Object[]{projectInstance.getName()});
        }
    }

    static void checkMLP(String fieldName, List<String[]> subPartitionValues) {
        if (subPartitionValues.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, "'%s' cannot be empty.", fieldName));
        }
    }
}

